/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public final class MigrationConfig
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dbtools.migration.workbench.core.preferences.MigrationWorkbenchOptions";
    private static final String KEY_END_ROW_DELIMITER = "EndRowDelimiter";
    private static final String DEFAULT_END_ROW_DELIMITER = "<EORD>";
    private static final String KEY_NAME_PREFIX = "NamePrefix";
    private static final String DEFAULT_NAME_PREFIX = "";
    private static final String KEY_END_COLUMN_DELIMITER = "EndColumnDelimiter";
    private static final String DEFAULT_END_COLUMN_DELIMITER = "<EOFD>";
    private static final String KEY_GENERATION_DIRECTORY = "OfflineGenerationDirectory";
    private static final String KEY_OFFLINE_DATAMOVE_SCRIPT_DIRECTORY = "DataMoveScriptDirectory";
    private static final String KEY_DATAMOVE_PARALLELISM = "DataMoveParallelism";
    private static final int DEFAULT_DATA_MOVE_PARALLELISM = 5;
    private static final String KEY_DATAMOVE_COMMITINTERVAL = "DataMoveCommitInterval";
    private static final int DEFAULT_DATA_MOVE_COMMIT_INTERVAL = 100;
    public static final int FILE_OUTPUT_SINGLE = 0;
    public static final int FILE_OUTPUT_PER_OBJECTTYPE = 1;
    public static final int FILE_OUTPUT_PER_OBJECT = 2;
    public static final int UNLIMITED_LINES = -1;
    private static final String KEY_FILE_OUTPUT_OPTION = "FileOutputOption";
    private static final int DEFAULT_FILE_OUTPUT_OPTION = 0;
    private static final String KEY_OUTPUT_FILE_OR_DIR = "FileOutputTarget";
    private static final String KEY_GENERATE_CREATE_OR_REPLACE = "GenerateCreateOrReplace";
    private static final String KEY_GENERATE_COMMENTS = "GenerateComments";
    private static final String KEY_GENERATE_CONTROLLING_SCRIPT = "GenerateControllingScript";
    private static final String KEY_MAX_LINES = "MaxLinesPerFile";
    public static final String KEY_MIGRATION_REPOSITORIES = "MigrationRepositories";
    public static final String KEY_DEFAULT_REPOSITORY = "DefaultRepository";
    private static final String EMPTY_REPOSITORY = "";
    private static final String KEY_UA_CODE = "UserAgentCode";
    private static final String KEY_SINGLE_SCHEMA_LEAST_PRIVILEGE = "SingleSchemaLeastPrivilege";
    private static final String DEFAULT_DATE_OFFLINE_DATA_MOVE_DATEMASK = "yyyy-mm-dd HH24:mi:ss";
    private static final String DEFAULT_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK = "yyyy-mm-dd HH24:mi:ss.ff3";
    private static final String KEY_DATE_OFFLINE_DATA_MOVE_DATEMASK = "OfflineDateMask";
    private static final String KEY_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK = "OfflineTimestampMask";
    private static final String KEY_GENERATE_FAILED_OBJECTS = "GeneratedFailedObjects";
    private static final String KEY_DATA_MOVE_ZERO_LENGTH_STRING_IS_SPACE = "DataMoveZeroLengthStringIsSpace";
    private static final String KEY_GENERATE_CLOB_TO_BLOB = "OfflineClobToBlob";
    public static final boolean DEFAULT_ISQUOTEDIDENTIFIERONSQLSERVER = true;
    private static final String KEY_ISQUOTEDIDENTIFIERONSQLSERVER = "ISQUOTEDIDENTIFIERONSQLSERVER";
    public static final boolean DEFAULT_ISQUOTEDIDENTIFIERONSYBASE = false;
    private static final String KEY_ISQUOTEDIDENTIFIERONSYBASE = "ISQUOTEDIDENTIFIERONSYBASE";
    public static final boolean DEFAULT_ISORACLE128BYTEIDENTIFIER = false;
    private static final String KEY_ISORACLE128BYTEIDENTIFIER = "ISORACLE128BYTEIDENTIFIER";
    private static final String KEY_SOURCECONN = "SOURCECONN";
    private static final String KEY_TARGETCONN = "TARGETCONN";
    private static final String KEY_SOURCEMODELID = "SOURCEMODELID";
    private static final String KEY_TARGETMODELID = "TARGETMODELID";
    private static final String GENERATEENTIREEMULATIONPKG = "GENERATEENTIREEMULATIONPKG";
    private static final String TARGET12C = "TARGET12C";
    private static final String CREATE_USER = "CREATE_USER";
    public static final String CLUSTERED_TO_IOT = "CLUSTERED_TO_IOT";
    public static final int IOT_NONE_INT = 0;
    public static final int IOT_PROMOTE_UNIQUE_INT = 1;
    public static final int IOT_PRIMARY_KEYS_INT = 2;
    private static final String KEY_GENERIC_DATE_MASK = "GENERIC_DATE_MASK";
    private static final String DEFAULT_GENERIC_DATE_MASK = "";
    public static final boolean DEFAULT_USECOMPOUNDTRIGGER = false;
    private static final String KEY_OBJECTTYPE_CHECLALL = "ObjectType_CheclAll";
    private static final String KEY_OBJECTTYPE_TABLES = "ObjectType_Tables";
    private static final String KEY_OBJECTTYPE_VIEWS = "ObjectType_Views";
    private static final String KEY_OBJECTTYPE_SEQUENCES = "ObjectType_Sequences";
    private static final String KEY_OBJECTTYPE_PROCEDURES = "ObjectType_Procedures";
    private static final String KEY_OBJECTTYPE_FUNCTIONS = "ObjectType_Functions";
    private static final String KEY_OBJECTTYPE_PACKAGES = "ObjectType_Packages";
    private static final String KEY_OBJECTTYPE_SYNONYMNS = "ObjectType_Synonyms";
    private static final String KEY_OBJECTTYPE_TRIGGERS = "ObjectType_Triggers";
    private static final String KEY_OBJECTTYPE_INDEXES = "ObjectType_Indexes";

    private MigrationConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static MigrationConfig getInstance(PropertyStorage propertyStorage) {
        return new MigrationConfig(MigrationConfig.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
    }

    public void setTimestampOfflineDateMask(String string) {
        if (string != null) {
            this._hash.putString(KEY_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK, string);
        }
    }

    public String getDateOfflineDateMask() {
        return this._hash.getString(KEY_DATE_OFFLINE_DATA_MOVE_DATEMASK, DEFAULT_DATE_OFFLINE_DATA_MOVE_DATEMASK);
    }

    public void setGenericDateOfflineDateMask(String string) {
        if (string != null) {
            this._hash.putString(KEY_GENERIC_DATE_MASK, string);
        } else {
            this._hash.putString(KEY_GENERIC_DATE_MASK, "");
        }
    }

    public String getGenericDateOfflineDateMask() {
        return this._hash.getString(KEY_GENERIC_DATE_MASK, "");
    }

    public void setDateOfflineDateMask(String string) {
        if (string != null) {
            this._hash.putString(KEY_DATE_OFFLINE_DATA_MOVE_DATEMASK, string);
        }
    }

    public String getTimeStampOfflineDateMask() {
        return this._hash.getString(KEY_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK, DEFAULT_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK);
    }

    public String getEndColumnDelimiter() {
        return this._hash.getString(KEY_END_COLUMN_DELIMITER, DEFAULT_END_COLUMN_DELIMITER);
    }

    public void setEndColumnDelimiter(String string) {
        if (string != null) {
            this._hash.putString(KEY_END_COLUMN_DELIMITER, string);
        }
    }

    public String getEndRowDelimiter() {
        return this._hash.getString(KEY_END_ROW_DELIMITER, DEFAULT_END_ROW_DELIMITER);
    }

    public void setEndRowDelimiter(String string) {
        if (string != null) {
            this._hash.putString(KEY_END_ROW_DELIMITER, string);
        }
    }

    public String getNamePrefix() {
        return this._hash.getString(KEY_NAME_PREFIX, "");
    }

    public void setNamePrefix(String string) {
        if (string != null) {
            this._hash.putString(KEY_NAME_PREFIX, string);
        }
    }

    public boolean isQuotedIdentifierOnSQLServer() {
        return this._hash.getBoolean(KEY_ISQUOTEDIDENTIFIERONSQLSERVER, true);
    }

    public void setisQuotedIdentifierOnSQLServer(boolean bl) {
        this._hash.putBoolean(KEY_ISQUOTEDIDENTIFIERONSQLSERVER, bl);
    }

    public boolean isQuotedIdentifierOnSybase() {
        return this._hash.getBoolean(KEY_ISQUOTEDIDENTIFIERONSYBASE, false);
    }

    public void setisQuotedIdentifierOnSybase(boolean bl) {
        this._hash.putBoolean(KEY_ISQUOTEDIDENTIFIERONSYBASE, bl);
    }

    public boolean isOracle128ByteIdentifier() {
        return this._hash.getBoolean(KEY_ISORACLE128BYTEIDENTIFIER, false);
    }

    public void setisOracle128ByteIdentifier(boolean bl) {
        this._hash.putBoolean(KEY_ISORACLE128BYTEIDENTIFIER, bl);
    }

    public int getFileOutputOption() {
        return this._hash.getInt(KEY_FILE_OUTPUT_OPTION, 0);
    }

    public void setFileOutputOption(int n) {
        if (n >= 0 && n <= 2) {
            this._hash.putInt(KEY_FILE_OUTPUT_OPTION, n);
        }
    }

    public boolean getGenerateComments() {
        return this._hash.getBoolean(KEY_GENERATE_COMMENTS, true);
    }

    public void setEmptyStringIsSpace(boolean bl) {
        this._hash.putBoolean(KEY_DATA_MOVE_ZERO_LENGTH_STRING_IS_SPACE, bl);
    }

    public boolean getEmptyStringIsSpace() {
        return this._hash.getBoolean(KEY_DATA_MOVE_ZERO_LENGTH_STRING_IS_SPACE, true);
    }

    public void setGenerateComments(boolean bl) {
        this._hash.putBoolean(KEY_GENERATE_COMMENTS, bl);
    }

    public boolean getGenerateControllingScript() {
        return this._hash.getBoolean(KEY_GENERATE_CONTROLLING_SCRIPT, true);
    }

    public void setGenerateControllingScript(boolean bl) {
        this._hash.putBoolean(KEY_GENERATE_CONTROLLING_SCRIPT, bl);
    }

    public boolean getCreateOrReplaceFlag() {
        return this._hash.getBoolean(KEY_GENERATE_CREATE_OR_REPLACE, true);
    }

    public void setCreateOrReplaceFlag(boolean bl) {
        this._hash.putBoolean(KEY_GENERATE_CREATE_OR_REPLACE, bl);
    }

    public int getMaxNumberOfLines() {
        return this._hash.getInt(KEY_MAX_LINES, -1);
    }

    public void setMaxNumberOfLines(int n) {
        if (n <= 0) {
            this._hash.putInt(KEY_MAX_LINES, -1);
        } else {
            this._hash.putInt(KEY_MAX_LINES, n);
        }
    }

    public String getDefaultRepository() {
        return this._hash.getString(KEY_DEFAULT_REPOSITORY, "");
    }

    public synchronized void setDefaultRepository(String string) {
        if (string != null) {
            this._hash.putString(KEY_DEFAULT_REPOSITORY, string);
        }
    }

    public int getNumDataMoveThreads() {
        return this._hash.getInt(KEY_DATAMOVE_PARALLELISM, 5);
    }

    public void setNumDataMoveThreads(int n) {
        if (n > 0) {
            this._hash.putInt(KEY_DATAMOVE_PARALLELISM, n);
        }
    }

    public String getOfflineDataMoveScriptDirectory() {
        return this._hash.getString(KEY_OFFLINE_DATAMOVE_SCRIPT_DIRECTORY, System.getProperty("user.home"));
    }

    public void setOfflinedataMoveScriptDirectory(String string) {
        if (string != null) {
            this._hash.putString(KEY_OFFLINE_DATAMOVE_SCRIPT_DIRECTORY, string);
        }
    }

    private ListStructure getRepositoryListStructure() {
        ListStructure listStructure = this._hash.getListStructure(KEY_MIGRATION_REPOSITORIES);
        if (listStructure == null) {
            listStructure = ListStructure.newInstance();
            this._hash.putListStructure(KEY_MIGRATION_REPOSITORIES, listStructure);
        }
        return listStructure;
    }

    public void addRepository(String string) {
        ListStructure listStructure = this.getRepositoryListStructure();
        listStructure.clear();
        listStructure.add((Object)string);
    }

    public void removeRepository(String string) {
        ListStructure listStructure = this.getRepositoryListStructure();
        listStructure.clear();
        this.setDefaultRepository("");
    }

    public String[] getRepositories() {
        ListStructure listStructure = this.getRepositoryListStructure();
        if (listStructure == null) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        return (String[])listStructure.toArray((Object[])new String[listStructure.size()]);
    }

    public void setTargetConn(String string) {
        this._hash.putString(KEY_TARGETCONN, string);
    }

    public void setSourceConn(String string) {
        this._hash.putString(KEY_SOURCECONN, string);
    }

    public String getTargetConn() {
        return this._hash.getString(KEY_TARGETCONN);
    }

    public String getSourceConn() {
        return this._hash.getString(KEY_SOURCECONN);
    }

    public boolean isRepository(String string) {
        String[] stringArray;
        for (String string2 : stringArray = this.getRepositories()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.addStructureChangeListener(structureChangeListener);
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.removeStructureChangeListener(structureChangeListener);
    }

    public int getDataMoveCommitInterval() {
        return this._hash.getInt(KEY_DATAMOVE_COMMITINTERVAL, 100);
    }

    public void setDataMoveCommitInterval(int n) {
        if (n < 1) {
            this._hash.putInt(KEY_DATAMOVE_COMMITINTERVAL, 1);
        } else {
            this._hash.putInt(KEY_DATAMOVE_COMMITINTERVAL, n);
        }
    }

    public int getUACode() {
        return this._hash.getInt(KEY_UA_CODE, 0);
    }

    public void setUACode(int n) {
        this._hash.putInt(KEY_UA_CODE, n);
    }

    public void updateUACode(int n) {
        int n2 = this.getUACode();
        this.setUACode(n2 |= n);
    }

    public boolean getSingleSchemaLeastPrivilege() {
        return this._hash.getBoolean(KEY_SINGLE_SCHEMA_LEAST_PRIVILEGE, false);
    }

    public void setSingleSchemaLeastPrivilege(boolean bl) {
        this._hash.putBoolean(KEY_SINGLE_SCHEMA_LEAST_PRIVILEGE, bl);
    }

    public boolean getGenerateClobToBlob() {
        return this._hash.getBoolean(KEY_GENERATE_CLOB_TO_BLOB, true);
    }

    public void setGenerateClobToBlob(boolean bl) {
        this._hash.putBoolean(KEY_GENERATE_CLOB_TO_BLOB, bl);
    }

    public void setIOTOption(int n) {
        this._hash.putInt(CLUSTERED_TO_IOT, n);
    }

    public int getIOTOption() {
        return this._hash.getInt(CLUSTERED_TO_IOT, 0);
    }

    public boolean getBooleanProperty(String string) {
        return this._hash.getBoolean(string, false);
    }

    public void setBooleanProperty(String string, boolean bl) {
        this._hash.putBoolean(string, bl);
    }

    public void setStringProperty(String string, String string2) {
        if (string2 != null) {
            this._hash.putString(string, string2);
        }
    }

    public String getStringProperty(String string, String string2) {
        return this._hash.getString(string, string2);
    }

    public boolean getGenerateFailedObjects() {
        return this._hash.getBoolean(KEY_GENERATE_FAILED_OBJECTS, false);
    }

    public void setGenerateFailedObjects(boolean bl) {
        this._hash.putBoolean(KEY_GENERATE_FAILED_OBJECTS, bl);
    }

    public String getCapturedModelId() {
        return this._hash.getString(KEY_SOURCEMODELID);
    }

    public String getConvertedModelId() {
        return this._hash.getString(KEY_TARGETMODELID);
    }

    public void setCapturedModelId(String string) {
        this._hash.putString(KEY_SOURCEMODELID, string);
    }

    public void setConvertedModelId(String string) {
        this._hash.putString(KEY_TARGETMODELID, string);
    }

    public boolean getGenerateEntireEmulationPkg() {
        Boolean bl = true;
        if (this._hash.containsKey(GENERATEENTIREEMULATIONPKG)) {
            bl = this._hash.getBoolean(GENERATEENTIREEMULATIONPKG);
        }
        return bl;
    }

    public void setGenerateEntireEmulationPkg(boolean bl) {
        this._hash.putBoolean(GENERATEENTIREEMULATIONPKG, bl);
    }

    public boolean getCreateUser() {
        boolean bl = this._hash.getBoolean(CREATE_USER, true);
        return bl;
    }

    public void setCreateUser(boolean bl) {
        this._hash.putBoolean(CREATE_USER, bl);
    }

    public boolean getGenObjectTypeCheckAll() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_CHECLALL, true);
    }

    public void setGenObjectTypeCheckAll(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_CHECLALL, bl);
    }

    public boolean getGenObjectTypeTables() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_TABLES, true);
    }

    public void setGenObjectTypeTables(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_TABLES, bl);
    }

    public boolean getGenObjectTypeViews() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_VIEWS, true);
    }

    public void setGenObjectTypeViews(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_VIEWS, bl);
    }

    public boolean getGenObjectTypeSequences() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_SEQUENCES, true);
    }

    public void setGenObjectTypeSequences(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_SEQUENCES, bl);
    }

    public boolean getGenObjectTypeProcedures() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_PROCEDURES, true);
    }

    public void setGenObjectTypeProcedures(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_PROCEDURES, bl);
    }

    public boolean getGenObjectTypeFunctions() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_FUNCTIONS, true);
    }

    public void setGenObjectTypeFunctions(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_FUNCTIONS, bl);
    }

    public boolean getGenObjectTypePackages() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_PACKAGES, true);
    }

    public void setGenObjectTypePackages(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_PACKAGES, bl);
    }

    public boolean getGenObjectTypeSynonyms() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_SYNONYMNS, true);
    }

    public void setGenObjectTypeSynonyms(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_SYNONYMNS, bl);
    }

    public boolean getGenObjectTypeTriggers() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_TRIGGERS, true);
    }

    public void setGenObjectTypeTriggers(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_TRIGGERS, bl);
    }

    public boolean getGenObjectTypeIndexes() {
        return this._hash.getBoolean(KEY_OBJECTTYPE_INDEXES, true);
    }

    public void setGenObjectTypeIndexes(boolean bl) {
        this._hash.putBoolean(KEY_OBJECTTYPE_INDEXES, bl);
    }

    public boolean getTarget12c() {
        return this._hash.getBoolean(TARGET12C);
    }

    public void setTarget12c(boolean bl) {
        this._hash.putBoolean(TARGET12C, bl);
    }
}

