/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.actions;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.core.NavigatorManager;
import oracle.dbtools.raptor.navigator.db.model.CategoryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBTypeOwnerInstance;
import oracle.dbtools.raptor.navigator.impl.CategoryFolder;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportDataProvider;
import oracle.dbtools.raptor.oviewer.base.ConnectionExportTask;
import oracle.dbtools.raptor.oviewer.base.HTMLTabFormatter;
import oracle.dbtools.raptor.oviewer.base.Messages;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.util.Indenter;
import oracle.dbtools.util.Logger;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;

public class MigrationDBDoc
extends ConnectionExportDataProvider {
    private JPanel optionsPanel;
    private URLFileChooser.URLFileChooserPanel fileChooser;
    private JCheckBox includeChildNodes;
    private JCheckBox includeChildReports;
    private static File lastDirectory;

    public boolean isEnabled(Context context) {
        return true;
    }

    protected JComponent getOptionsPanel(DBObject dBObject) {
        if (null == this.optionsPanel) {
            this.optionsPanel = LayoutControl.GBC.createPanel();
            this.fileChooser = URLFileChooser.createURLFileChooserPanel((int)1, (String)Messages.getString((String)"MigrationDBDoc.fileChooser.Label"));
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setToolTipText(Messages.getString((String)"MigrationDBDoc.OutputDirectoryChooser.Title"));
            if (lastDirectory != null) {
                this.fileChooser.setCurrentDirectory(lastDirectory);
            }
            this.includeChildNodes = new JCheckBox();
            this.includeChildNodes.setName("includeChildNodes");
            ResourceUtils.resButton((AbstractButton)this.includeChildNodes, (String)Messages.getString((String)"MigrationDBDoc.includeChildNodes.Label"));
            this.includeChildNodes.setToolTipText(Messages.getString((String)"MigrationDBDoc.includeChildNodes.Tip"));
            this.includeChildNodes.setSelected(false);
            this.includeChildReports = new JCheckBox();
            this.includeChildReports.setName("includeChildReports");
            ResourceUtils.resButton((AbstractButton)this.includeChildReports, (String)Messages.getString((String)"MigrationDBDoc.includeChildReports.Label"));
            this.includeChildReports.setToolTipText(Messages.getString((String)"MigrationDBDoc.includeChildReports.Tip"));
            this.includeChildReports.setSelected(true);
            int n = 0;
            this.optionsPanel.add((Component)this.fileChooser, LayoutControl.GBC.gbc((int)0, (int)n++, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.optionsPanel.add((Component)this.includeChildNodes, LayoutControl.GBC.gbc((int)0, (int)n++, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
            this.optionsPanel.add((Component)this.includeChildReports, LayoutControl.GBC.gbc((int)0, (int)n++, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
            LayoutControl.GBC.addVSpring((JPanel)this.optionsPanel, (int)n);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.optionsPanel, "f1_generatemigrationdbdoc_html");
        }
        return this.optionsPanel;
    }

    protected File getSelectedOutputDir() {
        lastDirectory = this.fileChooser.getCurrentDirectory();
        return lastDirectory;
    }

    protected DatabaseQueryTask<File> getTask(File file, DBObject dBObject) {
        MigrationDBDocTask migrationDBDocTask = new MigrationDBDocTask(((Object)((Object)this)).getClass().getSimpleName(), file, dBObject, this.includeChildNodes.isSelected(), this.includeChildReports.isSelected());
        DBFolderInstance[] dBFolderInstanceArray = new DBFolderInstance[]{};
        migrationDBDocTask.setFilter(dBFolderInstanceArray);
        migrationDBDocTask.setGenerateEmptyTypes(true);
        return migrationDBDocTask;
    }

    public static class ElementParentChildrenMapProvider
    extends DatabaseQueryTask<Map<Element, List<Element>>> {
        private Element element;
        private String connectionName;
        private NavigatorManager navigatorManager;
        private boolean includeChildNodes;
        private Map<Element, List<Element>> parentChildrenMap = new Hashtable<Element, List<Element>>();
        private List<Callable<?>> childProviders = new ArrayList();
        private Observer elementUpdateListener = new Observer(){

            public void update(Object object, UpdateMessage updateMessage) {
                int n = updateMessage.getMessageID();
                if (UpdateMessage.CHILD_ADDED == n) {
                    List list = updateMessage.getAddObjects();
                    if (list.size() == 1 && list.get(0) == DummyElement.INSTANCE) {
                        return;
                    }
                    parentChildrenMap.put((Element)object, list);
                }
            }
        };

        public ElementParentChildrenMapProvider(Element element, String string, NavigatorManager navigatorManager, boolean bl) {
            super(element.getShortLabel() + "-" + ElementParentChildrenMapProvider.class.getSimpleName(), IRaptorTaskRunMode.IDE_STATUSBAR, true, true, true);
            this.element = element;
            this.connectionName = string;
            this.navigatorManager = navigatorManager;
            this.includeChildNodes = bl;
            this.setMessage(this.getDescriptor().getName());
            this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                    String string = raptorTaskEvent.getTaskDescriptor().getStatus().value();
                    this.setMessage(string);
                }
            });
        }

        public String getConnectionName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public String getQuery() {
            return null;
        }

        protected Map<Element, List<Element>> doWork() throws TaskException {
            try {
                this.checkCanProceed();
                if (this.includeChildNodes) {
                    this.loadChildren(this.element);
                    int n = 0;
                    while (this.hasProviders()) {
                        int n2 = this.childProviders.size();
                        if (n != n2) {
                            n = n2;
                            Logger.info(((Object)((Object)this)).getClass(), (String)("childProviders[" + n2 + "] parentChildrenMap[" + this.parentChildrenMap.size() + "]"));
                        }
                        Thread.yield();
                    }
                }
                return this.parentChildrenMap;
            }
            catch (Exception exception) {
                Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
                throw new TaskException((Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addProvider(Callable<?> callable) {
            List<Callable<?>> list = this.childProviders;
            synchronized (list) {
                this.childProviders.add(callable);
                Logger.info(((Object)((Object)this)).getClass(), (String)(this.childProviders.size() + " addProvider " + callable));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeProvider(Callable<?> callable) {
            List<Callable<?>> list = this.childProviders;
            synchronized (list) {
                this.childProviders.remove(callable);
                Logger.info(((Object)((Object)this)).getClass(), (String)(this.childProviders.size() + " removeProvider " + callable));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasProviders() {
            boolean bl = false;
            List<Callable<?>> list = this.childProviders;
            synchronized (list) {
                bl = !this.childProviders.isEmpty();
            }
            return bl;
        }

        private void loadChildren(Element element) {
            this.getChildren(element, true);
            final ElementChildrenProvider elementChildrenProvider = new ElementChildrenProvider(element, this.connectionName, this.includeChildNodes);
            this.addProvider((Callable<?>)((Object)elementChildrenProvider));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorTaskManager.getInstance().addTask((RaptorTask)elementChildrenProvider);
                }
            });
        }

        private Iterator<Element> getChildren(Element element, boolean bl) {
            Iterator<Element> iterator;
            List<Element> list = this.parentChildrenMap.get(element);
            if (list != null) {
                iterator = list.iterator();
            } else if (element instanceof SchemaFolder) {
                SchemaFolder schemaFolder = (SchemaFolder)element;
                List<Element> list2 = this.loadSchemaChildren(schemaFolder);
                this.parentChildrenMap.put(element, list2);
                iterator = list2.iterator();
            } else {
                if (bl && element instanceof Subject) {
                    ((Subject)element).attach(this.elementUpdateListener);
                }
                iterator = element.getChildren();
            }
            Logger.fine(((Object)((Object)this)).getClass(), (String)("getChildren(" + element + ", " + bl + ") returning " + iterator));
            return iterator;
        }

        private List<Element> loadSchemaChildren(SchemaFolder schemaFolder) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            try {
                URL uRL = schemaFolder.getURL();
                String string = DBURLFormatHelper.getConnectionName((URL)uRL);
                DBSchemaInstance dBSchemaInstance = schemaFolder.getSchemaInstance();
                ObjectFactory objectFactory = dBSchemaInstance.getObjectFactory();
                if (objectFactory != null) {
                    String string2;
                    String string3 = (String)dBSchemaInstance.getProperty("CATALOG");
                    if (string3 == null) {
                        string3 = DBURLFormatHelper.getCatalog((URL)uRL);
                    }
                    if ((string2 = (String)dBSchemaInstance.getProperty("SCHEMA")) == null) {
                        string2 = DBURLFormatHelper.getSchema((URL)uRL);
                    }
                    String string4 = string3;
                    String string5 = string2;
                    String string6 = schemaFolder.getURL().getProtocol();
                    arrayList.addAll(this.loadTypeFolders((DBTypeOwnerInstance)dBSchemaInstance, string, string4, string5, string6));
                    if (string6 != null) {
                        for (CategoryInstance categoryInstance : dBSchemaInstance.listCategories()) {
                            URL uRL2 = DBURLFormatHelper.getURL((String)string6, (String)string, (String)string4, (String)string5, (String)categoryInstance.getDescriptor().getType());
                            arrayList.add((Element)new CategoryFolder(uRL2, categoryInstance));
                        }
                    }
                }
            }
            catch (Exception exception) {
                Logger.severe(((Object)((Object)this)).getClass(), (String)"Problem loading schema children (type folders)", (Throwable)exception);
            }
            return arrayList;
        }

        protected final List<Element> loadTypeFolders(DBTypeOwnerInstance dBTypeOwnerInstance, String string, String string2, String string3, String string4) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            if (string4 != null) {
                for (DBFolderInstance dBFolderInstance : dBTypeOwnerInstance.listTypeFolders()) {
                    URL uRL = DBURLFormatHelper.getURL((String)string4, (String)string, (String)string2, (String)string3, (String)dBFolderInstance.getType());
                    Element element = this.createTypeFolder(dBFolderInstance, uRL);
                    arrayList.add(element);
                }
            }
            return arrayList;
        }

        private Element createTypeFolder(DBFolderInstance dBFolderInstance, URL uRL) {
            return DatabaseNavigatorElementFactory.getTypeFolder((URL)uRL, (DBFolderInstance)dBFolderInstance);
        }

        private class ElementChildrenProvider
        extends DatabaseQueryTask<Void> {
            private Element element;
            private String connectionName;
            private boolean includeChildNodes;

            public ElementChildrenProvider(Element element, String string, boolean bl) {
                super(element.getShortLabel() + "-" + ElementChildrenProvider.class.getSimpleName(), IRaptorTaskRunMode.IDE_STATUSBAR, true, true, true);
                this.element = element;
                this.connectionName = string;
                this.includeChildNodes = bl;
                this.setMessage(this.getDescriptor().getName());
                this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                        String string = raptorTaskEvent.getTaskDescriptor().getStatus().value();
                        ElementChildrenProvider.this.setMessage(string);
                    }
                });
            }

            public String getConnectionName() {
                return this.connectionName;
            }

            public String getQuery() {
                return null;
            }

            protected Void doWork() throws TaskException {
                try {
                    this.checkCanProceed();
                    ArrayList<Element> arrayList = new ArrayList<Element>();
                    Iterator iterator = ElementParentChildrenMapProvider.this.getChildren(this.element, false);
                    if (iterator != null) {
                        while (iterator.hasNext()) {
                            Element element = (Element)iterator.next();
                            if (DummyElement.INSTANCE == element) {
                                Logger.warn(((Object)((Object)this)).getClass(), (String)("Child == DummyElement.INSTANCE for " + this.element));
                                continue;
                            }
                            if (!(element instanceof ChildObjectElement)) {
                                arrayList.add(element);
                                if (!this.includeChildNodes) continue;
                                this.checkCanProceed();
                                ElementParentChildrenMapProvider.this.loadChildren(element);
                                continue;
                            }
                            Logger.fine(((Object)((Object)this)).getClass(), (String)("Skipping " + ((ChildObjectElement)element).getURL().toString()));
                        }
                    }
                    ElementParentChildrenMapProvider.this.parentChildrenMap.put(this.element, arrayList);
                }
                catch (Exception exception) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    ElementParentChildrenMapProvider.this.removeProvider((Callable)((Object)this));
                }
                return null;
            }
        }
    }

    public static class MigrationDBDocTask
    extends ConnectionExportTask {
        private String EOL;
        private String privateConnectionName;
        private Element rootElement;
        private boolean includeChildNodes;
        private boolean includeChildReports;
        private static String UP_DIR = "../";
        private static Indenter INDENTER = new Indenter();

        public MigrationDBDocTask(String string, File file, DBObject dBObject, boolean bl, boolean bl2) {
            super(string, file, dBObject);
            EnvironOptions environOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            this.EOL = environOptions.getLineBreakSequence();
            this.includeChildNodes = bl;
            this.includeChildReports = bl2;
            this.privateConnectionName = dBObject.getConnectionName();
            if (dBObject.getNode() instanceof MigrationProjectNode) {
                MigrationProjectNode migrationProjectNode = (MigrationProjectNode)dBObject.getNode();
                MigrationProjectNode migrationProjectNode2 = new MigrationProjectNode(migrationProjectNode.getShortLabel(), migrationProjectNode.getMdProject());
                this.rootElement = migrationProjectNode2;
            } else {
                this.rootElement = dBObject.getElement();
            }
            this.setMessage(this.getDescriptor().getName());
        }

        public String getConnectionName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        protected void createNodeTypes(File file) throws IOException, ExecutionException {
            Object object2;
            this.setProgressbarMsg(OBResourcesArb.getString((String)"DBDOC_GENERATE_OBJ_TYPE"));
            this.checkCanProceed();
            List list = FileUtils.getFilesInPackage((String)"oracle.dbtools.migration.workbench.core.actions", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"MigrationDBDocIndex.html");
            for (Object object2 : list) {
                if (this.copyResourceFile(file, (URL)object2, "index.html")) continue;
                Logger.severe(((Object)((Object)this)).getClass(), (String)this.getDescriptor().getMessage());
            }
            Object object3 = new ElementParentChildrenMapProvider(this.rootElement, this.privateConnectionName, MigrationProjectNavigatorManager.getInstance(), this.includeChildNodes);
            SwingUtilities.invokeLater(new Runnable((ElementParentChildrenMapProvider)((Object)object3)){
                final /* synthetic */ ElementParentChildrenMapProvider val$provider;
                {
                    this.val$provider = elementParentChildrenMapProvider;
                }

                @Override
                public void run() {
                    RaptorTaskManager.getInstance().addTask((RaptorTask)this.val$provider);
                }
            });
            if (SwingUtilities.isEventDispatchThread()) {
                throw new UnsupportedOperationException("MUST NOT do this on dispatch thread - it will block");
            }
            object2 = new Hashtable();
            try {
                object2 = (Map)object3.getResult();
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
            Logger.fine(((Object)((Object)this)).getClass(), (String)("parentChildrenMap: " + object2.toString()));
            final HtmlOutput htmlOutput = new HtmlOutput(this.rootElement, this.privateConnectionName, file, (Map<Element, List<Element>>)object2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorTaskManager.getInstance().addTask((RaptorTask)htmlOutput);
                }
            });
            try {
                htmlOutput.getResult();
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
        }

        class HtmlOutput
        extends DatabaseQueryTask<Boolean> {
            String connectionName;
            File directory;
            Map<Element, List<Element>> parentChildrenMap;

            public HtmlOutput(Element element, String string, File file, Map<Element, List<Element>> map) {
                super(element.getShortLabel() + "-" + HtmlOutput.class.getSimpleName(), IRaptorTaskRunMode.IDE_STATUSBAR, true, true, true);
                this.connectionName = string;
                this.directory = file;
                this.parentChildrenMap = map;
                this.setMessage(this.getDescriptor().getName());
                this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                        String string = raptorTaskEvent.getTaskDescriptor().getStatus().value();
                        HtmlOutput.this.setMessage(string);
                    }
                });
            }

            public String getConnectionName() {
                return this.connectionName;
            }

            public String getQuery() {
                return null;
            }

            protected Boolean doWork() throws TaskException {
                Writer writer = null;
                try {
                    writer = ConnectionExportTask.getFileWriter((String)(this.directory.getAbsolutePath() + "/nodeTypes.html"));
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + MigrationDBDocTask.this.EOL);
                    writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"");
                    writer.write(" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">" + MigrationDBDocTask.this.EOL);
                    writer.write("<html>" + MigrationDBDocTask.this.EOL);
                    MigrationDBDocTask.writeStyleSheetTag((Writer)writer, (String)"./");
                    String string = MigrationDBDocTask.this.rootElement.getShortLabel();
                    String string2 = ConnectionExportTask.getEncodedURLName((String)string);
                    writer.write("<body id=\"top_left\">" + MigrationDBDocTask.this.EOL);
                    writer.write("<h2>" + string + "</h2>" + MigrationDBDocTask.this.EOL);
                    writer.write(this.buildNodeTree(this.directory, MigrationDBDocTask.this.rootElement, this.parentChildrenMap));
                }
                catch (Exception exception) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
                    throw new TaskException((Throwable)exception);
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.write(MigrationDBDocTask.this.EOL + "</body> </html>" + MigrationDBDocTask.this.EOL);
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.severe(((Object)((Object)this)).getClass(), (Throwable)iOException);
                    }
                }
                return true;
            }

            private String buildNodeTree(File file, Element element, Map<Element, List<Element>> map) throws IOException, ExecutionException {
                StringBuilder stringBuilder = new StringBuilder(1024);
                String string = element.getShortLabel();
                String string2 = ConnectionExportTask.getEncodedURLName((String)string);
                File file2 = new File(file.getAbsolutePath() + "/" + string2);
                file2.mkdir();
                stringBuilder.append("<ul name=\"Tree\">").append(MigrationDBDocTask.this.EOL);
                stringBuilder.append(INDENTER.getIndent(1) + "<li>");
                boolean bl = this.buildNodeDetails(element, string, string2, file2, UP_DIR);
                if (bl) {
                    stringBuilder.append("<a href=\"");
                    stringBuilder.append(string2);
                    stringBuilder.append("/");
                    stringBuilder.append(string2);
                    stringBuilder.append(".html\"");
                    stringBuilder.append(" target=\"ObjectDetailsFrame\"");
                    stringBuilder.append(" id=\"");
                    stringBuilder.append(string2);
                    stringBuilder.append("\">");
                    stringBuilder.append(string);
                    stringBuilder.append("</a>");
                } else {
                    stringBuilder.append(string);
                }
                if (this.hasChildren(element, map)) {
                    stringBuilder.append("<ul>").append(MigrationDBDocTask.this.EOL);
                    this.appendNodeChildren(stringBuilder, element, string, string2, file2, map, UP_DIR + UP_DIR);
                    stringBuilder.append(INDENTER.getIndent(1) + "</ul>");
                }
                stringBuilder.append("</li>").append(MigrationDBDocTask.this.EOL);
                stringBuilder.append("</ul>").append(MigrationDBDocTask.this.EOL);
                this.checkCanProceed();
                return stringBuilder.toString();
            }

            private boolean hasChildren(Element element, Map<Element, List<Element>> map) {
                boolean bl = false;
                if (map.get(element) != null) {
                    for (Element element2 : map.get(element)) {
                        if (DummyElement.INSTANCE == element2) continue;
                        bl = true;
                        break;
                    }
                }
                return bl;
            }

            private void appendNodeChildren(StringBuilder stringBuilder, Element element, String string, String string2, File file, Map<Element, List<Element>> map, String string3) throws IOException, ExecutionException, UnsupportedEncodingException {
                this.checkCanProceed();
                if (!this.hasChildren(element, map)) {
                    return;
                }
                MigrationDBDocTask.this.setProgressbarMsg(Messages.getString((String)"ConnectionExportTask.3") + string2);
                for (Element element2 : map.get(element)) {
                    if (DummyElement.INSTANCE == element2) continue;
                    String string4 = element2.getShortLabel();
                    String string5 = ConnectionExportTask.getEncodedURLName((String)string4);
                    String string6 = string2 + "/" + string5;
                    File file2 = new File(file.getAbsolutePath() + "/" + string5);
                    file2.mkdir();
                    boolean bl = this.buildNodeDetails(element2, string4, string6, file2, string3);
                    boolean bl2 = this.hasChildren(element2, map);
                    int n = string3.length() / UP_DIR.length();
                    String string7 = INDENTER.getIndent(n);
                    stringBuilder.append(string7 + "<li>");
                    if (bl) {
                        stringBuilder.append("<a href=\"");
                        stringBuilder.append(string6);
                        stringBuilder.append("/");
                        stringBuilder.append(string5);
                        stringBuilder.append(".html\"");
                        stringBuilder.append(" target=\"ObjectDetailsFrame\"");
                        stringBuilder.append(" id=\"");
                        stringBuilder.append(string6);
                        stringBuilder.append("\">");
                        stringBuilder.append(string4);
                        stringBuilder.append("</a>");
                    } else {
                        stringBuilder.append(string4);
                    }
                    if (bl2) {
                        stringBuilder.append("<ul>").append(MigrationDBDocTask.this.EOL);
                        this.appendNodeChildren(stringBuilder, element2, string4, string6, file2, map, string3 + UP_DIR);
                        stringBuilder.append(string7 + "</ul>");
                    }
                    stringBuilder.append("</li>").append(MigrationDBDocTask.this.EOL);
                }
            }

            private boolean buildNodeDetails(Element element, String string, String string2, File file, String string3) throws ExecutionException, IOException {
                boolean bl = false;
                this.checkCanProceed();
                ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
                DBObject dBObject = new DBObject(element);
                List list = viewerAddin.getModels(dBObject);
                if (list == null || list.size() == 0) {
                    list = MigrationDBDocTask.this.buildPlSqlModels(dBObject);
                }
                if (list != null && list.size() > 0) {
                    for (DisplayModel displayModel : list) {
                        displayModel.setConnection(dBObject.getConnection());
                    }
                    HTMLTabFormatter hTMLTabFormatter = new HTMLTabFormatter(dBObject, list, dBObject.getDictionary(), file, string, string3, MigrationDBDocTask.this.includeChildReports);
                    bl = hTMLTabFormatter.start();
                }
                return bl;
            }
        }
    }
}

