/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import oracle.dbtools.migration.generate.BaseGeneration;
import oracle.dbtools.migration.generate.FileDumpGenerationOutputStream;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.Ide;

public class FilesPerObjectSqlGeneration
extends BaseGeneration {
    public FilesPerObjectSqlGeneration(GenerateWorker generateWorker) {
        super(generateWorker);
    }

    @Override
    public boolean startGeneration() throws GenerateException {
        this.generateRolesFile();
        this.generatePasswordDefinitionSqlFile();
        this.generateDropAllSchemasFile();
        this.generateReportAllStatusFileinMain();
        this.generateWrapperFile();
        this.createSchemaDirectories();
        if (MigrationAddin.getMigrationConfig().getCreateUser()) {
            this.generateUserFile();
        }
        this.generateEnableFile();
        this.generateDisableFile();
        this.generateDropObjectTypeFile();
        this.generateReportInvalidStatusFile();
        this.generateReportAllStatusFile();
        return true;
    }

    @Override
    public boolean startFileWriting(String string, String string2, String string3, BaseGeneration.GenerationType generationType) {
        boolean bl = false;
        if (generationType == BaseGeneration.GenerationType.OBJECTTYPE) {
            this.setOutputDir(this.getBaseDirectory() + File.separator + string);
            bl = this.setGenerationOutputStream(generationType, string2);
        } else if (generationType == BaseGeneration.GenerationType.OBJECT) {
            this.setOutputDir(this.getBaseDirectory() + File.separator + string + File.separator + string2);
            bl = this.setGenerationOutputStream(generationType, string3);
        }
        return bl;
    }

    @Override
    public void processFileWriting(String string, BaseGeneration.GenerationType generationType) {
        if (generationType == BaseGeneration.GenerationType.OBJECTTYPE) {
            this.getGenerationOutputStreamForObjectTypes().println(string);
        } else if (generationType == BaseGeneration.GenerationType.OBJECT) {
            this.getGenerationOutputStreamForObjects().println(string);
        }
    }

    @Override
    public void endFileWriting(BaseGeneration.GenerationType generationType) {
        if (generationType == BaseGeneration.GenerationType.OBJECTTYPE) {
            this.getGenerationOutputStreamForObjectTypes().close();
        } else if (generationType == BaseGeneration.GenerationType.OBJECT) {
            this.getGenerationOutputStreamForObjects().close();
        }
    }

    @Override
    public void endFileWriting(BaseGeneration.GenerationType generationType, boolean bl) {
        if (generationType == BaseGeneration.GenerationType.OBJECTTYPE) {
            File file;
            this.getGenerationOutputStreamForObjectTypes().close();
            if (!bl && (file = generationType.getObjectTypeFileLocation()).exists() && file.isFile()) {
                file.delete();
            }
        }
    }

    @Override
    public boolean setGenerationOutputStream(BaseGeneration.GenerationType generationType, String string) {
        boolean bl = false;
        File file = generationType.getFileLocation(this.getOutputDir(), string + ".sql");
        bl = generationType.isFileExists();
        FileDumpGenerationOutputStream fileDumpGenerationOutputStream = null;
        try {
            String string2 = Ide.getEnvironOptions().getEncoding();
            fileDumpGenerationOutputStream = string2 == null ? (bl ? new FileDumpGenerationOutputStream(new PrintStream(new FileOutputStream(file, true))) : new FileDumpGenerationOutputStream(new PrintStream(file))) : (bl ? new FileDumpGenerationOutputStream(new PrintStream((OutputStream)new FileOutputStream(file, true), false, string2)) : new FileDumpGenerationOutputStream(new PrintStream(file, string2)));
            if (BaseGeneration.GenerationType.OBJECTTYPE == generationType) {
                this.setGenerationOutputStreamForObjectTypes(fileDumpGenerationOutputStream);
            } else if (BaseGeneration.GenerationType.OBJECT == generationType) {
                this.setGenerationOutputStreamForObjects(fileDumpGenerationOutputStream);
            }
            generationType.setIsFileExists(false);
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            MigrationLogUtil.logThrowable(fileNotFoundException.getLocalizedMessage(), Messages.getString("GenerateWorker.39"), (Throwable)fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MigrationLogUtil.logThrowable(unsupportedEncodingException.getLocalizedMessage(), Messages.getString("GenerateWorker.39"), (Throwable)unsupportedEncodingException);
        }
        return bl;
    }

    @Override
    public boolean endGeneration() throws GenerateException {
        try {
            this.generatePostFile();
            this.generateRebuildSqlFile();
            this.generateRecompileViewsSqlFile();
            return true;
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }
}

