/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class IdentityHandler {
    protected static final int ORA_ERR_NO_SUCH_TRIGGER = 4080;
    protected static Logger s_log = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private static final String GET_IDENTITY_QUERY_START = "SELECT T.SCHEMA_NAME, T.TABLE_NAME, C.ID FROM MGV_ALL_TABLES T, MD_COLUMNS C, MD_ADDITIONAL_PROPERTIES AP WHERE T.CONNECTION_ID = ? AND ";
    private static final String GET_IDENTITY_QUERY_END = "C.TABLE_ID_FK = T.TABLE_ID AND AP.REF_ID_FK = C.ID AND AP.REF_TYPE='MD_COLUMNS' AND AP.PROP_KEY = 'REALIDENTITY'";
    private static final String GET_IDENTITY_QUERY_MIDDLE = "T.SCHEMA_ID = (SELECT MIN(DE.DERIVED_ID) FROM MD_DERIVATIVES DE WHERE DE.SRC_TYPE = 'MD_SCHEMAS' AND DE.DERIVED_TYPE = 'MD_SCHEMAS' AND DE.SRC_ID=? AND DE.DERIVED_CONNECTION_ID_FK= ?) AND ";
    protected DBObjectId m_connectionId;
    protected MdSchema m_schema = null;
    protected PersistenceManager m_persistenceManager;

    public IdentityHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        this.setConnectionId(dBObjectId);
        this.setPersistenceManager(persistenceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void enableIdentity(Connection var1_1, boolean var2_2) {
        block12: {
            if (var1_1 == null) {
                throw new IllegalArgumentException(Messages.getString("TriggerHandler.1"));
            }
            var3_3 = null;
            var4_4 = null;
            var5_5 = "";
            if (var1_1 != null) {
                var5_5 = "SELECT T.SCHEMA_NAME, T.TABLE_NAME, C.ID FROM MGV_ALL_TABLES T, MD_COLUMNS C, MD_ADDITIONAL_PROPERTIES AP WHERE T.CONNECTION_ID = ? AND C.TABLE_ID_FK = T.TABLE_ID AND AP.REF_ID_FK = C.ID AND AP.REF_TYPE='MD_COLUMNS' AND AP.PROP_KEY = 'REALIDENTITY'";
            }
            var3_3 = this.m_persistenceManager.getPreparedStatement((String)var5_5);
            var3_3.setLong(1, this.m_connectionId.getId());
            if (var1_1 != null) ** GOTO lbl21
            if (this.m_schema != null) break block12;
            IdentityHandler.s_log.warning(Messages.getString("SchemaNotProvided"));
            CloseableResultSet.close(null, var4_4);
            return;
        }
        try {
            var3_3.setLong(2, this.m_schema.getKey().getId());
            var3_3.setLong(3, this.m_connectionId.getId());
lbl21:
            // 2 sources

            var4_4 = var3_3.executeQuery();
        }
        catch (SQLException var5_6) {
            IdentityHandler.s_log.warning(var5_6.getLocalizedMessage());
            CloseableResultSet.close(null, var4_4);
            return;
        }
        try {
            try {
                if (var4_4 != null) {
                    while (var4_4.next()) {
                        var5_5 = new IdentityInformation(var4_4, this.m_persistenceManager);
                        var6_8 = false;
                        if (var1_1 == null) continue;
                        var6_8 = this.issueIdentityStmt(var1_1, var5_5.getEnableStatement(var2_2));
                    }
                }
                var4_4.close();
            }
            catch (SQLException var5_7) {
                IdentityHandler.s_log.warning(var5_7.getLocalizedMessage());
            }
        }
        catch (Throwable var7_9) {
            CloseableResultSet.close(null, var4_4);
            throw var7_9;
        }
        CloseableResultSet.close(null, var4_4);
    }

    public void enableIdentity(boolean bl) {
        this.enableIdentity(null, bl);
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        this.m_connectionId = dBObjectId;
    }

    public void setSchema(MdSchema mdSchema) {
        this.m_schema = mdSchema;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected boolean issueIdentityStmt(Connection connection, String string) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string);
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            s_log.warning(sQLException.getLocalizedMessage());
            return false;
        }
    }

    protected static class IdentityInformation {
        private String m_tableName;
        private String m_columnName;
        private String m_schemaName;
        private String m_increment;
        private String m_seed;
        private String m_lastValue;
        private String m_alterstring;

        public IdentityInformation(ResultSet resultSet, PersistenceManager persistenceManager) throws SQLException {
            this.m_schemaName = resultSet.getString(1);
            this.m_tableName = resultSet.getString(2);
            long l = resultSet.getLong(3);
            MdColumn mdColumn = null;
            Exception exception = null;
            try {
                mdColumn = MdColumn.retrieveExistingInstance(persistenceManager, new DBObjectId(l));
            }
            catch (PersistenceException persistenceException) {
                exception = persistenceException;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                exception = noSuchObjectException;
            }
            this.m_increment = "1";
            this.m_seed = null;
            this.m_lastValue = null;
            if (exception != null) {
                MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), this.getClass().getName(), (Throwable)exception);
                this.m_columnName = null;
            } else {
                AdditionalProperty[] additionalPropertyArray;
                for (AdditionalProperty additionalProperty : additionalPropertyArray = mdColumn.getAdditionalProperties()) {
                    if (additionalProperty.getKey().equals("INCREMENT")) {
                        this.m_increment = additionalProperty.getValue();
                    }
                    if (additionalProperty.getKey().equals("SEEDVALUE")) {
                        this.m_seed = additionalProperty.getValue();
                    }
                    if (!additionalProperty.getKey().equals("LASTVALUE")) continue;
                    this.m_lastValue = additionalProperty.getValue();
                }
                this.m_columnName = mdColumn.getColumnName();
            }
        }

        private String getAlterStatement(boolean bl) {
            String string = "N";
            if (bl) {
                string = "Y";
            }
            StringBuffer stringBuffer = new StringBuffer("");
            if (bl) {
                stringBuffer.append(this.m_schemaName);
                stringBuffer.append('.');
            }
            stringBuffer.append(this.m_tableName);
            try {
                if (this.m_lastValue != null && !this.m_lastValue.equals("")) {
                    Long.parseLong(this.m_lastValue);
                } else {
                    this.m_lastValue = "";
                }
                if (this.m_seed != null && !this.m_seed.equals("")) {
                    Long.parseLong(this.m_seed);
                } else {
                    this.m_seed = "";
                }
                if (this.m_increment != null && !this.m_increment.equals("")) {
                    Long.parseLong(this.m_increment);
                } else {
                    this.m_increment = "1";
                }
            }
            catch (NumberFormatException numberFormatException) {
                MigrationLogUtil.logThrowable(numberFormatException.getLocalizedMessage(), this.getClass().getName(), (Throwable)numberFormatException);
                this.m_columnName = null;
            }
            if (this.m_columnName == null) {
                return "select 'IDENTITY ON \"" + stringBuffer.toString() + "\" ERROR' from dual--";
            }
            String string2 = "";
            if (bl) {
                string2 = this.m_schemaName + ".";
            }
            String string3 = "  /****************************************************************\n  ** Set identity value: \n  ** MIN if increment < 0 of seed, last value, MIN(current column)\n  ** MAX if increment > 0 of seed, last value, MAX(current column)\n  ** if everything null use 0, schema,table and column names inline\n  ** add increment to start on a fresh entry\n  ****************************************************************/\nDECLARE\nv_limit " + stringBuffer.toString() + "." + this.m_columnName + "%TYPE:=null;\nv_seed VARCHAR2(4000 byte) := '" + this.m_seed + "';\nv_lastval VARCHAR2(4000 byte) := '" + this.m_lastValue + "';\nv_increment NUMBER := TO_NUMBER('" + this.m_increment + "');\nBEGIN\n    IF (v_increment<0) then\n        SELECT MIN(" + this.m_columnName + ") INTO v_limit FROM " + stringBuffer.toString() + ";\n        IF ((v_lastval IS NOT NULL) AND ((v_limit IS NULL) OR (TO_NUMBER(v_lastval)<v_limit))) THEN\n            v_limit := v_lastval; \n        ELSIF ((v_seed IS NOT NULL) AND ((v_limit IS NULL) OR (TO_NUMBER(v_seed)<v_limit))) THEN\n            v_limit := v_seed - v_increment; \n        END IF;\n    ELSE\n        SELECT MAX(" + this.m_columnName + ") INTO v_limit FROM " + stringBuffer.toString() + ";\n        IF ((v_lastval IS NOT NULL) AND ((v_limit IS NULL) OR (TO_NUMBER(v_lastval)>v_limit))) THEN\n            v_limit := v_lastval; \n        ELSIF ((v_seed IS NOT NULL) AND ((v_limit IS NULL) OR (TO_NUMBER(v_seed)>v_limit))) THEN\n            v_limit := v_seed - v_increment; \n        END IF;\n    END IF;\n    IF (v_limit IS NULL) then\n        IF (v_lastVal IS NULL) THEN\n           IF (v_seed IS NULL) THEN\n               v_limit := 0;\n           ELSE\n               v_limit := TO_NUMBER(v_seed) - v_increment; \n           END IF;\n        ELSE\n           v_limit := TO_NUMBER(v_lastval);\n        END IF;\n    END IF;\n    v_limit := v_limit + v_increment;\n\n     EXECUTE IMMEDIATE 'ALTER TABLE " + stringBuffer.toString() + " MODIFY (" + this.m_columnName + " GENERATED BY DEFAULT ON NULL AS IDENTITY '||CHR(10)||\n'(START WITH '||v_limit||' INCREMENT BY '||v_increment||' '||CHR(10)||\n' MAXVALUE 999999999999999999999999 MINVALUE -999999999999999999999999))';\nEND;";
            return string3;
        }

        public String getEnableStatement(boolean bl) {
            return this.getAlterStatement(bl);
        }
    }
}

