/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.persistence;

import java.util.ArrayList;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import oracle.dbtools.raptor.utils.persistence.PersistenceFactory;
import oracle.dbtools.util.Logger;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;

public class PersistenceManager<R extends Referenceable> {
    private String mType;
    private Class<R> mCls;

    private static DatabaseContextManager.ContextWrapper getContextWrapper() {
        return DatabaseContextManager.getContextWrapper();
    }

    public PersistenceManager(String string, Class<R> clazz) {
        this.mType = string;
        this.mCls = clazz;
    }

    public String[] listNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Context context = PersistenceManager.getContextWrapper().getDatabaseContext();
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = context.list("");
            while (namingEnumeration.hasMoreElements()) {
                String string;
                String string2;
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                if (!this.mCls.getName().equals(nameClassPair.getClassName()) || !ModelUtil.hasLength((String)(string2 = PersistenceFactory.getConnectionName(this.mType, string = nameClassPair.getName())))) continue;
                arrayList.add(string2);
            }
        }
        catch (NamingException namingException) {
            Logger.severe(this.mCls, (Throwable)namingException);
        }
        return arrayList.toArray(new String[0]);
    }

    public R getObject(String string) {
        Referenceable referenceable = null;
        try {
            Context context = PersistenceManager.getContextWrapper().getDatabaseContext();
            String string2 = PersistenceFactory.getBindingName(this.mType, string);
            referenceable = (Referenceable)context.lookup(string2);
        }
        catch (NamingException namingException) {
            Logger.severe(this.mCls, (Throwable)namingException);
        }
        return (R)referenceable;
    }

    public boolean updateObject(String string, R r) {
        boolean bl = false;
        try {
            DatabaseContextManager.ContextWrapper contextWrapper = PersistenceManager.getContextWrapper();
            Context context = contextWrapper.getDatabaseContext();
            String string2 = PersistenceFactory.getBindingName(this.mType, string);
            context.unbind(string2);
            context.bind(string2, r);
            contextWrapper.saveDatabaseContext();
            bl = true;
        }
        catch (NamingException namingException) {
            Logger.severe(this.mCls, (Throwable)namingException);
        }
        return bl;
    }

    public boolean addObject(String string, R r) throws NameAlreadyBoundException {
        boolean bl = false;
        try {
            DatabaseContextManager.ContextWrapper contextWrapper = PersistenceManager.getContextWrapper();
            Context context = contextWrapper.getDatabaseContext();
            context.bind(PersistenceFactory.getBindingName(this.mType, string), r);
            contextWrapper.saveDatabaseContext();
            bl = true;
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            throw nameAlreadyBoundException;
        }
        catch (NamingException namingException) {
            Logger.severe(this.mCls, (Throwable)namingException);
        }
        return bl;
    }

    public void addObjects(Map<String, R> map) {
        DatabaseContextManager.ContextWrapper contextWrapper = PersistenceManager.getContextWrapper();
        Context context = contextWrapper.getDatabaseContext();
        for (Map.Entry<String, R> entry : map.entrySet()) {
            try {
                context.bind(PersistenceFactory.getBindingName(this.mType, entry.getKey()), entry.getValue());
            }
            catch (NamingException namingException) {
                Logger.severe(this.mCls, (Throwable)namingException);
            }
        }
        try {
            contextWrapper.saveDatabaseContext();
        }
        catch (NamingException namingException) {
            Logger.severe(this.mCls, (Throwable)namingException);
        }
    }

    public boolean removeObject(String string) {
        boolean bl = false;
        try {
            DatabaseContextManager.ContextWrapper contextWrapper = PersistenceManager.getContextWrapper();
            Context context = contextWrapper.getDatabaseContext();
            context.unbind(PersistenceFactory.getBindingName(this.mType, string));
            contextWrapper.saveDatabaseContext();
            bl = true;
        }
        catch (NamingException namingException) {
            Logger.severe(this.mCls, (Throwable)namingException);
        }
        return bl;
    }
}

