/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.panels;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.controls.search.SearchPanel;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.panels.ByTypeSearchPanel;

public class SearchObjectsSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SearchPanel _searchPanel;
    private JList _tableList;
    private DefaultListModel _model;
    private JComboBox typeSelect = new JComboBox();
    private JLabel _selectedTypeLabel = new JLabel(UiResources.getString("SELECTED_OBJECT"));
    List<URL> _oList = null;
    private boolean _initSearchPanel = false;
    private String _conn;
    private DDLTypes _ddlTypes = null;
    private int _selectionMode = 1;
    private PropertyChangeSupport propertyChangeSupport;
    public static final String APPLY = "APPLY";
    private MouseListener _searchResultsMouseListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            Object[] objectArray = SearchObjectsSelectionPanel.this._searchPanel.getResultsList().getSelectedValues();
            URL uRL = null;
            for (n = 0; n < objectArray.length; ++n) {
                uRL = (URL)objectArray[n];
                if (((DefaultListModel)SearchObjectsSelectionPanel.this._tableList.getModel()).indexOf(uRL) != -1) continue;
                ((DefaultListModel)SearchObjectsSelectionPanel.this._tableList.getModel()).clear();
                ((DefaultListModel)SearchObjectsSelectionPanel.this._tableList.getModel()).addElement(uRL);
            }
            n = mouseEvent.getClickCount();
            if (n == 2 && SearchObjectsSelectionPanel.this.propertyChangeSupport != null) {
                SearchObjectsSelectionPanel.this.propertyChangeSupport.firePropertyChange(SearchObjectsSelectionPanel.APPLY, null, uRL);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };
    private boolean isTablespaceEnabled = false;
    private boolean isSchemasEnabled = false;

    public List<URL> getUrlList() {
        return this._oList;
    }

    public URL getUrl() {
        if (this._tableList == null || this._tableList.getModel().getSize() == 0) {
            return null;
        }
        return (URL)this._tableList.getModel().getElementAt(0);
    }

    public SearchObjectsSelectionPanel() {
        this(new ByTypeSearchPanel());
    }

    public SearchObjectsSelectionPanel(SearchPanel searchPanel) {
        this._searchPanel = searchPanel;
    }

    public void setSelectionMode(int n) {
        this._selectionMode = n;
    }

    public void setDDLTypes(DDLTypes dDLTypes) {
        this._ddlTypes = dDLTypes;
        Vector<String> vector = new Vector<String>();
        for (String stringArray2 : this._ddlTypes.getTypeList()) {
            vector.add(stringArray2);
        }
        String[] stringArray3 = new String[vector.size() + 1];
        String[] stringArray = new String[vector.size()];
        int n = 0;
        stringArray3[0] = UiResources.getString("SEARCH_ALL_OBJECTS");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray3[n + 1] = string = (String)iterator.next();
            stringArray[n++] = string;
        }
        this._searchPanel.setTypesForDisplay(stringArray3);
        this._searchPanel.setTypesForSearch(stringArray);
        this.setTypeList();
    }

    public void setConName(String string) {
        this._conn = string;
        this._searchPanel.setConnectionName(this._conn);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setList(List<URL> list) {
        this._oList = list != null ? list : new ArrayList<URL>();
        this.loadFilterList(this._oList);
    }

    public void updatePanel() {
        if (!this._initSearchPanel) {
            this.addSearchResultsListener();
            this._searchPanel.init();
            this._initSearchPanel = true;
        }
    }

    public void updatePanel(boolean bl) {
        this._searchPanel.init(bl);
    }

    public List<URL> getAdvListType(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this._oList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    public void addToList(List<URL> list) {
        for (URL uRL : list) {
            if (this._oList.contains(uRL)) continue;
            this._oList.add(uRL);
        }
    }

    public void remFromList(URL uRL) {
        if (this._oList.contains(uRL)) {
            this._oList.remove(uRL);
        }
    }

    public void resetList() {
        this._oList = new ArrayList<URL>();
    }

    private void loadFilterList(List<URL> list) {
        ((DefaultListModel)this._tableList.getModel()).clear();
        for (URL uRL : list) {
            if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
            ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
        }
    }

    public void setTypeList() {
        try {
            this.typeSelect.removeAllItems();
        }
        finally {
            this.typeSelect.addItem(UiResources.getString("SEARCH_ALL"));
            for (String string : this._ddlTypes.getTypeList()) {
                this.typeSelect.addItem(string);
            }
        }
    }

    public List<URL> getList() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        DefaultListModel defaultListModel = (DefaultListModel)this._tableList.getModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.size(); ++i) {
                URL uRL = (URL)defaultListModel.get(i);
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    public JPanel getPanel() {
        this._model = new DefaultListModel();
        this._tableList = new JList(this._model);
        this._tableList.setSelectionMode(this._selectionMode);
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(false);
        this._tableList.getAccessibleContext().setAccessibleName(UiResources.getString("LIST_ACCESS"));
        this._tableList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2 && SearchObjectsSelectionPanel.this.propertyChangeSupport != null) {
                    Object[] objectArray = SearchObjectsSelectionPanel.this._tableList.getSelectedValues();
                    URL uRL = (URL)objectArray[0];
                    SearchObjectsSelectionPanel.this.propertyChangeSupport.firePropertyChange(SearchObjectsSelectionPanel.APPLY, null, uRL);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.typeSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    String string = (String)SearchObjectsSelectionPanel.this.typeSelect.getSelectedItem();
                    if (string != null && !string.equals(UiResources.getString("SEARCH_ALL"))) {
                        List<URL> list = SearchObjectsSelectionPanel.this.getAdvListType(string);
                        SearchObjectsSelectionPanel.this.loadFilterList(list);
                    } else if (SearchObjectsSelectionPanel.this._oList != null) {
                        SearchObjectsSelectionPanel.this.loadFilterList(SearchObjectsSelectionPanel.this._oList);
                    }
                }
            }
        });
        this.typeSelect.getAccessibleContext().setAccessibleName(UiResources.getString("FILTER_LIST_ACCESS"));
        this.typeSelect.setName(UiResources.getString("FILTER_LIST_ACCESS"));
        JPanel jPanel = new JPanel(new FlowLayout(0, 6, 6));
        jPanel.add(this._selectedTypeLabel);
        jPanel.add(this._tableList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._searchPanel, new GridBagConstraints(0, 0, 2, 6, 2.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(16, 0, 0, 0), 0, 0));
        return this;
    }

    public void addSearchResultsListener() {
        this._searchPanel.setResultsListMouseListener(this._searchResultsMouseListener);
    }

    public void setMultipleSchemaNames(String[] stringArray) {
        if (this.isAddMultipleSchemas()) {
            this._searchPanel.setAddMultipleSchemas(true);
            this._searchPanel.setMultipleSchemas(stringArray);
            this._initSearchPanel = false;
        }
    }

    public void setTablespaceNames(String[] stringArray) {
        if (this.isAddTableSpace()) {
            this._searchPanel.setAddTableSpace(true);
            this._searchPanel.setTableSpaceNames(stringArray);
            this._initSearchPanel = false;
        }
    }

    public void setAddTableSpace(boolean bl) {
        this.isTablespaceEnabled = bl;
    }

    public boolean isAddTableSpace() {
        return this.isTablespaceEnabled;
    }

    public void setAddMultipleSchemas(boolean bl) {
        this.isSchemasEnabled = bl;
    }

    public boolean isAddMultipleSchemas() {
        return this.isSchemasEnabled;
    }
}

