/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.refactor.Inliner;
import oracle.dbtools.util.Service;

public class UnitTest {
    private static int testNo = 0;
    private static Set<Integer> failedTests = new TreeSet<Integer>();
    static Set<RuleTuple> rules = UnitTest.insightRules();
    static Earley earley = new Earley(rules){

        protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
            LexerToken lexerToken = list.get(n);
            return n2 == this.identifier && lexerToken.type == Token.IDENTIFIER || n2 == this.identifier && lexerToken.type == Token.DQUOTED_STRING || n2 == this.identifier && lexerToken.type == Token.BQUOTED_STRING;
        }
    };
    private static int output = (Integer)UnitTest.earley.symbolIndexes.get("output");
    private static int assertion = (Integer)UnitTest.earley.symbolIndexes.get("assertion");
    private static int query = (Integer)UnitTest.earley.symbolIndexes.get("query");
    private static int comment = (Integer)UnitTest.earley.symbolIndexes.get("comment");
    private static int marker = (Integer)UnitTest.earley.symbolIndexes.get("marker");
    private static int prompt = (Integer)UnitTest.earley.symbolIndexes.get("prompt");
    private static int line = (Integer)UnitTest.earley.symbolIndexes.get("line");
    private static int comma = (Integer)UnitTest.earley.symbolIndexes.get("','");
    private static int sql_prefix = (Integer)UnitTest.earley.symbolIndexes.get("\"sql prefix\"");
    private static int sql_postfix = (Integer)UnitTest.earley.symbolIndexes.get("\"sql postfix\"");

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile(UnitTest.class, (String)"unit.test");
        List list = LexerToken.parse((String)string, (String)"`#");
        Matrix matrix = new Matrix((Parser)earley);
        Visual visual = null;
        if (list.size() < 100) {
            visual = new Visual(list, (Parser)earley);
        }
        earley.parse(list, matrix);
        SyntaxError syntaxError = SyntaxError.checkSyntax((String)string, (String[])new String[]{"atest"}, (List)list, (Earley)earley, (Matrix)matrix);
        if (syntaxError != null) {
            if (visual != null) {
                visual.draw(matrix);
            }
            System.out.println("Syntax Error");
            System.out.println("at line#" + syntaxError.line);
            System.out.println(syntaxError.code);
            System.out.println(syntaxError.marker);
            System.out.println("Expected:  ");
            for (String string2 : syntaxError.getSuggestions()) {
                System.out.print(string2 + ',');
            }
            throw new Exception(">>>> syntactically invalid code fragment <<<<");
        }
        ParseNode parseNode = earley.forest(list, matrix);
        long l = System.currentTimeMillis();
        UnitTest.atest(parseNode, list, string);
        long l2 = System.currentTimeMillis();
        System.out.println("Total test time = " + (l2 - l));
        if (failedTests.size() == 0) {
            System.out.println("*** ALL " + testNo + " TESTS are OK *** ---> ");
        } else {
            System.out.println("*** TEST FAILED! *** ---> " + failedTests.toString());
        }
    }

    private static Set<RuleTuple> insightRules() {
        try {
            String string = Service.readFile(UnitTest.class, (String)"test.grammar");
            List list = LexerToken.parse((String)string, (boolean)false, (int)1);
            ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
            return treeSet;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)"VT: failed to init grammar for refactor test");
        }
    }

    private static void atest(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        if (parseNode.contains(assertion)) {
            boolean bl;
            if (!(bl = UnitTest.assertion(parseNode, list, string, testNo++))) {
                failedTests.add(testNo);
                System.out.println("TEST#" + testNo + ":  broken");
            }
            return;
        }
        if (parseNode.contains(output)) {
            Iterator iterator = parseNode.children().iterator();
            if (iterator.hasNext()) {
                ParseNode parseNode2 = (ParseNode)iterator.next();
                Replacements replacements = UnitTest.query(parseNode2, list, string);
                System.out.println("TEST#" + testNo++ + " ->\n");
                for (String string2 : replacements.lines()) {
                    System.out.println(string2);
                }
                return;
            }
            return;
        }
        if (parseNode.contains(comment)) {
            UnitTest.comment(parseNode, list, string);
            return;
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            UnitTest.atest(parseNode3, list, string);
        }
    }

    private static boolean assertion(ParseNode parseNode, List<LexerToken> list, String string, int n) {
        Replacements replacements = null;
        Replacements replacements2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(query)) {
                replacements = UnitTest.query(parseNode2, list, string);
                continue;
            }
            if (!parseNode2.contains(prompt)) continue;
            replacements2 = UnitTest.prompt(parseNode2, list, string);
        }
        if (!replacements.equals(replacements2)) {
            System.out.println(replacements.diff(replacements2));
            return false;
        }
        return true;
    }

    private static Replacements prompt(ParseNode parseNode, List<LexerToken> list, String string) {
        Replacements replacements = new Replacements("0123456789012345");
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains(line)) continue;
            UnitTest.line(parseNode2, list, string, replacements);
        }
        return replacements;
    }

    private static void line(ParseNode parseNode, List<LexerToken> list, String string, Replacements replacements) {
        Integer n = null;
        Integer n2 = null;
        String string2 = null;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (n == null) {
                n = Integer.parseInt(parseNode2.content(list));
                continue;
            }
            if (parseNode2.contains(comma)) continue;
            if (n2 == null) {
                n2 = Integer.parseInt(parseNode2.content(list));
                continue;
            }
            if (string2 != null) continue;
            string2 = parseNode2.content(list);
        }
        replacements.put(n.intValue(), n2.intValue(), string2);
    }

    private static Replacements query(ParseNode parseNode, List<LexerToken> list, String string) {
        String string2 = null;
        String string3 = "";
        int n = -1;
        ParseNode parseNode2 = null;
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode3.contains(marker)) {
                if (string2 == null) {
                    string2 = "";
                }
                n = string2.length() + (parseNode2 == null || list.get((int)parseNode3.from).begin == list.get((int)(parseNode2.to - 1)).end ? 0 : 1);
            }
            if (parseNode3.contains(sql_prefix) || parseNode3.contains(sql_postfix)) {
                if (n == -1) {
                    string2 = UnitTest.sql_fragment(parseNode3, list, string);
                } else {
                    string3 = UnitTest.sql_fragment(parseNode3, list, string);
                }
            }
            parseNode2 = parseNode3;
        }
        return UnitTest.output(string2 + "  " + string3, n);
    }

    private static Replacements output(String string, int n) {
        Replacements replacements = new Inliner(null).runProgram(n, string, LexerToken.parse((String)string), null, false);
        return replacements;
    }

    private static String sql_fragment(ParseNode parseNode, List<LexerToken> list, String string) {
        return string.substring(list.get((int)parseNode.from).begin, list.get((int)(parseNode.to - 1)).end);
    }

    private static ParseNode comment(ParseNode parseNode, List<LexerToken> list, String string) throws Exception {
        System.out.println(string.substring(list.get((int)(parseNode.from + 2)).begin, list.get((int)(parseNode.to - 1)).end - 1));
        return null;
    }
}

