/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.plsql.Messages;
import oracle.javatools.icons.OracleIcons;

public abstract class LegacyToggleButton
extends JToggleButton {
    Icon onIcon = null;
    Icon offIcon = null;
    JComponent[] dependents;

    public LegacyToggleButton(final JComponent[] jComponentArray) {
        this.dependents = jComponentArray;
        Icon icon = RaptorImagesArb.getIcon("MICROSCOPE");
        Icon icon2 = OracleIcons.getIcon((String)"search.png");
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        if (icon instanceof ImageIcon) {
            bufferedImage.getGraphics().drawImage(((ImageIcon)icon).getImage(), 0, 0, 16, 16, 0, 0, 32, 32, null);
        } else {
            JComponent[] jComponentArray2 = new JButton();
            icon.paintIcon((Component)jComponentArray2, bufferedImage.getGraphics(), 0, 0);
        }
        this.onIcon = new ImageIcon(bufferedImage);
        this.offIcon = icon2;
        this.setSelected(!LegacyToggleButton.isOff());
        if (this.isSelected()) {
            this.setIcon(this.onIcon);
            for (JComponent jComponent : jComponentArray) {
                jComponent.setEnabled(true);
            }
        } else {
            this.setIcon(this.offIcon);
            for (JComponent jComponent : jComponentArray) {
                jComponent.setEnabled(false);
            }
        }
        this.setToolTipText(this.ttipText());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LegacyToggleButton.this.toggle();
                if (LegacyToggleButton.this.isSelected()) {
                    LegacyToggleButton.this.setIcon(LegacyToggleButton.this.onIcon);
                    for (JComponent jComponent : jComponentArray) {
                        jComponent.setEnabled(true);
                    }
                } else {
                    LegacyToggleButton.this.setIcon(LegacyToggleButton.this.offIcon);
                    for (JComponent jComponent : jComponentArray) {
                        jComponent.setEnabled(false);
                    }
                }
                LegacyToggleButton.this.stateChanged();
            }
        });
    }

    abstract void stateChanged();

    static boolean isOff() {
        DBConfig dBConfig = DBConfig.getInstance();
        boolean bl = dBConfig.getBoolean("LEGACY_OUTLINE");
        return bl;
    }

    private void toggle() {
        DBConfig dBConfig = DBConfig.getInstance();
        dBConfig.putBoolean("LEGACY_OUTLINE", !LegacyToggleButton.isOff());
        this.setToolTipText(this.ttipText());
    }

    private String ttipText() {
        if (!LegacyToggleButton.isOff()) {
            return Messages.getString("OutlinePanel.Simple");
        }
        return Messages.getString("OutlinePanel.Detailed");
    }
}

