/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.plsql.structure.ArboriEditor;
import oracle.dbtools.raptor.plsql.structure.ArboriToolbar;
import oracle.dbtools.raptor.plsql.structure.MergedNode;
import oracle.dbtools.raptor.plsql.structure.OutlinePanel;
import oracle.dbtools.raptor.plsql.structure.OutlineWindow;

public class ArboriPanel
extends JPanel {
    ArboriEditor code = new ArboriEditor();
    JTable tbl;
    OutlinePanel context;

    public ArboriPanel() {
        super(new BorderLayout());
        OutlinePanel outlinePanel;
        if (this.context == null) {
            System.out.println("ArboriPanel(): context == null");
        }
        this.context = outlinePanel = (OutlinePanel)OutlineWindow.getInstance().getGUI();
        JScrollPane jScrollPane = new JScrollPane(this.code);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.tbl = new JTable(){

            protected Boolean isZebraRows() {
                return DBConfig.getInstance().getBoolean("ZEBRA_ROWS");
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (this.isZebraRows().booleanValue() && !this.isCellSelected(n, n2)) {
                    if (n % 2 == 0 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color00);
                    } else if (n % 2 == 0 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color10);
                    } else if (n % 2 == 1 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color01);
                    } else if (n % 2 == 1 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color11);
                    }
                }
                return component;
            }
        };
        this.tbl.setCellSelectionEnabled(true);
        this.tbl.setColumnSelectionAllowed(false);
        this.tbl.setRowSelectionAllowed(true);
        this.tbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2) {
                    return;
                }
                int n2 = ArboriPanel.this.tbl.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                ParseNode parseNode = (ParseNode)ArboriPanel.this.tbl.getValueAt(n2, n = ArboriPanel.this.tbl.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY())));
                if (parseNode == null) {
                    return;
                }
                ArboriPanel.this.context.current = parseNode;
                for (int i = 0; i < ArboriPanel.this.context.tree.getRowCount(); ++i) {
                    TreePath treePath = ArboriPanel.this.context.tree.getPathForRow(i);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    ParseNode parseNode2 = (ParseNode)defaultMutableTreeNode.getUserObject();
                    if (parseNode2.from <= parseNode.from && parseNode.to <= parseNode2.to) {
                        if (parseNode2 instanceof MergedNode) {
                            ArboriPanel.this.context.expandTreeNode(defaultMutableTreeNode);
                        }
                        ArboriPanel.this.context.tree.expandRow(i);
                    }
                    if (parseNode2.from != parseNode.from || parseNode2.to != parseNode.to) continue;
                    ArboriPanel.this.context.tree.setSelectionRow(i);
                    if (treePath == null) continue;
                    Rectangle rectangle = ArboriPanel.this.context.tree.getPathBounds(treePath);
                    rectangle.height = ArboriPanel.this.context.tree.getVisibleRect().height;
                    ArboriPanel.this.context.tree.scrollRectToVisible(rectangle);
                }
            }
        });
        this.tbl.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = ArboriPanel.this.tbl.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                int n2 = ArboriPanel.this.tbl.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                if (n == -1 || n2 == -1) {
                    ArboriPanel.this.tbl.setCursor(new Cursor(0));
                    return;
                }
                String string = (String)ArboriPanel.this.tbl.getModel().getValueAt(n, n2);
                if (string == null || "...".equals(string) || string.length() == 0) {
                    ArboriPanel.this.tbl.setCursor(new Cursor(0));
                    return;
                }
                ArboriPanel.this.tbl.setCursor(new Cursor(12));
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.tbl);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new ArboriToolbar(this), "First");
        jPanel.add((Component)jScrollPane, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this.add((Component)jSplitPane, "Center");
    }
}

