/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.xmleditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.EventObject;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayPanel;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.oviewer.Messages;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataBaseNodeUtil;
import oracle.dbtools.util.objectpriv.PermissionRegistry;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.LineGutterPlugin;

public class XMLBasedEditor
extends AsynchronousViewerEditor
implements BasicEditorPaneContainer,
IDBEditor,
Controller,
StatusProvider,
PropertyChangeListener {
    private DBObject m_dbObject;
    private DBObject _lastdbObject;
    private DisplayModel _displayModel;
    private DisplayPanel _displayPanel;
    private IdeAction _refreshAction = IdeAction.find((int)REFRESH_EDITOR_CMD_ID).newLocalAction((View)this);
    public static final int REFRESH_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"Refresh_XML_Editor");
    private IdeAction _editDBNodeAction;
    public static final int EDIT_DBNODE_CMD_ID = Ide.findOrCreateCmdID((String)"Edit_DBNode_XML_Editor");
    private JPopupMenu _gridCtxMenu;
    private JLabel _connName;
    private JLabel _ownerName;
    private JLabel _objName;
    private JComponent[] _statusBarCells;
    private BasicEditorPane _lastBasicEditorPane;
    private IDisplay _mainUI;
    private boolean _scrollable = true;

    public XMLBasedEditor() {
        this._refreshAction.addController((Controller)this);
        this._editDBNodeAction = IdeAction.find((int)EDIT_DBNODE_CMD_ID).newLocalAction((View)this);
        this._editDBNodeAction.addController((Controller)this);
    }

    @Override
    protected void openImpl(boolean bl) {
        this.getDBObject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getEditorContentImpl(Context context, AsynchronousViewerEditor.LoaderTaskManager loaderTaskManager) {
        DBObject dBObject = this.getDBObject(false);
        String string = dBObject != null ? dBObject.getConnectionName() : null;
        boolean bl = false;
        if (string != null) {
            if (Connections.getInstance().lock(string, true)) {
                bl = true;
            } else {
                throw new OpenAbortedException();
            }
        }
        try {
            super.getEditorContentImpl(context, loaderTaskManager);
        }
        finally {
            if (bl) {
                Connections.getInstance().unlock(string);
            }
        }
    }

    public synchronized Icon getTabIcon() {
        return this._displayModel != null ? this._displayModel.getIcon() : super.getTabIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_EDITOR_CMD_ID) {
            DBObject.tryCheckForChanges(context);
            this.updateContent(true);
            return true;
        }
        if (n == EDIT_DBNODE_CMD_ID) {
            if (this.getDatabaseNode() instanceof TextNode) {
                Context context2 = Context.newIdeContext((Element)this.getDatabaseNode());
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
                openEditorOptions.setFlags(1);
                WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                context2.setProject(Ide.getDefaultProject());
                try {
                    waitCursor.show();
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                finally {
                    waitCursor.hide();
                }
                return true;
            }
            DataBaseNodeUtil.editNodeWizard(this.getDatabaseNode());
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        View view = context.getView();
        int n = ideAction.getCommandId();
        if (view == this) {
            if (n == 23) {
                ideAction.setEnabled(false);
                bl = true;
            } else if (n == EDIT_DBNODE_CMD_ID) {
                if (this.getDatabaseNode() == null) {
                    ideAction.setEnabled(false);
                }
                bl = true;
            }
        }
        return bl || super.update(ideAction, context);
    }

    private boolean checkCanEdit(Context context) {
        SchemaObject schemaObject;
        Database database;
        boolean bl = false;
        DBObject dBObject = new DBObject((Element)context.getNode());
        String string = dBObject.getObjectType();
        if (PermissionRegistry.canAlter(dBObject) && (database = dBObject.getDatabase()) != null && (schemaObject = dBObject.getSchemaObject()) != null) {
            bl = DBEditorFactoryRegistry.getEditFactory((SchemaObject)schemaObject, (DBObjectProvider)database) != null;
        }
        return bl;
    }

    private DBObject getDBObject(boolean bl) {
        if (this.m_dbObject == null || bl) {
            this.m_dbObject = null;
            this.getContext(null);
        }
        return this.m_dbObject;
    }

    public synchronized Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        if (context != null) {
            if (this.m_dbObject == null) {
                Node node = context.getNode();
                this.m_dbObject = node instanceof ViewerNode ? ((ViewerNode)node).getDBObject() : new DBObject((Element)node);
                this.initDisplayModel(this.m_dbObject);
            }
            context.setProperty("ObjectAction.DBOBJECT", (Object)this.m_dbObject);
        }
        return context;
    }

    private boolean hasPopupEditor(DBObject dBObject, String string) {
        return !string.equals("INDEX") && !string.equals("SYNONYM") && !string.equals("RECYCLEBIN") && !string.equals("DIRECTORY") && !string.equals("PUBLIC_SYNONYM") && !string.startsWith("APEX") && !string.startsWith("JAVA") && !string.startsWith("EDITION") && !string.startsWith("XML") && !string.startsWith("XDB") && !string.startsWith("SCHSCHEDULE") && !string.startsWith("SCHJOB") && !string.startsWith("SCHNEWJOB") && !string.startsWith("SCHJOBCLASS") && !string.startsWith("SCHDBDESTINATION") && !string.startsWith("SCHCREDENTIAL") && !string.startsWith("SCHCHAIN") && !string.startsWith("SCHPROGRAM") && !string.startsWith("SCHFILEWATCHER") && !string.startsWith("SCHDBDESTINATION") && !string.startsWith("SCHDBDESTGROUP") && !string.startsWith("SCHEXDESTGROUP") && (dBObject.isOracle() || this.checkForMigrationObjectEditable(this.getContext()));
    }

    @Override
    protected JComponent createViewerUI() {
        final DBObject dBObject = this.getDBObject(false);
        final String string = dBObject.getObjectType();
        this._displayPanel = new DisplayPanel(this._displayModel, dBObject.getDictionary(), true, this.getToolbar());
        this._mainUI = this._displayPanel.getMainUI();
        this._mainUI.addPropertyChangeListener(this);
        this._mainUI.setView((View)this);
        XMLBasedEditor.invokeLaterAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                XMLBasedEditor.this.buildToolbar(dBObject, string);
            }
        });
        this.getContext().setProperty("MAIN_UI", (Object)this._mainUI);
        return this._displayPanel.getPanelContent();
    }

    private void buildToolbar(DBObject dBObject, String string) {
        ToolButton toolButton = null;
        if (this.hasPopupEditor(dBObject, string) && this.checkCanEdit(this.getContext())) {
            toolButton = this.getToolbar().add((ToggleAction)this._editDBNodeAction);
            toolButton.setName(this._editDBNodeAction.getValue("Name").toString());
        }
        if (!this._displayModel.isNoRefresh()) {
            toolButton = this.getToolbar().add((ToggleAction)this._refreshAction);
            toolButton.setName(this._refreshAction.getValue("Name").toString());
            this.getToolbar().putClientProperty((Object)"EditableGridControl.NO_REFRESH_CMD", (Object)Boolean.TRUE.toString());
        }
    }

    private DatabaseNode getDatabaseNode() {
        ViewerNode viewerNode = this.getViewerNode();
        Node node = viewerNode.getBaseNode();
        if (node == null) {
            node = this.getContext().getNode();
        }
        return node instanceof DatabaseNode ? (DatabaseNode)node : null;
    }

    public Object getEditorAttribute(String string) {
        if ("scrollable".equals(string)) {
            return this.isScrollable();
        }
        return super.getEditorAttribute(string);
    }

    private boolean isScrollable() {
        return this._scrollable;
    }

    private void initDisplayModel(DBObject dBObject) {
        this._scrollable = true;
        String string = this.getClass().toString();
        int n = Integer.parseInt(string.substring(string.lastIndexOf(114) + 1));
        ViewerAddin viewerAddin = (ViewerAddin)AddinManager.getAddinManager().getAddin(ViewerAddin.class);
        this._displayModel = viewerAddin.getModel(dBObject, n);
        if (this._displayModel != null) {
            this._displayModel.setConnName(dBObject.getConnectionName());
            this._displayModel.getExtValues().put("no.refresh.in.toolbar", "true");
            this._displayModel.getExtValues().put("no.run.in.toolbar", "true");
            this._displayModel.enableUseEditorScrollPane(true);
            this._scrollable = this._displayModel.isUseEditorScrollPane();
        }
    }

    protected void updateContent() {
        this.updateContent(false);
    }

    @Override
    protected void updateContent(boolean bl) {
        DBObject dBObject = this.getDBObject(true);
        if (bl || this._lastdbObject == null || !dBObject.checkQualifiedNameEquals(this._lastdbObject) || dBObject.getSchemaObject() != this._lastdbObject.getSchemaObject()) {
            this._displayPanel.clear();
            String string = dBObject.getConnectionName();
            Map<String, Object> map = dBObject.getDictionary();
            this._displayModel.setConnName(string);
            this._displayPanel.setMainPanelBinds(map);
            this._lastdbObject = dBObject;
            this._displayPanel.refresh(bl);
            this.updateToolbar();
        }
    }

    public void updateToolbar() {
    }

    public BasicEditorPane getFocusedEditorPane() {
        Component component = this._displayPanel.getFocusedComponent();
        if (component != null) {
            BasicEditorPane basicEditorPane = this._lastBasicEditorPane = component instanceof BasicEditorPane ? (BasicEditorPane)component : null;
        }
        if (this._lastBasicEditorPane == null) {
            this._lastBasicEditorPane = this._displayPanel.getMainUI().getCodeEditor();
        }
        return this._lastBasicEditorPane;
    }

    @Override
    public Object getPrintable() {
        return this._displayPanel;
    }

    public HelpInfo getHelpInfo() {
        String string = this._mainUI != null ? this._mainUI.getHelpId() : null;
        return new HelpInfo(string != null ? string : "f1_bdbtableviewer_html");
    }

    @Override
    public Database getDatabase() {
        return this.m_dbObject.getDatabase();
    }

    @Override
    public Connection getConnection() {
        return this.m_dbObject.getConnection();
    }

    @Override
    public String getConnectionName() {
        return this.m_dbObject.getConnectionName();
    }

    public IDisplay getMainUI() {
        return this._mainUI;
    }

    @Override
    public void cleanUp() {
        if (this._displayModel != null) {
            this._displayModel.setConnName(null);
            this._displayModel.setConnection(null);
        }
        if (this._displayPanel != null) {
            this._displayPanel.close();
        }
    }

    public void attachGutterMenu(BasicEditorPane basicEditorPane, final LineGutterPlugin lineGutterPlugin) {
        this._gridCtxMenu = new JPopupMenu(Messages.getString("XMLBasedEditor.12"));
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("XMLBasedEditor.13"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorProperties editorProperties = EditorProperties.getProperties();
                boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                editorProperties.putBooleanProperty("show-line-numbers", bl);
            }
        });
        this._gridCtxMenu.add(jMenuItem);
        lineGutterPlugin.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    XMLBasedEditor.this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        basicEditorPane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getModifiers();
                if ((n & 8) != 0 || (n & 4) != 0) {
                    XMLBasedEditor.this._gridCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    public String getStatus() {
        return this.getDisplayConnectionName() + " " + this.m_dbObject.getSchemaName() + "." + this.m_dbObject.getObjectName();
    }

    private String getDisplayConnectionName() {
        return Connections.getDisplayName(this.m_dbObject.getConnectionName());
    }

    public JComponent[] getCustomCells() {
        if (this._connName == null) {
            this._connName = new JLabel();
            this._connName.setToolTipText(Messages.getString("XMLBasedEditor.16"));
        }
        if (this._ownerName == null) {
            this._ownerName = new JLabel();
            this._ownerName.setToolTipText(Messages.getString("XMLBasedEditor.17"));
        }
        if (this._objName == null) {
            this._objName = new JLabel();
            this._objName.setToolTipText(Messages.getString("XMLBasedEditor.18"));
        }
        if (this._statusBarCells == null) {
            this._statusBarCells = new JComponent[3];
            this._statusBarCells[0] = this._connName;
            this._statusBarCells[1] = this._ownerName;
            this._statusBarCells[2] = this._objName;
        }
        this._connName.setText(this.getDisplayConnectionName());
        this._ownerName.setText(this.m_dbObject.getSchemaName());
        this._objName.setText(this.m_dbObject.getObjectName());
        return this._statusBarCells;
    }

    public boolean isExpandable(JComponent jComponent) {
        return false;
    }

    public boolean checkForMigrationObjectEditable(Context context) {
        IViewerNode iViewerNode = (IViewerNode)context.getNode();
        Node node = iViewerNode.getBaseNode();
        if (node instanceof DatabaseNode) {
            DatabaseNode databaseNode = (DatabaseNode)node;
            String string = (String)databaseNode.getProperty("TYPE");
            String string2 = (String)databaseNode.getProperty("ConnectionType");
            if ((string.indexOf("MD_PROCEDURE") >= 0 || string.indexOf("MD_TRIGGER") >= 0 || string.indexOf("MD_VIEW") >= 0 || string.indexOf("MD_FUNCTION") >= 0) && ("MIGREPO".equals(string2) || "MIGREPOC".equals(string2))) {
                return true;
            }
        }
        return false;
    }

    public Component getScrollableLeftMargin() {
        Component component = null;
        if (this.isScrollable() && this._mainUI != null) {
            component = this._mainUI.getScrollableLeftMargin();
        }
        if (component == null) {
            component = super.getScrollableLeftMargin();
        }
        return component;
    }

    public Component getScrollableTopMargin() {
        Component component = null;
        if (this.isScrollable() && this._mainUI != null) {
            component = this._mainUI.getScrollableTopMargin();
        }
        if (component == null) {
            component = super.getScrollableTopMargin();
        }
        return component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isScrollable()) {
            if (string.equals("scrollable_left_margin")) {
                this.firePropertyChangeEvent("scrollable_left_margin", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (string.equals("scrollable_top_margin")) {
                this.firePropertyChangeEvent("scrollable_top_margin", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu contextMenu = null;
        if (this.getMainUI() != null) {
            contextMenu = this.getMainUI().getContextMenu();
        }
        if (null == contextMenu) {
            contextMenu = super.getContextMenu();
        }
        return contextMenu;
    }
}

