/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.controls.display.DisplayHtml;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.utils.DBObject;

public class HTMLTabFormatter {
    public static final String FORMAT_TYPE = "HTML DDL";
    private List<DisplayModel> _models;
    private DBObject _selectedObject;
    private Map<String, Object> _binds;
    private File _baseDir;
    private String _objectName;
    private String _pathPrefix;
    private boolean _includeChildReports;
    private final String tabPad = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    public HTMLTabFormatter(DBObject dBObject, List<DisplayModel> list, Map<String, Object> map, File file) {
        this(dBObject, list, map, file, null, "../", true);
    }

    public HTMLTabFormatter(DBObject dBObject, List<DisplayModel> list, Map<String, Object> map, File file, String string, String string2, boolean bl) {
        this._baseDir = file;
        this._models = list;
        this._selectedObject = dBObject;
        this._binds = map;
        this._objectName = string;
        if (null == this._objectName) {
            this._objectName = dBObject.getObjectName();
        }
        this._pathPrefix = string2;
        this._includeChildReports = bl;
    }

    public boolean start() throws IOException {
        return this.start(null);
    }

    public boolean start(Connection connection) throws IOException {
        Object object;
        boolean bl = false;
        ArrayList<DisplayModel> arrayList = new ArrayList<DisplayModel>();
        for (int i = 0; i < this._models.size(); ++i) {
            object = this._models.get(i);
            if (this.isDisplayModelExcluded((DisplayModel)object)) continue;
            arrayList.add((DisplayModel)object);
        }
        String string = this.getEncodedFilePath(this._baseDir, this._objectName, null);
        object = new File(string);
        String string2 = this._selectedObject.getConnectionName();
        DisplayHtml displayHtml = new DisplayHtml((File)object, string2, connection, this._objectName, arrayList, this._binds, null);
        IErrorHandler iErrorHandler = new IErrorHandler(){
            boolean hasErrors = false;

            @Override
            public void handleError(IErrorHandler.Category category, Throwable throwable) {
                this.hasErrors = true;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            }

            @Override
            public boolean hasErrors() {
                return this.hasErrors;
            }
        };
        displayHtml.generate(iErrorHandler);
        bl = !iErrorHandler.hasErrors();
        return bl;
    }

    private boolean isDisplayModelExcluded(DisplayModel displayModel) {
        if (displayModel.getExtAttributes() != null && "false".equalsIgnoreCase((String)displayModel.getExtAttributes().get("dbDoc"))) {
            return true;
        }
        return null == displayModel.getQuery();
    }

    private String getEncodedFilePath(File file, String string, String string2) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(file.getAbsolutePath()).append(File.separator);
        String string3 = URLEncoder.encode(string, "UTF-8");
        stringBuffer.append(string3.replace("*", "%2A"));
        if (string2 != null) {
            stringBuffer.append("_").append(string2);
        }
        stringBuffer.append(".html");
        return stringBuffer.toString();
    }

    public void links(Writer writer) throws IOException {
        writer.write("<TABLE CELLSPACING=\"0\" CELLPADDING=\"1\" WIDTH=\"100%\" BORDER=\"0\">\n<TR><TD CLASS=\"NavBarRow3\" VALIGN=\"top\"><FONT SIZE=\"-2\">      SUMMARY:  <A HREF=\"#field_summary\">FIELD</A> | <A HREF=\"#type_summary\">TYPE</A> | <A HREF=\"#method_summary\">METHOD</A></FONT></TD><TD CLASS=\"NavBarRow3\" VALIGN=\"top\"><FONT SIZE=\"-2\"></TR></TABLE>");
    }

    public void summaryHeader(Writer writer, String string) throws IOException {
        writer.write("<P></P><A NAME=\"" + string.toLowerCase().replace(' ', '_') + "\"></A><TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"3\" BORDER=\"1\"><TR CLASS=\"TableHeadingColor\"><TD COLSPAN=\"2\"><FONT SIZE=\"+2\"><B>" + string + "</B></FONT></TD>");
    }

    public void generateSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        String string = this.extractComment(lexerToken);
        String string2 = this.extractParams(member);
        writer.write("<TR CLASS=\"TableRowColor\"><TD WIDTH=\"1%\" VALIGN=\"top\" ALIGN=\"right\"><FONT SIZE=\"-1\"><CODE>&nbsp;</CODE></FONT></TD><TD><CODE><B><A HREF=\"#" + member.name + "\">" + member.name + "</A></B>" + string2 + "</CODE><BR>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string + "</TD></TR>\n");
    }

    public void generateDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        String string = this.extractComment(lexerToken);
        String string2 = this.extractParams(member);
        List<String> list = this.extractParams(lexerToken);
        List<String> list2 = this.extractExc(lexerToken);
        List<String> list3 = this.extractRet(lexerToken);
        writer.write("<A NAME=\"" + member.name + "\"></A>\n<H3>" + member.name + "</H3><PRE>          <B>" + member.name + "</B>" + string2 + "</PRE><DL>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string + "<DD><DL>");
        if (0 < list.size()) {
            writer.write("<DT><B>Parameters:</B>");
            for (String string3 : list) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        if (0 < list3.size()) {
            writer.write("<DT><B>Returns:</B>");
            for (String string3 : list3) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        if (0 < list2.size()) {
            writer.write("<DT><B>Throws:</B>");
            for (String string3 : list2) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        writer.write("</DL></DD></DL><HR>");
    }

    private List<String> extractParams(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@param", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@param", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@throws", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@return", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@param".length(), n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - " + string.substring(((LexerToken)list.get((int)0)).end + 1) + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private List<String> extractRet(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@return", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@return", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@throws", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@return".length() + 1, n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                linkedList.add("<DD>" + string + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private List<String> extractExc(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@throws", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@throws", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@return", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@throws".length(), n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - " + string.substring(((LexerToken)list.get((int)0)).end + 1) + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private String extractComment(LexerToken lexerToken) {
        String string = "";
        if (lexerToken != null) {
            int n = lexerToken.content.indexOf("@param");
            if (n < 0) {
                n = lexerToken.content.indexOf("@return");
            }
            if (n < 0 && lexerToken.type == Token.LINE_COMMENT) {
                n = lexerToken.content.length();
            }
            if (n < 0 && lexerToken.type == Token.COMMENT) {
                n = lexerToken.content.length() - 2;
            }
            string = lexerToken.content.substring(2, n);
            string = string.replace('*', ' ');
        }
        return string.replace("\n", "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private String extractParams(Member member) {
        String string = "";
        int n = member.getPayload().indexOf("(");
        if (0 < n) {
            string = member.getPayload().substring(n);
        }
        return string;
    }
}

