/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesTreeNode;
import oracle.dbtools.raptor.navigator.folders.dnd.ConnectionDragHelper;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.util.Logger;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;

public class ConnectionDropHelper
implements DropHelper {
    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        NavigatorTreeNode navigatorTreeNode;
        return n == 2 && Arrays.asList(dataFlavorArray).contains(ConnectionDragHelper.CONN_NODE_FLAVOR) && (navigatorTreeNode = (NavigatorTreeNode)object).findAncestorTreeNode(Databases.class, false) != null;
    }

    public float getWeight() {
        return 10.0f;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        boolean bl = false;
        NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)object;
        NavigatorTreeNode navigatorTreeNode2 = navigatorTreeNode.findAncestorTreeNode(Databases.class, false);
        if (navigatorTreeNode2 instanceof DatabasesTreeNode) {
            DatabasesTreeNode databasesTreeNode = (DatabasesTreeNode)navigatorTreeNode2;
            DatabasesFolder databasesFolder = navigatorTreeNode.findAncestorElement(DatabasesFolder.class, false);
            String string = null == databasesFolder ? null : databasesFolder.getName();
            for (DatabaseConnection databaseConnection : this.getConnectionNodes(transferableArray)) {
                databasesTreeNode.updateFolder(databasesTreeNode.getOwningNavigatorTree(), string, new Element[]{databaseConnection});
                bl = true;
            }
        }
        return bl;
    }

    private List<DatabaseConnection> getConnectionNodes(Transferable[] transferableArray) {
        ArrayList<DatabaseConnection> arrayList = new ArrayList<DatabaseConnection>();
        for (Transferable transferable : transferableArray) {
            if (!transferable.isDataFlavorSupported(ConnectionDragHelper.CONN_NODE_FLAVOR)) continue;
            try {
                arrayList.add((DatabaseConnection)transferable.getTransferData(ConnectionDragHelper.CONN_NODE_FLAVOR));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.warn(this.getClass(), (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                Logger.warn(this.getClass(), (Throwable)iOException);
            }
        }
        return arrayList;
    }
}

