/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.impl.AbstractContainerTreeNode;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.query.QueryProgressListener;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;

public class ObjectFolderTreeNode
extends AbstractContainerTreeNode {
    @Override
    public DBContainerInstance getFolderInstance() {
        DBFolderInstance dBFolderInstance = null;
        ObjectFolder objectFolder = (ObjectFolder)this.getElement();
        if (objectFolder != null) {
            dBFolderInstance = objectFolder.getFolderInstance();
        }
        return dBFolderInstance;
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        ObjectFolder objectFolder = (ObjectFolder)this.getElement();
        if (!objectFolder.getFolderInstance().canLoadChildren()) {
            return null;
        }
        return new LoadTask(objectFolder);
    }

    @Override
    public String getShortLabel() {
        String string = super.getShortLabel();
        return this.isFiltered() ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }

    @Override
    protected void initializeFromElement(Element element) {
        if (element instanceof ObjectFolder) {
            ObjectFolder objectFolder = (ObjectFolder)element;
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
            if (databaseFolder.ignoreDefaultComparator()) {
                this.setComparator(null);
            } else {
                this.setComparator(CASE_SENSITIVE);
            }
        }
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private ObjectFolder m_folder;

        LoadTask(ObjectFolder objectFolder) {
            super(DatabaseNavigatorResources.getString("OBJECT_FILTER_LOAD"), objectFolder.getConnectionName(), true);
            this.m_folder = objectFolder;
        }

        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            FolderQueryProgressListener folderQueryProgressListener = new FolderQueryProgressListener(this);
            URL uRL = this.m_folder.getURL();
            DBFolderInstance dBFolderInstance = this.m_folder.getFolderInstance();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            try {
                this.checkCanProceed();
                for (DBChildInstance dBChildInstance : dBFolderInstance.listChildren(folderQueryProgressListener)) {
                    this.checkCanProceed();
                    DBObjectInstance dBObjectInstance = (DBObjectInstance)dBChildInstance;
                    DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL, dBObjectInstance);
                    if (databaseNode == null) continue;
                    arrayList.add(databaseNode);
                }
            }
            catch (SQLException sQLException) {
                try {
                    this.checkCanProceed();
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
                catch (ExecutionException executionException) {
                    arrayList.clear();
                }
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }

    static final class FolderQueryProgressListener
    implements QueryProgressListener {
        private final RaptorTask<?> task;

        FolderQueryProgressListener(RaptorTask<?> raptorTask) {
            this.task = raptorTask;
        }

        public void rsClosed() {
            this.task.setMessage(DatabaseNavigatorResources.getString("OBJECT_FILTER_RS_CLOSED"));
        }

        public void rsOpened() {
        }

        public void rsRowFetched() {
            this.task.setMessage(DatabaseNavigatorResources.getString("OBJECT_FILTER_ROW_FETCHED"));
        }
    }
}

