/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.metrics.sqlsource.SQLConnections;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobInstance;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationInstance;
import oracle.dbtools.raptor.metrics.sqlsource.SQLOperationType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLValueConverter;

public class SQLSourceInstance
extends SourceInstance {
    private final SQLSourceType sourceType;
    private final String connectionDisplayName;
    private final LinkedList<ConnectionTicket> connectionPool;
    private final String database;
    private final boolean noConnection;
    private String privateConnectionName;
    private Connection primaryConnection;
    private String versionString;
    private boolean versionStringSet;

    SQLSourceInstance(SQLSourceType sQLSourceType, String string, Map<String, String> map) {
        super(sQLSourceType, string, map);
        this.sourceType = sQLSourceType;
        this.connectionPool = new LinkedList();
        this.connectionDisplayName = SQLConnections.getDisplayName(string);
        if (map != null) {
            this.database = map.get("database");
            this.noConnection = Boolean.parseBoolean(map.get("noConnection"));
        } else {
            this.database = null;
            this.noConnection = false;
        }
    }

    @Override
    public SQLSourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    protected String getConnectionDisplayName() {
        return this.connectionDisplayName;
    }

    @Override
    protected SQLJobInstance newJob(String string) {
        SQLJobInstance sQLJobInstance = null;
        SQLJobType sQLJobType = this.sourceType.jobTypeMap().get(string);
        if (sQLJobType != null) {
            sQLJobInstance = new SQLJobInstance(sQLJobType, this);
        }
        return sQLJobInstance;
    }

    @Override
    protected SQLOperationInstance newOperation(String string, Map<String, String> map, DXOperationCallback dXOperationCallback) {
        SQLOperationInstance sQLOperationInstance = null;
        SQLOperationType sQLOperationType = this.sourceType.operationTypeMap().get(string);
        if (sQLOperationType != null) {
            sQLOperationInstance = new SQLOperationInstance(sQLOperationType, this, map, dXOperationCallback);
        }
        return sQLOperationInstance;
    }

    @Override
    protected synchronized void connect(int n) {
        try {
            for (int i = 0; i < n; ++i) {
                ConnectionTicket connectionTicket = this.createConnectionTicket();
                this.connectionPool.add(connectionTicket);
            }
        }
        catch (DXException dXException) {
            this.closeAll();
            throw dXException;
        }
    }

    @Override
    protected synchronized void adjust(int n, int n2) {
        try {
            if (n2 > n) {
                for (int i = n; i < n2; ++i) {
                    ConnectionTicket connectionTicket = this.createConnectionTicket();
                    this.connectionPool.add(connectionTicket);
                }
            } else {
                ArrayList<ConnectionTicket> arrayList = new ArrayList<ConnectionTicket>();
                int n3 = n - n2;
                for (ConnectionTicket connectionTicket : this.connectionPool) {
                    if (connectionTicket.connection == this.primaryConnection) continue;
                    arrayList.add(connectionTicket);
                    if (arrayList.size() != n3) continue;
                    break;
                }
                for (ConnectionTicket connectionTicket : arrayList) {
                    if (!this.connectionPool.remove(connectionTicket)) {
                        throw new DXException("unexpected failure to remove connection from pool");
                    }
                    if (connectionTicket.connection == null) continue;
                    this.close(connectionTicket.connection);
                }
            }
        }
        catch (DXException dXException) {
            this.closeAll();
            throw dXException;
        }
    }

    @Override
    protected synchronized void check() {
        if (this.connectionPool.isEmpty()) {
            throw new DXException("connection not available");
        }
        Connection connection = null;
        try {
            connection = this.connectionPool.getFirst().connection;
            if (connection == null) {
                connection = this.createConnection();
            }
            try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM DUAL");){
                preparedStatement.execute();
            }
            catch (SQLException sQLException) {
                throw new DXException(sQLException);
            }
        }
        catch (DXException dXException) {
            if (this.noConnection && connection != null) {
                this.close(connection);
            }
            this.closeAll();
            throw dXException;
        }
    }

    @Override
    protected synchronized void disconnect() {
        this.closeAll();
    }

    @Override
    protected boolean cancelConnect() {
        return false;
    }

    @Override
    protected boolean cancelAdjustConnectionCount() {
        return false;
    }

    @Override
    protected boolean cancelCheck() {
        return false;
    }

    @Override
    protected boolean cancelDisconnect() {
        return false;
    }

    @Override
    protected ValueConverter getValueConverter() {
        return new SQLValueConverter();
    }

    synchronized Connection acquireJDBCConnection() {
        Connection connection = null;
        ConnectionTicket connectionTicket = this.connectionPool.removeFirst();
        if (this.noConnection) {
            try {
                connection = this.createConnection();
            }
            catch (DXException dXException) {
                this.getLogger().log(Level.WARNING, "Unable to create job connection for source: " + this.getId(), dXException);
            }
        } else {
            connection = connectionTicket.connection;
        }
        if (connection != null && !this.versionStringSet) {
            try {
                this.versionString = connection.getMetaData().getDatabaseProductVersion();
            }
            catch (SQLException sQLException) {
                this.getLogger().log(Level.WARNING, "Unable to retrieve database product version for " + this.getId(), sQLException);
            }
            this.versionStringSet = true;
        }
        return connection;
    }

    synchronized void releaseJDBCConnection(Connection connection) {
        ConnectionTicket connectionTicket = new ConnectionTicket();
        if (this.noConnection) {
            if (connection == this.primaryConnection) {
                SQLConnections.closeConnection(this.privateConnectionName);
                this.primaryConnection = null;
            } else {
                this.close(connection);
            }
        } else {
            connectionTicket.connection = connection;
        }
        this.connectionPool.addLast(connectionTicket);
    }

    private ConnectionTicket createConnectionTicket() {
        ConnectionTicket connectionTicket = new ConnectionTicket();
        if (!this.noConnection) {
            connectionTicket.connection = this.createConnection();
        }
        return connectionTicket;
    }

    private Connection createConnection() {
        Connection connection = null;
        if (this.privateConnectionName == null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)SQLConnections.getConnectionInfo(this.getConnectionName()));
            properties.put("SavePassword", Boolean.toString(this.noConnection));
            if (this.database != null) {
                String string = properties.getProperty("customUrl");
                int n = string.indexOf(64);
                String string2 = n > 0 ? string.substring(0, n + 1) : "jdbc:oracle:thin:@";
                properties.put("customUrl", string2 + this.database);
                properties.remove("hostname");
                properties.remove("sid");
                properties.remove("serviceName");
            }
            this.privateConnectionName = SQLConnections.createPrivateConnection(this.getConnectionName(), properties);
        }
        if (this.privateConnectionName != null) {
            if (this.noConnection) {
                connection = SQLConnections.getConnection(this.privateConnectionName, true);
                try {
                    this.initConnection(connection);
                    this.primaryConnection = connection;
                }
                catch (DXException dXException) {
                    SQLConnections.closeConnection(this.privateConnectionName);
                    throw dXException;
                }
            }
            if (this.primaryConnection == null) {
                connection = SQLConnections.getConnection(this.privateConnectionName, true);
                try {
                    this.initConnection(connection);
                    this.primaryConnection = connection;
                }
                catch (DXException dXException) {
                    SQLConnections.closeConnection(this.privateConnectionName);
                    throw dXException;
                }
            }
            connection = SQLConnections.cloneConnection(this.primaryConnection);
            try {
                this.initConnection(connection);
            }
            catch (DXException dXException) {
                this.close(connection);
                throw dXException;
            }
        }
        return connection;
    }

    private void initConnection(Connection connection) {
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            throw new DXException(sQLException);
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement("BEGIN DBMS_APPLICATION_INFO.SET_CLIENT_INFO('Metrics Engine'); END;");){
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            this.getLogger().log(Level.WARNING, "Error setting client info: " + this.getId(), sQLException);
        }
    }

    private void closeAll() {
        if (!this.noConnection) {
            for (ConnectionTicket connectionTicket : this.connectionPool) {
                this.close(connectionTicket.connection);
            }
        }
        this.connectionPool.clear();
        if (this.privateConnectionName != null) {
            SQLConnections.removePrivateConnection(this.privateConnectionName);
        }
        this.privateConnectionName = null;
        this.primaryConnection = null;
    }

    private void close(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.getLogger().log(Level.WARNING, "Error in closing connection: " + this.getId(), sQLException);
        }
    }

    private class ConnectionTicket {
        private Connection connection;

        private ConnectionTicket() {
        }
    }
}

