/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.sqlsource;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.item.TableItemType;
import oracle.dbtools.raptor.metrics.item.TableValue;
import oracle.dbtools.raptor.metrics.sqlsource.SQLConnections;
import oracle.dbtools.raptor.metrics.sqlsource.SQLJobType;
import oracle.dbtools.raptor.metrics.sqlsource.SQLSourceInstance;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.sql.Datum;

public class SQLJobInstance
extends JobInstance {
    private final SQLJobType jobType;
    private final SQLSourceInstance source;
    private final ObjectQueries queries;
    private String baseSQL;
    private volatile Thread queryThread;
    private static final int ORACLE_STATEMENT_CANCELED = 1013;

    SQLJobInstance(SQLJobType sQLJobType, SQLSourceInstance sQLSourceInstance) {
        super(sQLJobType, sQLSourceInstance);
        this.jobType = sQLJobType;
        this.source = sQLSourceInstance;
        this.queries = sQLJobType.getQueries();
    }

    @Override
    public SQLJobType getRunnableType() {
        return this.jobType;
    }

    @Override
    public SQLSourceInstance getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataMap load(Map<String, Object> map) {
        HashMap<String, List> hashMap;
        block21: {
            hashMap = null;
            Connection connection = this.source.acquireJDBCConnection();
            if (connection == null) {
                throw new DXException("SQLJob connection not available");
            }
            HashMap<String, List> hashMap2 = new HashMap<String, List>();
            try {
                if (!SQLConnections.lock(connection)) break block21;
                try {
                    String string = this.getSQL(connection, map);
                    if (string == null) break block21;
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    this.queryThread = Thread.currentThread();
                    ResultSet resultSet = dBUtil.executeOracleQuery(string, map);
                    if (resultSet == null) {
                        SQLException sQLException = dBUtil.getLastException();
                        if (sQLException == null) {
                            throw new DXException("unknown SQL error");
                        }
                        if (sQLException.getErrorCode() != 1013 || !this.isRunCanceled()) {
                            throw new DXException("SQLJob query error", sQLException);
                        }
                        break block21;
                    }
                    try {
                        try {
                            int n;
                            int n2 = resultSet.getMetaData().getColumnCount();
                            List[] listArray = (List[])Array.newInstance(List.class, n2);
                            for (n = 0; n < n2; ++n) {
                                listArray[n] = new ArrayList();
                                hashMap2.put(resultSet.getMetaData().getColumnName(n + 1), listArray[n]);
                            }
                            while (!this.isRunCanceled() && resultSet.next()) {
                                for (n = 0; n < n2; ++n) {
                                    Object object = resultSet.getObject(n + 1);
                                    if (object instanceof Datum) {
                                        Datum datum = (Datum)object;
                                        object = datum.toJdbc();
                                    }
                                    listArray[n].add(object instanceof Comparable ? (Comparable)object : null);
                                }
                            }
                            if (!this.isRunCanceled()) {
                                hashMap = hashMap2;
                            }
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getErrorCode() != 1013 || !this.isRunCanceled()) {
                                throw new DXException("SQLJob query error", sQLException);
                            }
                        }
                    }
                    finally {
                        DBUtil.closeResultSet((ResultSet)resultSet);
                    }
                }
                finally {
                    SQLConnections.unlock(connection);
                }
            }
            finally {
                this.source.releaseJDBCConnection(connection);
            }
        }
        return DataMap.createLeaf(hashMap);
    }

    @Override
    protected boolean cancel() {
        boolean bl = false;
        Thread thread = this.queryThread;
        if (thread != null) {
            DBUtil.cancelExecution((Thread)thread);
            bl = true;
        }
        return bl;
    }

    private String getSQL(Connection connection, Map<String, Object> map) {
        if (this.baseSQL == null) {
            this.loadBaseQuery(connection);
        }
        if (this.jobType.isTextProcessing()) {
            return this.getTextProcessedSQL(map);
        }
        return this.baseSQL;
    }

    private void loadBaseQuery(Connection connection) {
        Query query = this.queries.getQuery(DefaultConnectionIdentifier.createIdentifier((Connection)connection));
        this.baseSQL = query.getSql();
    }

    private String getTextProcessedSQL(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        this.processPlainText(stringBuilder, n, map);
        return stringBuilder.toString();
    }

    private int processPlainText(StringBuilder stringBuilder, int n, Map<String, Object> map) {
        block4: while (n < this.baseSQL.length()) {
            char c = this.baseSQL.charAt(n);
            if (c == '}') {
                ++n;
                break;
            }
            switch (c) {
                case '%': {
                    n = this.processDirective(stringBuilder, n + 1, map);
                    continue block4;
                }
                case '\\': {
                    stringBuilder.append(this.baseSQL.charAt(n + 1));
                    n += 2;
                    continue block4;
                }
            }
            stringBuilder.append(this.baseSQL.charAt(n));
            ++n;
        }
        return n;
    }

    private int processDirective(StringBuilder stringBuilder, int n, Map<String, Object> map) {
        char c;
        StringBuilder stringBuilder2 = new StringBuilder();
        while (n < this.baseSQL.length() && (c = this.baseSQL.charAt(n++)) != ')') {
            stringBuilder2.append(c);
        }
        while (n < this.baseSQL.length() && (Character.isWhitespace(c = this.baseSQL.charAt(n)) || c == '{')) {
            ++n;
        }
        String[] stringArray = stringBuilder2.toString().split("\\s*[(,]\\s*");
        String string = stringArray[0];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        switch (string) {
            case "ROWS": {
                n = this.processRowsDirective(stringBuilder, arrayList, n, map);
                break;
            }
            case "ORDERBY": {
                n = this.processOrderByDirective(stringBuilder, arrayList, n, map);
                break;
            }
            case "TEXT": {
                n = this.processTextDirective(stringBuilder, arrayList, n, map);
                break;
            }
            default: {
                throw new DXException("Unrecoognised directive '" + stringBuilder2.toString() + "'");
            }
        }
        return n;
    }

    private int processRowsDirective(StringBuilder stringBuilder, List<String> list, int n, Map<String, Object> map) {
        stringBuilder.append("SELECT d.* FROM ( SELECT d.*, ROWNUM ");
        stringBuilder.append(list.get(0));
        stringBuilder.append(" FROM (");
        n = this.processPlainText(stringBuilder, n, map);
        stringBuilder.append(") d ) d WHERE ");
        stringBuilder.append(list.get(0));
        stringBuilder.append(" >= :");
        stringBuilder.append(list.get(1));
        stringBuilder.append(" AND ");
        stringBuilder.append(list.get(0));
        stringBuilder.append(" <= :");
        stringBuilder.append(list.get(2));
        return n;
    }

    private int processOrderByDirective(StringBuilder stringBuilder, List<String> list, int n, Map<String, Object> map) {
        String string;
        stringBuilder.append("SELECT d.* FROM (");
        n = this.processPlainText(stringBuilder, n, map);
        stringBuilder.append(") d ORDER BY ");
        TableItemType tableItemType = null;
        String[] stringArray = this.jobType.getItemTypeNames().iterator();
        while (stringArray.hasNext() && (tableItemType = this.jobType.getItemType(string = stringArray.next(), TableItemType.class)) == null) {
        }
        if (tableItemType == null) {
            throw new DXException("Table item does not exist in job type '" + this.jobType.getPath() + "'");
        }
        stringArray = map.get(list.get(0)).toString().split("\\s*,\\s*");
        boolean bl = true;
        for (String string2 : stringArray) {
            boolean bl2;
            switch (string2.charAt(0)) {
                case '+': {
                    bl2 = false;
                    break;
                }
                case '-': {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new DXException("each element in the orderBy must being with +/-: " + string2);
                }
            }
            TableValue tableValue = tableItemType.getTableValue(string2.substring(1));
            if (tableValue == null) {
                throw new DXException("Table item value '" + string2.substring(1) + "' does not exist");
            }
            String string3 = tableValue.getMapTo();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(string3);
            if (!bl2) continue;
            stringBuilder.append(" DESC");
        }
        return n;
    }

    private int processTextDirective(StringBuilder stringBuilder, List<String> list, int n, Map<String, Object> map) {
        String string = map.get(list.get(0)).toString();
        stringBuilder.append(' ');
        stringBuilder.append(string);
        stringBuilder.append(' ');
        return n;
    }
}

