/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableListValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.dataobject.BoundList;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSetHelper;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSetSelector;
import oracle.dbtools.raptor.metrics.panel.TreeTableFeatureSet;

public class TreeTableViewMonitor
extends AbstractTableMonitor<TreeTableColumn<DXRow, Object>, TreeTableCell<DXRow, Object>, TreeTableFeatureSet> {
    private final StringProperty idColumnNameProperty = new SimpleStringProperty((Object)this, "idColumnName");
    private final StringProperty parentIdColumnNameProperty = new SimpleStringProperty((Object)this, "parentIdColumnName");
    private final BooleanProperty defaultExpandedProperty = new SimpleBooleanProperty((Object)this, "defaultExpanded", true);
    private final ObservableList<TableFeatureSetSelector<TreeTableFeatureSet>> featureSetSelectors = FXCollections.observableArrayList();
    private final Map<Comparable<?>, TreeItem<DXRow>> treeItems = new HashMap();
    private TableFeatureSetHelper<TreeTableFeatureSet> featureSetHelper;

    public String getIdColumnName() {
        return (String)this.idColumnNameProperty.get();
    }

    public void setIdColumnName(String string) {
        this.idColumnNameProperty.set((Object)string);
    }

    public StringProperty idColumnNameProperty() {
        return this.idColumnNameProperty;
    }

    public String getParentIdColumnName() {
        return (String)this.parentIdColumnNameProperty.get();
    }

    public void setParentIdColumnName(String string) {
        this.parentIdColumnNameProperty.set((Object)string);
    }

    public StringProperty parentIdColumnNameProperty() {
        return this.parentIdColumnNameProperty;
    }

    public boolean isDefaultExpanded() {
        return this.defaultExpandedProperty.get();
    }

    public void setDefaultExpanded(boolean bl) {
        this.defaultExpandedProperty.set(bl);
    }

    public BooleanProperty defaultExpandedProperty() {
        return this.defaultExpandedProperty;
    }

    @Override
    public ObservableList<TableFeatureSetSelector<TreeTableFeatureSet>> getFeatureSetSelectors() {
        return this.featureSetSelectors;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return TreeTableView.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        TreeTableView treeTableView = context.getContainer(TreeTableView.class);
        if (treeTableView != null) {
            for (TreeTableColumn treeTableColumn : treeTableView.getColumns()) {
                Callback callback = treeTableColumn.getCellFactory();
                if (!(callback instanceof AbstractCellFactory)) continue;
                AbstractCellFactory abstractCellFactory = (AbstractCellFactory)callback;
                consumer.accept(Collections.singletonList(abstractCellFactory));
            }
        }
    }

    @Override
    protected void onInit(Context context) {
        super.onInit(context);
        TreeTableView treeTableView = context.getContainer(TreeTableView.class);
        if (treeTableView != null) {
            BoundList boundList = this.getItem();
            ObservableListValue<DXRow> observableListValue = boundList.getObservable();
            observableListValue.addListener(change -> {
                while (change.next()) {
                    for (DXRow dXRow : change.getRemoved()) {
                        this.removeRow((TreeTableView<DXRow>)treeTableView, dXRow);
                    }
                    for (DXRow dXRow : change.getAddedSubList()) {
                        this.addRow((TreeTableView<DXRow>)treeTableView, dXRow);
                    }
                }
            });
            this.featureSetHelper = new TableFeatureSetHelper(new List[]{this.featureSetSelectors});
            ObservableList observableList = treeTableView.getColumns();
            for (TreeTableColumn treeTableColumn : observableList) {
                this.bindTreeTableColumn(treeTableColumn);
            }
        }
    }

    @Override
    protected DXRow getRow(TreeTableCell<DXRow, Object> treeTableCell) {
        TreeItem treeItem;
        TreeTableRow treeTableRow;
        DXRow dXRow = null;
        int n = treeTableCell.getIndex();
        Object object = treeTableCell.getItem();
        if (n >= 0 && object != null && (treeTableRow = treeTableCell.getTreeTableRow()) != null && (treeItem = treeTableRow.getTreeItem()) != null) {
            dXRow = (DXRow)treeItem.getValue();
        }
        return dXRow;
    }

    @Override
    protected TreeTableColumn<DXRow, Object> getColumn(TreeTableCell<DXRow, Object> treeTableCell) {
        return treeTableCell.getTableColumn();
    }

    @Override
    protected AbstractCellFactory<TreeTableColumn<DXRow, Object>, TreeTableCell<DXRow, Object>> getCellFactory(TreeTableColumn<DXRow, Object> treeTableColumn) {
        AbstractCellFactory abstractCellFactory = null;
        Callback callback = treeTableColumn.getCellFactory();
        if (callback instanceof AbstractCellFactory) {
            abstractCellFactory = (AbstractCellFactory)callback;
        }
        return abstractCellFactory;
    }

    private void addRow(TreeTableView<DXRow> treeTableView, DXRow dXRow) {
        TreeTableFeatureSet treeTableFeatureSet2;
        Comparable comparable = (Comparable)dXRow.get(this.getIdColumnName(), Comparable.class).get();
        TreeItem treeItem = this.treeItems.get(comparable);
        if (treeItem == null) {
            treeItem = new TreeItem();
            this.treeItems.put(comparable, (TreeItem<DXRow>)treeItem);
        }
        boolean bl = (treeTableFeatureSet2 = this.featureSetHelper.find(dXRow, null, treeTableFeatureSet -> true)) != null && treeTableFeatureSet2.getExpanded() != null ? treeTableFeatureSet2.getExpanded().booleanValue() : this.isDefaultExpanded();
        treeItem.setExpanded(bl);
        treeItem.setValue((Object)dXRow);
        Comparable comparable2 = (Comparable)dXRow.get(this.getParentIdColumnName(), Comparable.class).get();
        if (comparable2 == null) {
            if (treeTableView.getRoot() == null) {
                treeTableView.setRoot(treeItem);
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "tree table already has root node: item with ID ''{0}''ignored", comparable);
            }
        } else {
            TreeItem treeItem2 = this.treeItems.get(comparable2);
            if (treeItem2 == null) {
                treeItem2 = new TreeItem();
                this.treeItems.put(comparable2, (TreeItem<DXRow>)treeItem2);
            }
            ObservableList observableList = treeItem2.getChildren();
            int n = -1;
            int n2 = 0;
            for (TreeItem treeItem3 : observableList) {
                Comparable comparable3 = (Comparable)((DXRow)treeItem3.getValue()).get(this.getIdColumnName(), Comparable.class).get();
                if (comparable.compareTo(comparable3) < 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n < 0) {
                observableList.add(treeItem);
            } else {
                observableList.add(n, treeItem);
            }
        }
    }

    private void removeRow(TreeTableView<DXRow> treeTableView, DXRow dXRow) {
        Comparable comparable = (Comparable)dXRow.get(this.getIdColumnName(), Comparable.class).get();
        TreeItem<DXRow> treeItem = this.treeItems.get(comparable);
        if (treeItem != null) {
            ArrayList arrayList = new ArrayList();
            this.listSubTree(treeItem, arrayList);
            treeItem.setValue(null);
            for (Comparable comparable2 : arrayList) {
                this.treeItems.remove(comparable2);
            }
            if (treeItem.getParent() != null) {
                treeItem.getParent().getChildren().remove(treeItem);
            } else {
                treeTableView.setRoot(null);
            }
        }
    }

    private void listSubTree(TreeItem<DXRow> treeItem, List<Comparable<?>> list) {
        list.add((Comparable<?>)((DXRow)treeItem.getValue()).get(this.getIdColumnName(), Comparable.class).get());
        for (TreeItem treeItem2 : treeItem.getChildren()) {
            this.listSubTree((TreeItem<DXRow>)treeItem2, list);
        }
    }

    private void bindTreeTableColumn(TreeTableColumn<DXRow, ?> treeTableColumn) {
        TreeTableColumn<DXRow, ?> treeTableColumn2 = treeTableColumn;
        Callback callback = treeTableColumn2.getCellFactory();
        if (callback instanceof AbstractCellFactory) {
            AbstractCellFactory abstractCellFactory = (AbstractCellFactory)callback;
            treeTableColumn2.setCellValueFactory(cellDataFeatures -> ((DXRow)cellDataFeatures.getValue().getValue()).get(abstractCellFactory.getValueColumn(), Comparable.class));
        }
    }
}

