/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.NumberAxis;
import oracle.dbtools.raptor.metrics.panel.AxisProperties;

public abstract class SeriesAxisProperties
extends AxisProperties {
    private final IntegerProperty tickIntervalCountProperty = new SimpleIntegerProperty((Object)this, "tickIntervalCount", 10);
    private final DoubleProperty lowerBound = new SimpleDoubleProperty();
    private final DoubleProperty upperBound = new SimpleDoubleProperty();
    private final DoubleProperty tickUnit = new SimpleDoubleProperty();

    public int getTickIntervalCount() {
        return this.tickIntervalCountProperty.get();
    }

    public void setTickIntervalCount(int n) {
        this.tickIntervalCountProperty.set(n);
    }

    public IntegerProperty tickIntervalCountProperty() {
        return this.tickIntervalCountProperty;
    }

    @Override
    void initialize(NumberAxis numberAxis) {
        super.initialize(numberAxis);
        numberAxis.autoRangingProperty().bind((ObservableValue)this.falseValue);
        numberAxis.tickUnitProperty().bind((ObservableValue)this.tickUnit);
        numberAxis.upperBoundProperty().bind((ObservableValue)this.upperBound);
        numberAxis.lowerBoundProperty().bind((ObservableValue)this.lowerBound);
        this.tickUnit.set(1.0);
        this.upperBound.set(1.0);
        this.lowerBound.set(0.0);
    }

    double[] update() {
        double d = System.currentTimeMillis();
        double d2 = d - this.getTickIntervalAsDouble() * (double)this.getTickIntervalCount();
        this.tickUnit.set(this.getTickIntervalAsDouble());
        this.upperBound.set(d);
        this.lowerBound.set(d2);
        return new double[]{d2, d};
    }

    abstract double getTickIntervalAsDouble();
}

