/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.MapDataObject;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.TimeSeriesMonitor;

@DefaultProperty(value="item")
public class QueriedTimeSeriesMonitor
extends TimeSeriesMonitor {
    private final StringProperty seriesNameRowItemProperty = new SimpleStringProperty();
    private final StringProperty valueRowItem = new SimpleStringProperty();
    private final ObjectProperty<MapDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final List<TimeSeriesMonitor.SeriesSource> seriesSources = new ArrayList<TimeSeriesMonitor.SeriesSource>();

    public String getSeriesNameRowItem() {
        return (String)this.seriesNameRowItemProperty.get();
    }

    public void setSeriesNameRowItem(String string) {
        this.seriesNameRowItemProperty.set((Object)string);
    }

    public StringProperty seriesNameRowItemProperty() {
        return this.seriesNameRowItemProperty;
    }

    public String getValueRowItem() {
        return (String)this.valueRowItem.get();
    }

    public void setValueRowItem(String string) {
        this.valueRowItem.set((Object)string);
    }

    public StringProperty valueRowItemProperty() {
        return this.valueRowItem;
    }

    public MapDataObject getItem() {
        return (MapDataObject)this.itemProperty.get();
    }

    public void setItem(MapDataObject mapDataObject) {
        this.itemProperty.set((Object)mapDataObject);
    }

    public ObjectProperty<MapDataObject> itemProperty() {
        return this.itemProperty;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.itemProperty.get());
    }

    @Override
    protected List<TimeSeriesMonitor.SeriesSource> getSeriesSources() {
        return this.seriesSources;
    }

    @Override
    protected void onInit(Context context) {
        ObservableMapValue<DXKey, DXRow> observableMapValue = this.getItem().getObservable();
        observableMapValue.addListener((MapChangeListener)new SourceMapChangeListener());
        super.onInit(context);
    }

    private void addSeriesSource(String string, ObservableValue<? extends Number> observableValue) {
        this.seriesSources.add(new TimeSeriesMonitor.SeriesSource(string, observableValue));
    }

    private class SourceMapChangeListener
    implements MapChangeListener<DXKey, DXRow> {
        private SourceMapChangeListener() {
        }

        public void onChanged(MapChangeListener.Change<? extends DXKey, ? extends DXRow> change) {
            if (QueriedTimeSeriesMonitor.this.getItem().getAvailable().get()) {
                QueriedTimeSeriesMonitor.this.getItem().getObservable().removeListener((MapChangeListener)this);
            } else if (change.wasAdded()) {
                DXRow dXRow = (DXRow)change.getValueAdded();
                QueriedTimeSeriesMonitor.this.addSeriesSource((String)dXRow.get(QueriedTimeSeriesMonitor.this.getSeriesNameRowItem(), String.class).get(), (ObservableValue<? extends Number>)dXRow.get(QueriedTimeSeriesMonitor.this.getValueRowItem(), Double.class));
            }
        }
    }
}

