/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractFacetObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.ContextFactory;

abstract class PanelScanner {
    private final ContextFactory contextFactory;

    PanelScanner(ContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    void scan(Node node) {
        Parent parent;
        Context context = this.contextFactory.createContext(node);
        List<AbstractFacetObject> list = context.getFacets((Map<Object, Object>)node.getProperties());
        if (list != null) {
            parent = new ArrayList();
            for (AbstractFacetObject abstractFacetObject : list) {
                this.scanRelated(context, abstractFacetObject, (List<AbstractContextObject>)parent);
                parent.add(abstractFacetObject);
            }
            this.process(context, (List<? extends AbstractContextObject>)parent);
        }
        if (node instanceof Parent) {
            parent = (Parent)node;
            for (AbstractFacetObject abstractFacetObject : parent.getChildrenUnmodifiable()) {
                if (!this.scanInto((Node)abstractFacetObject)) continue;
                this.scan((Node)abstractFacetObject);
            }
        }
    }

    abstract boolean scanInto(Node var1);

    void process(Context context, List<? extends AbstractContextObject> list) {
        for (AbstractContextObject abstractContextObject : list) {
            this.process(context, abstractContextObject);
        }
    }

    void process(Context context, AbstractContextObject abstractContextObject) {
    }

    private void scanRelated(Context context, AbstractContextObject abstractContextObject, List<AbstractContextObject> list) {
        abstractContextObject.scanRelated(context, list2 -> {
            for (AbstractContextObject abstractContextObject : list2) {
                this.scanRelated(context, abstractContextObject, list);
            }
            list.addAll((Collection<AbstractContextObject>)list2);
        });
    }
}

