/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Pagination;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

public class PaginationMonitor
extends AbstractMonitorObject {
    private PanelFactory.Instance panelInstance;
    private final StringProperty styleClassProperty = new SimpleStringProperty((Object)this, "styleClass");
    private final ObjectProperty<PanelFactory> panelFactoryProperty = new SimpleObjectProperty((Object)this, "panelFactory");

    public String getStyleClass() {
        return (String)this.styleClassProperty.get();
    }

    public void setStyleClass(String string) {
        this.styleClassProperty.set((Object)string);
    }

    public StringProperty styleClassProperty() {
        return this.styleClassProperty;
    }

    public PanelFactory getPanelFactory() {
        return (PanelFactory)this.panelFactoryProperty.get();
    }

    public void setPanelFactory(PanelFactory panelFactory) {
        this.panelFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> panelFactoryProperty() {
        return this.panelFactoryProperty;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return Pagination.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        consumer.accept(Collections.singletonList(this.getPanelFactory()));
    }

    @Override
    protected void onStart(Context context) {
        Pagination pagination = context.getContainer(Pagination.class);
        Platform.runLater(() -> pagination.setPageFactory(n -> this.createPanel((int)n)));
    }

    @Override
    protected void onStop(Context context) {
        this.closePanel();
        Pagination pagination = context.getContainer(Pagination.class);
        Platform.runLater(() -> pagination.setPageFactory(null));
    }

    @Override
    protected void onClose(Context context) {
        this.closePanel();
    }

    private Region createPanel(int n) {
        this.closePanel();
        PanelFactory panelFactory = this.getPanelFactory();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("pageNo", n);
        MarkerValues markerValues = new MarkerValues(hashMap);
        this.panelInstance = panelFactory.createPanel(markerValues);
        String string = this.getStyleClass();
        if (string != null) {
            ((Region)this.panelInstance.getPanel()).getStyleClass().add((Object)string);
        }
        this.panelInstance.start();
        Region region = (Region)this.panelInstance.getPanel();
        return region;
    }

    private void closePanel() {
        if (this.panelInstance != null) {
            this.panelInstance.close();
            this.panelInstance = null;
        }
    }
}

