/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.NumberDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.Series;
import oracle.dbtools.raptor.metrics.panel.TimeSeriesMonitor;

@DefaultProperty(value="series")
public class ListedTimeSeriesMonitor
extends TimeSeriesMonitor {
    private final ObservableList<Series> series = FXCollections.observableArrayList();
    private final List<TimeSeriesMonitor.SeriesSource> seriesSources = new ArrayList<TimeSeriesMonitor.SeriesSource>();

    public ObservableList<Series> getSeries() {
        return this.series;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        for (Series series : this.series) {
            NumberDataObject numberDataObject = series.getItem();
            arrayList.add(numberDataObject);
        }
        return arrayList;
    }

    @Override
    protected List<TimeSeriesMonitor.SeriesSource> getSeriesSources() {
        return this.seriesSources;
    }

    @Override
    protected void onInit(Context context) {
        for (Series series : this.series) {
            NumberDataObject numberDataObject = series.getItem();
            TimeSeriesMonitor.SeriesSource seriesSource = new TimeSeriesMonitor.SeriesSource(series.getName(), (ObservableValue<? extends Number>)numberDataObject.getObservable());
            this.seriesSources.add(seriesSource);
        }
        super.onInit(context);
    }
}

