/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import oracle.dbtools.raptor.metrics.panel.EnumItem;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

class EnumCellHelper<C extends TableColumnBase<?, Object>, L extends IndexedCell<?>> {
    private final ObservableList<EnumItem> enumItems = FXCollections.observableArrayList();
    private final List<PanelFactory.Instance> panelInstances = new ArrayList<PanelFactory.Instance>();

    EnumCellHelper() {
    }

    ObservableList<EnumItem> getEnumItems() {
        return this.enumItems;
    }

    Map<String, PanelFactory.Instance> createPanelMap() {
        HashMap<String, PanelFactory.Instance> hashMap = new HashMap<String, PanelFactory.Instance>();
        for (EnumItem enumItem : this.enumItems) {
            String string = enumItem.getValue();
            PanelFactory<Node> panelFactory = enumItem.getPanelFactory();
            if (panelFactory == null) continue;
            PanelFactory.Instance instance = panelFactory.createPanel();
            instance.start();
            hashMap.put(string, instance);
        }
        this.panelInstances.addAll(hashMap.values());
        return hashMap;
    }

    void startPanelMaps() {
        for (PanelFactory.Instance instance : this.panelInstances) {
            instance.start();
        }
    }

    void stopPanelMaps() {
        for (PanelFactory.Instance instance : this.panelInstances) {
            instance.stop();
        }
    }

    void closePanelMaps() {
        for (PanelFactory.Instance instance : this.panelInstances) {
            instance.close();
        }
    }
}

