/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.EnumCellHelper;
import oracle.dbtools.raptor.metrics.panel.EnumItem;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;
import oracle.dbtools.raptor.metrics.panel.TableCellFactory;

@DefaultProperty(value="enumItems")
public class EnumCellFactory
extends TableCellFactory<TableCell<DXRow, String>> {
    private final EnumCellHelper helper = new EnumCellHelper();

    public ObservableList<EnumItem> getEnumItems() {
        return this.helper.getEnumItems();
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        ArrayList<PanelFactory<Node>> arrayList = new ArrayList<PanelFactory<Node>>();
        for (EnumItem enumItem : this.getEnumItems()) {
            PanelFactory<Node> panelFactory = enumItem.getPanelFactory();
            if (panelFactory == null) continue;
            arrayList.add(panelFactory);
        }
        consumer.accept(arrayList);
    }

    @Override
    protected void onStart(Context context) {
        this.helper.startPanelMaps();
    }

    @Override
    protected void onStop(Context context) {
        this.helper.stopPanelMaps();
    }

    @Override
    protected void onClose(Context context) {
        this.helper.closePanelMaps();
    }

    @Override
    protected TableCell<DXRow, String> createCell() {
        return new TableCell<DXRow, String>(){
            private final Map<String, PanelFactory.Instance> panelMap;
            {
                this.panelMap = EnumCellFactory.this.helper.createPanelMap();
            }

            public void updateItem(String string, boolean bl) {
                super.updateItem((Object)string, bl);
                if (bl) {
                    this.setGraphic(null);
                } else {
                    PanelFactory.Instance instance = this.panelMap.get(string);
                    this.setGraphic(instance != null ? (Node)instance.getPanel() : null);
                }
                EnumCellFactory.this.updateCellText(this, bl);
                EnumCellFactory.this.updateCellTooltip(this, bl);
            }
        };
    }

    @Override
    protected boolean useValueColumnAsDefaultTextColumn() {
        return false;
    }
}

