/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.StringDataObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.EditableMonitor;

@DefaultProperty(value="item")
public class ChoiceBoxMonitor
extends EditableMonitor {
    private final ObjectProperty<StringDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private ChangeListener<String> changeListener;

    public StringDataObject getItem() {
        return (StringDataObject)this.itemProperty.get();
    }

    public void setItem(StringDataObject stringDataObject) {
        this.itemProperty.set((Object)stringDataObject);
    }

    public ObjectProperty<StringDataObject> itemProperty() {
        return this.itemProperty;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return ChoiceBox.class;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    @Override
    protected void onInit(Context context) {
        ChoiceBox choiceBox = context.getContainer(ChoiceBox.class);
        this.changeListener = (observableValue, string, string2) -> {
            if (this.onUpdate()) {
                choiceBox.getSelectionModel().select(string2);
            }
        };
        this.getItem().getObservable().addListener(this.changeListener);
    }

    @Override
    protected void onClose(Context context) {
        this.getItem().getObservable().removeListener(this.changeListener);
    }
}

