/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.value.ObservableListValue;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.effect.Effect;
import javafx.scene.effect.MotionBlur;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.dataobject.BoundList;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractChangeIndicatorObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;

public class CellChangeIndicator
extends AbstractChangeIndicatorObject {
    private final Set<DXKey> changedRowKeys = new HashSet<DXKey>();
    private final List<IndexedCell<?>> updatedCells = new ArrayList();
    private final Map<IndexedCell<?>, Object> cellItemMap = new HashMap();
    private final Map<IndexedCell<?>, ChangeEffect> changeEffectMap = new HashMap();

    @Override
    protected void onInit(Context context) {
        super.onInit(context);
        Control control = context.getContainer(Control.class);
        if (control != null) {
            AbstractTableMonitor abstractTableMonitor = context.getFacet(AbstractTableMonitor.class, (Map<Object, Object>)control.getProperties());
            BoundList boundList = abstractTableMonitor.getItem();
            ObservableListValue<DXRow> observableListValue = boundList.getObservable();
            HashMap hashMap = new HashMap();
            observableListValue.addListener(change -> {
                boolean bl = this.changedRowKeys.isEmpty();
                if (bl) {
                    this.populateInitialRowItemMap(abstractTableMonitor, hashMap);
                }
                while (change.next()) {
                    if (change.wasUpdated()) {
                        for (DXRow dXRow : change.getList().subList(change.getFrom(), change.getTo())) {
                            this.changedRowKeys.add(dXRow.getKey());
                        }
                        continue;
                    }
                    if (!change.wasAdded()) continue;
                    for (DXRow dXRow : change.getAddedSubList()) {
                        DXKey dXKey = dXRow.getKey();
                        this.changedRowKeys.add(dXKey);
                    }
                }
                if (bl && !this.changedRowKeys.isEmpty()) {
                    Platform.runLater(() -> {
                        control.layout();
                        this.processUpdatedCells(abstractTableMonitor, hashMap);
                        this.changedRowKeys.clear();
                        hashMap.clear();
                    });
                }
            });
        }
    }

    void onCellUpdate(IndexedCell<?> indexedCell) {
        this.updatedCells.add(indexedCell);
        if (indexedCell.getIndex() < 0) {
            this.cellItemMap.remove(indexedCell);
        } else {
            this.cellItemMap.put(indexedCell, indexedCell.getItem());
        }
    }

    private void populateInitialRowItemMap(AbstractTableMonitor abstractTableMonitor, Map<DXKey, Map<TableColumnBase<?, Object>, Object>> map) {
        for (IndexedCell<?> indexedCell : this.cellItemMap.keySet()) {
            DXRow dXRow = abstractTableMonitor.getRow(indexedCell);
            if (dXRow == null) continue;
            DXKey dXKey = dXRow.getKey();
            Object c = abstractTableMonitor.getColumn(indexedCell);
            Map<TableColumnBase<?, Object>, Object> map2 = map.get(dXKey);
            if (map2 == null) {
                map2 = new HashMap();
                map.put(dXKey, map2);
            }
            map2.put((TableColumnBase<?, Object>)c, this.cellItemMap.get(indexedCell));
        }
    }

    private void processUpdatedCells(AbstractTableMonitor abstractTableMonitor, Map<DXKey, Map<TableColumnBase<?, Object>, Object>> map) {
        Object object;
        HashMap hashMap = new HashMap();
        for (Object object2 : this.updatedCells) {
            Object object3;
            object = abstractTableMonitor.getRow(object2);
            if (object == null || !this.changedRowKeys.contains(object3 = object.getKey())) continue;
            HashMap hashMap2 = (HashMap)hashMap.get(object3);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(object3, hashMap2);
            }
            hashMap2.put(abstractTableMonitor.getColumn(object2), (IndexedCell<?>)object2);
        }
        for (Object object2 : hashMap.keySet()) {
            object = (Map)hashMap.get(object2);
            for (HashMap hashMap2 : object.keySet()) {
                Object object4;
                IndexedCell indexedCell = (IndexedCell)object.get(hashMap2);
                Object object5 = null;
                Map<TableColumnBase<?, Object>, Object> map2 = map.get(object2);
                if (map2 != null) {
                    object5 = map2.get(hashMap2);
                }
                if (Objects.equals(object5, object4 = indexedCell.getItem())) continue;
                ChangeEffect changeEffect = this.changeEffectMap.remove(indexedCell);
                if (changeEffect != null) {
                    changeEffect.cancel(indexedCell);
                }
                changeEffect = new ChangeEffect(indexedCell);
                this.changeEffectMap.put(indexedCell, changeEffect);
            }
        }
        this.updatedCells.clear();
    }

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return CellChangeIndicator.class;
    }

    private class ChangeEffect {
        private final FadeTransition fadeTransition;

        private ChangeEffect(IndexedCell<?> indexedCell) {
            this.fadeTransition = new FadeTransition(Duration.seconds((double)0.25), indexedCell);
            this.fadeTransition.setFromValue(1.0);
            this.fadeTransition.setToValue(0.9);
            this.fadeTransition.setCycleCount(2);
            this.fadeTransition.setAutoReverse(true);
            this.fadeTransition.setOnFinished(actionEvent -> this.cancel(indexedCell));
            indexedCell.setEffect((Effect)new MotionBlur(0.0, 10.0));
            this.fadeTransition.play();
        }

        private void cancel(IndexedCell<?> indexedCell) {
            if (this.fadeTransition.getStatus() == Animation.Status.RUNNING) {
                this.fadeTransition.stop();
            }
            indexedCell.setEffect(null);
            CellChangeIndicator.this.changeEffectMap.remove(indexedCell);
        }
    }
}

