/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.chart.NumberAxis;
import javafx.util.StringConverter;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractFacetObject;
import oracle.dbtools.raptor.metrics.panel.AxisValueHelper;

public abstract class AxisProperties
extends AbstractFacetObject {
    final BooleanProperty falseValue = new SimpleBooleanProperty(false);
    private final ObjectProperty<StringConverter<Number>> tickLabelFormatter = new SimpleObjectProperty();

    public String getTickFormat() {
        return this.getValueHelper().getTickFormat();
    }

    public void setTickFormat(String string) {
        this.getValueHelper().setTickFormat(string);
    }

    public StringProperty tickFormatProperty() {
        return this.getValueHelper().tickFormatProperty();
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return NumberAxis.class;
    }

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return AxisProperties.class;
    }

    @Override
    protected int getBindCardinality() {
        return 1;
    }

    abstract AxisValueHelper getValueHelper();

    double convertValueToDouble(Object object) {
        return this.getValueHelper().convertValueToDouble(object);
    }

    void initialize(NumberAxis numberAxis) {
        numberAxis.autoRangingProperty().bind((ObservableValue)this.falseValue);
        numberAxis.tickLabelFormatterProperty().bind(this.tickLabelFormatter);
        this.tickLabelFormatter.set((Object)new StringConverter<Number>(){

            public String toString(Number number) {
                return AxisProperties.this.getValueHelper().formatDouble(number.doubleValue());
            }

            public Number fromString(String string) {
                return null;
            }
        });
    }
}

