/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractTableMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSet;
import oracle.dbtools.raptor.metrics.panel.TableFeatureSetSelector;

public abstract class AbstractTableViewMonitor
extends AbstractTableMonitor<TableColumn<DXRow, Object>, TableCell<DXRow, Object>, TableFeatureSet> {
    private final ObservableList<TableFeatureSetSelector<TableFeatureSet>> featureSetSelectors = FXCollections.observableArrayList();
    private int selectedIndex = -1;
    private DXKey selectedKey = null;

    @Override
    public ObservableList<TableFeatureSetSelector<TableFeatureSet>> getFeatureSetSelectors() {
        return this.featureSetSelectors;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return TableView.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        TableView tableView = context.getContainer(TableView.class);
        if (tableView != null) {
            for (TableColumn tableColumn : tableView.getColumns()) {
                Callback callback = tableColumn.getCellFactory();
                if (!(callback instanceof AbstractCellFactory)) continue;
                AbstractCellFactory abstractCellFactory = (AbstractCellFactory)callback;
                consumer.accept(Collections.singletonList(abstractCellFactory));
            }
        }
    }

    @Override
    protected DXRow getRow(TableCell<DXRow, Object> tableCell) {
        TableRow tableRow;
        DXRow dXRow = null;
        int n = tableCell.getIndex();
        Object object = tableCell.getItem();
        if (n >= 0 && object != null && (tableRow = tableCell.getTableRow()) != null) {
            dXRow = (DXRow)tableRow.getItem();
        }
        return dXRow;
    }

    @Override
    protected TableColumn<DXRow, Object> getColumn(TableCell<DXRow, Object> tableCell) {
        return tableCell.getTableColumn();
    }

    @Override
    protected AbstractCellFactory<TableColumn<DXRow, Object>, TableCell<DXRow, Object>> getCellFactory(TableColumn<DXRow, Object> tableColumn) {
        AbstractCellFactory abstractCellFactory = null;
        Callback callback = tableColumn.getCellFactory();
        if (callback instanceof AbstractCellFactory) {
            abstractCellFactory = (AbstractCellFactory)callback;
        }
        return abstractCellFactory;
    }

    protected void bindTableView(Context context, TableView<DXRow> tableView) {
        if (tableView != null) {
            ObservableList observableList = tableView.getColumns();
            for (TableColumn tableColumn : observableList) {
                this.bindTableColumn(tableColumn);
            }
            this.getItem().getUpdating().addListener((observableValue, bl, bl2) -> {
                if (bl2.booleanValue()) {
                    DXRow dXRow = (DXRow)tableView.getSelectionModel().getSelectedItem();
                    this.selectedKey = dXRow != null ? dXRow.getKey() : null;
                    this.selectedIndex = tableView.getSelectionModel().getSelectedIndex();
                } else if (this.selectedIndex >= 0) {
                    if (this.selectedKey != null) {
                        DXRow dXRow = (DXRow)tableView.getItems().get(this.selectedIndex);
                        if (this.selectedKey.equals(dXRow.getKey())) {
                            tableView.getSelectionModel().select(this.selectedIndex);
                        } else {
                            boolean bl3 = false;
                            ObservableList observableList = tableView.getItems();
                            for (int i = 0; i < observableList.size(); ++i) {
                                if (!this.selectedKey.equals(((DXRow)observableList.get(i)).getKey())) continue;
                                tableView.getSelectionModel().select(i);
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                tableView.getSelectionModel().clearSelection();
                            }
                        }
                    } else {
                        tableView.getSelectionModel().clearSelection();
                    }
                    this.selectedIndex = -1;
                    this.selectedKey = null;
                }
            });
        }
    }

    private void bindTableColumn(TableColumn<DXRow, ?> tableColumn) {
        AbstractCellFactory<TableColumn<DXRow, Object>, TableCell<DXRow, Object>> abstractCellFactory = this.getCellFactory(tableColumn);
        if (abstractCellFactory instanceof AbstractCellFactory) {
            TableColumn<DXRow, ?> tableColumn2 = tableColumn;
            tableColumn2.setCellValueFactory(cellDataFeatures -> ((DXRow)cellDataFeatures.getValue()).get(abstractCellFactory.getValueColumn(), Comparable.class));
        }
    }
}

