/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import oracle.dbtools.raptor.metrics.dataobject.BooleanDataObject;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractDecoratorObject;
import oracle.dbtools.raptor.metrics.panel.Context;

@DefaultProperty(value="indicator")
public abstract class AbstractConditionalObject
extends AbstractDecoratorObject {
    private final ObjectProperty<BooleanDataObject> indicatorProperty = new SimpleObjectProperty((Object)this, "indicator");
    private ChangeListener<Boolean> listener;

    public BooleanDataObject getIndicator() {
        return (BooleanDataObject)this.indicatorProperty.get();
    }

    public void setIndicator(BooleanDataObject booleanDataObject) {
        this.indicatorProperty.set((Object)booleanDataObject);
    }

    public ObjectProperty<BooleanDataObject> indicatorProperty() {
        return this.indicatorProperty;
    }

    protected abstract void onIndicatorUpdated(Node var1, boolean var2);

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return AbstractConditionalObject.class;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getIndicator());
    }

    @Override
    protected void onInit(Context context) {
        Node node = context.getContainer(Node.class);
        this.listener = (observableValue, bl, bl2) -> this.onIndicatorUpdated(node, (boolean)bl2);
        this.getIndicator().getObservable().addListener(this.listener);
        this.onIndicatorUpdated(node, this.getIndicator().getObservable().get());
    }

    @Override
    protected void onClose(Context context) {
        if (this.listener != null) {
            this.getIndicator().getObservable().removeListener(this.listener);
        }
    }
}

