/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;
import oracle.dbtools.raptor.metrics.engine.ValueType;

public class ParameterType {
    private final String name;
    private final ValueType type;
    private final boolean optional;
    private final String defaultValueRep;

    public ParameterType(String string, ValueType valueType) {
        this.name = string;
        this.type = valueType;
        this.optional = false;
        this.defaultValueRep = null;
    }

    public ParameterType(String string, ValueType valueType, Object object) {
        this.name = string;
        this.type = valueType;
        this.optional = true;
        this.defaultValueRep = object != null ? object.toString() : null;
    }

    ParameterType(String string, ValueType valueType, boolean bl, String string2) {
        this.name = string;
        this.type = valueType;
        this.optional = bl;
        this.defaultValueRep = string2;
    }

    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    boolean normalize(Map<String, String> map) {
        if (map != null && map.containsKey(this.name)) {
            if (this.optional && Objects.equals(this.defaultValueRep, map.get(this.name))) {
                map.remove(this.name);
            }
        } else if (!this.optional) {
            return false;
        }
        return true;
    }

    Object convertToRaw(ValueConverter valueConverter, Map<String, String> map) {
        String string;
        String string2 = string = map != null ? map.get(this.name) : null;
        if (string == null) {
            string = this.defaultValueRep;
        }
        Object object = null;
        if (string != null) {
            try {
                object = this.type.genericToRaw(valueConverter, this.type.stringRepToGeneric(string));
            }
            catch (RuntimeException runtimeException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "unable to convert string representation '" + string + "' for parameter '" + this.getName() + "'", runtimeException);
            }
        }
        return object;
    }
}

