/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.Automaton;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DataMap;
import oracle.dbtools.raptor.metrics.engine.DataTransformer;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.InputEvent;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.JobAutomatonActions;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.ParameterTypes;
import oracle.dbtools.raptor.metrics.engine.RunnableAutomaton;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.Task;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;

class JobAutomaton
extends RunnableAutomaton<JobAutomatonActions> {
    private final JobInstance job;
    private ExecutionService executionService;
    private int pinnedItemCount;
    private Future<?> intervalTimerFuture;
    private boolean immediateRunPending;
    private final JobActions UNPINNED = new UnpinnedActions();
    private final JobActions PINNED = new PinnedActions();
    private final JobActions UNPINNED_DISABLED = new UnpinnedDisabledActions();
    private final JobActions PINNED_DISABLED = new PinnedDisabledActions();
    private final JobActions QUEUED = new QueuedActions();
    private final JobActions RUNNING_UNPINNED = new RunningUnpinnedActions();
    private final JobActions RUNNING_PINNED = new RunningPinnedActions();
    private final JobActions RUNNING_UNPINNED_DISABLED = new RunningUnpinnedDisabledActions();
    private final JobActions RUNNING_PINNED_DISABLED = new RunningPinnedDisabledActions();
    private final JobActions REMOVED = null;

    JobAutomaton(JobInstance jobInstance) {
        this.job = jobInstance;
    }

    @Override
    void start() {
        super.start();
        this.executionService = this.getContext().getExecutionService();
    }

    @Override
    JobAutomatonActions getInitialState() {
        return (Boolean)this.job.getDisabled().get() != false ? this.UNPINNED_DISABLED : this.UNPINNED;
    }

    @Override
    JobInstance getFocusObject() {
        return this.job;
    }

    InputEvent createItemPinned(final ItemInstance itemInstance) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.itemPinned(itemInstance);
            }

            @Override
            String getName() {
                return "itemPinned";
            }
        };
    }

    InputEvent createItemUnpinned(final ItemInstance itemInstance) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.itemUnpinned(itemInstance);
            }

            @Override
            String getName() {
                return "itemUnpinned";
            }
        };
    }

    InputEvent createEnable() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.enable();
            }

            @Override
            String getName() {
                return "enable";
            }
        };
    }

    InputEvent createDisable() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.disable();
            }

            @Override
            String getName() {
                return "disable";
            }
        };
    }

    InputEvent createRequestRun() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.requestRun();
            }

            @Override
            String getName() {
                return "requestRun";
            }
        };
    }

    InputEvent createCancelTimer() {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.cancelTimer();
            }

            @Override
            String getName() {
                return "cancelTimer";
            }
        };
    }

    InputEvent createPartitionLoadCompleted(final JobPartition jobPartition, final DataMap dataMap) {
        return new Automaton.AutomatonInputEvent(){

            @Override
            JobAutomatonActions callResponse(JobAutomatonActions jobAutomatonActions) {
                return jobAutomatonActions.partitionLoadCompleted(jobPartition, dataMap);
            }

            @Override
            String getName() {
                return "partitionLoadCompleted";
            }
        };
    }

    private class RunningPinnedDisabledActions
    extends AbstractPinnedActions {
        RunningPinnedDisabledActions() {
            super("RUNNING_PINNED_DISABLED");
        }

        @Override
        boolean isDisabled() {
            return true;
        }

        @Override
        boolean isPinned() {
            return true;
        }

        @Override
        boolean isRunning() {
            return true;
        }

        @Override
        JobActions enable() {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnableActivated());
            return JobAutomaton.this.RUNNING_PINNED;
        }

        @Override
        JobAutomatonActions partitionLoadCompleted(JobPartition jobPartition, DataMap dataMap) {
            this.updateItems(jobPartition, dataMap);
            return this;
        }

        @Override
        JobActions runCompleted(long l, long l2, boolean bl, DXException dXException) {
            this.updateFollowingLoad(l, l2, bl, dXException);
            return JobAutomaton.this.PINNED_DISABLED;
        }

        @Override
        JobActions onJobUnpinned() {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnableUnpinned());
            return JobAutomaton.this.RUNNING_UNPINNED_DISABLED;
        }
    }

    private class RunningUnpinnedDisabledActions
    extends AbstractUnpinnedActions {
        RunningUnpinnedDisabledActions() {
            super("RUNNING_UNPINNED_DISABLED");
        }

        @Override
        boolean isDisabled() {
            return true;
        }

        @Override
        boolean isPinned() {
            return false;
        }

        @Override
        boolean isRunning() {
            return true;
        }

        @Override
        JobActions enable() {
            return JobAutomaton.this.RUNNING_UNPINNED;
        }

        @Override
        JobAutomatonActions partitionLoadCompleted(JobPartition jobPartition, DataMap dataMap) {
            this.updateItems(jobPartition, dataMap);
            return this;
        }

        @Override
        JobActions runCompleted(long l, long l2, boolean bl, DXException dXException) {
            this.updateFollowingLoad(l, l2, bl, dXException);
            return JobAutomaton.this.UNPINNED_DISABLED;
        }

        @Override
        JobActions onJobPinned() {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnablePinned());
            return JobAutomaton.this.RUNNING_PINNED_DISABLED;
        }
    }

    private class RunningPinnedActions
    extends AbstractPinnedActions {
        RunningPinnedActions() {
            super("RUNNING_PINNED");
        }

        @Override
        boolean isDisabled() {
            return false;
        }

        @Override
        boolean isPinned() {
            return true;
        }

        @Override
        boolean isRunning() {
            return true;
        }

        @Override
        JobActions disable() {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnableInactivated());
            JobAutomaton.this.immediateRunPending = false;
            return JobAutomaton.this.RUNNING_PINNED_DISABLED;
        }

        @Override
        JobAutomatonActions requestRun() {
            JobAutomaton.this.immediateRunPending = true;
            return this;
        }

        @Override
        JobAutomatonActions partitionLoadCompleted(JobPartition jobPartition, DataMap dataMap) {
            this.updateItems(jobPartition, dataMap);
            return this;
        }

        @Override
        JobActions runCompleted(long l, long l2, boolean bl, DXException dXException) {
            JobActions jobActions;
            this.updateFollowingLoad(l, l2, bl, dXException);
            if (JobAutomaton.this.immediateRunPending) {
                JobAutomaton.this.immediateRunPending = false;
                JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createQueueRunnable(JobAutomaton.this.job));
                jobActions = JobAutomaton.this.QUEUED;
            } else {
                if (JobAutomaton.this.job.getMinimumInterval() != null) {
                    JobAutomaton.this.intervalTimerFuture = JobAutomaton.this.executionService.scheduleCommand((long)(1000.0 * (Double)JobAutomaton.this.job.getMinimumInterval().get()), new Command(){

                        @Override
                        void execute() {
                            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.createRequestRun());
                        }

                        @Override
                        URI getId() {
                            return JobAutomaton.this.job.getId();
                        }

                        @Override
                        String getName() {
                            return "intervalTimerExpired";
                        }
                    });
                }
                jobActions = JobAutomaton.this.PINNED;
            }
            return jobActions;
        }

        @Override
        JobActions onJobUnpinned() {
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableInactivated());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableUnpinned());
            JobAutomaton.this.immediateRunPending = false;
            return JobAutomaton.this.RUNNING_UNPINNED;
        }
    }

    private class RunningUnpinnedActions
    extends AbstractUnpinnedActions {
        RunningUnpinnedActions() {
            super("RUNNING_UNPINNED");
        }

        @Override
        boolean isDisabled() {
            return false;
        }

        @Override
        boolean isPinned() {
            return false;
        }

        @Override
        boolean isRunning() {
            return true;
        }

        @Override
        JobActions disable() {
            return JobAutomaton.this.RUNNING_UNPINNED_DISABLED;
        }

        @Override
        JobAutomatonActions partitionLoadCompleted(JobPartition jobPartition, DataMap dataMap) {
            this.updateItems(jobPartition, dataMap);
            return this;
        }

        @Override
        JobActions runCompleted(long l, long l2, boolean bl, DXException dXException) {
            this.updateFollowingLoad(l, l2, bl, dXException);
            if (JobAutomaton.this.job.getPartitions().isEmpty()) {
                JobAutomaton.this.executionService.addEvent(JobAutomaton.this.createRemove());
            }
            return JobAutomaton.this.UNPINNED;
        }

        @Override
        JobActions onJobPinned() {
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnablePinned());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableActivated());
            return JobAutomaton.this.RUNNING_PINNED;
        }
    }

    private class QueuedActions
    extends AbstractPinnedActions {
        QueuedActions() {
            super("QUEUED");
        }

        @Override
        boolean isDisabled() {
            return false;
        }

        @Override
        boolean isPinned() {
            return true;
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        JobActions disable() {
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createCancelQueueRunnable(JobAutomaton.this.job));
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableInactivated());
            return JobAutomaton.this.PINNED_DISABLED;
        }

        @Override
        JobActions startRun() {
            JobAutomaton.this.getContext().getLogger().log(Level.INFO, "job run submit ''{0}''", new Object[]{JobAutomaton.this.job.getId()});
            this.submitLoad();
            return JobAutomaton.this.RUNNING_PINNED;
        }

        @Override
        JobActions onJobUnpinned() {
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createCancelQueueRunnable(JobAutomaton.this.job));
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableInactivated());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableUnpinned());
            return JobAutomaton.this.UNPINNED;
        }

        private void submitLoad() {
            final HashMap<JobPartition, Map<String, Object>> hashMap = new HashMap<JobPartition, Map<String, Object>>();
            ValueConverter valueConverter = JobAutomaton.this.job.getSource().getValueConverter();
            ParameterTypes parameterTypes = JobAutomaton.this.job.getRunnableType().getParameterTypes();
            for (JobPartition jobPartition : JobAutomaton.this.job.getPartitions()) {
                hashMap.put(jobPartition, parameterTypes.convertToRaw(valueConverter, jobPartition.getParameters()));
            }
            JobAutomaton.this.executionService.submitTask(new Task(){

                @Override
                void execute() {
                    QueuedActions.this.callLoad(hashMap);
                }

                @Override
                boolean cancel() {
                    JobAutomaton.this.job.cancelRun();
                    return JobAutomaton.this.job.isRunCanceled();
                }

                @Override
                String getLabel() {
                    return MetricsResources.format("METRICS_LABEL_RUNNING_JOB", JobAutomaton.this.job.getRunLabel());
                }

                @Override
                URI getId() {
                    return JobAutomaton.this.job.getId();
                }

                @Override
                String getName() {
                    return "load";
                }
            });
        }

        private void callLoad(Map<JobPartition, Map<String, Object>> map) {
            Object object;
            DXException dXException = null;
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            long l = threadMXBean.getCurrentThreadCpuTime();
            long l2 = System.nanoTime();
            boolean bl = false;
            try {
                JobType jobType = JobAutomaton.this.job.getRunnableType();
                DataTransformer dataTransformer = jobType.getTransformer();
                DataTransformer.Context context = null;
                if (dataTransformer != null) {
                    context = new DataTransformer.Context(){

                        @Override
                        public String getVersionString() {
                            return JobAutomaton.this.job.getSource().getVersionString();
                        }
                    };
                }
                for (final JobPartition jobPartition : map.keySet()) {
                    object = JobAutomaton.this.job.load(map.get(jobPartition));
                    if (object == null) {
                        bl = true;
                        break;
                    }
                    Object object2 = dataTransformer != null ? dataTransformer.transform((DataMap)object, context) : object;
                    JobAutomaton.this.executionService.enqueueCommand(new Command((DataMap)object2){
                        final /* synthetic */ DataMap val$dataMap;
                        {
                            this.val$dataMap = dataMap;
                        }

                        @Override
                        void execute() {
                            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.createPartitionLoadCompleted(jobPartition, this.val$dataMap));
                        }

                        @Override
                        URI getId() {
                            return JobAutomaton.this.job.getId();
                        }

                        @Override
                        String getName() {
                            return "partitionLoadCompleted";
                        }
                    });
                }
            }
            catch (DXException dXException2) {
                dXException = dXException2;
            }
            catch (RuntimeException runtimeException) {
                dXException = new DXException(runtimeException);
            }
            final long l3 = System.nanoTime() - l2;
            final long l4 = l >= 0L ? threadMXBean.getCurrentThreadCpuTime() - l : -1L;
            final boolean bl2 = bl;
            object = dXException;
            JobAutomaton.this.executionService.enqueueCommand(new Command((DXException)object){
                final /* synthetic */ DXException val$loadError;
                {
                    this.val$loadError = dXException;
                }

                @Override
                void execute() {
                    JobAutomaton.this.executionService.addEvent(JobAutomaton.this.createRunCompleted(l3, l4, bl2, this.val$loadError));
                }

                @Override
                URI getId() {
                    return JobAutomaton.this.job.getId();
                }

                @Override
                String getName() {
                    return "runCompleted";
                }
            });
        }
    }

    private class PinnedDisabledActions
    extends AbstractPinnedActions {
        PinnedDisabledActions() {
            super("PINNED_DISABLED");
        }

        @Override
        boolean isDisabled() {
            return true;
        }

        @Override
        boolean isPinned() {
            return false;
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        JobActions enable() {
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableActivated());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createQueueRunnable(JobAutomaton.this.job));
            return JobAutomaton.this.QUEUED;
        }

        @Override
        JobActions onJobUnpinned() {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnableUnpinned());
            return JobAutomaton.this.UNPINNED_DISABLED;
        }
    }

    private class UnpinnedDisabledActions
    extends AbstractUnpinnedActions {
        UnpinnedDisabledActions() {
            super("UNPINNED_DISABLED");
        }

        @Override
        boolean isDisabled() {
            return true;
        }

        @Override
        boolean isPinned() {
            return false;
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        JobActions enable() {
            return JobAutomaton.this.UNPINNED;
        }

        @Override
        JobActions remove() {
            JobAutomaton.this.job.remove();
            return JobAutomaton.this.REMOVED;
        }

        @Override
        JobActions onJobPinned() {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnablePinned());
            return JobAutomaton.this.PINNED_DISABLED;
        }
    }

    private class PinnedActions
    extends AbstractPinnedActions {
        PinnedActions() {
            super("PINNED");
        }

        @Override
        boolean isDisabled() {
            return false;
        }

        @Override
        boolean isPinned() {
            return true;
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        JobActions disable() {
            this.cancelIntervalTimer();
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunnableInactivated());
            return JobAutomaton.this.PINNED_DISABLED;
        }

        @Override
        JobAutomatonActions requestRun() {
            this.cancelIntervalTimer();
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createQueueRunnable(JobAutomaton.this.job));
            return JobAutomaton.this.QUEUED;
        }

        @Override
        JobAutomatonActions cancelTimer() {
            this.cancelIntervalTimer();
            return this;
        }

        @Override
        JobActions onJobUnpinned() {
            this.cancelIntervalTimer();
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableInactivated());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableUnpinned());
            return JobAutomaton.this.UNPINNED;
        }

        private void cancelIntervalTimer() {
            if (JobAutomaton.this.intervalTimerFuture != null) {
                if (!JobAutomaton.this.intervalTimerFuture.isDone()) {
                    JobAutomaton.this.intervalTimerFuture.cancel(false);
                }
                JobAutomaton.this.intervalTimerFuture = null;
            }
        }
    }

    private class UnpinnedActions
    extends AbstractUnpinnedActions {
        UnpinnedActions() {
            super("UNPINNED");
        }

        @Override
        boolean isDisabled() {
            return false;
        }

        @Override
        boolean isPinned() {
            return false;
        }

        @Override
        boolean isRunning() {
            return false;
        }

        @Override
        JobActions disable() {
            return JobAutomaton.this.UNPINNED_DISABLED;
        }

        @Override
        JobActions remove() {
            JobAutomaton.this.job.remove();
            return JobAutomaton.this.REMOVED;
        }

        @Override
        JobActions onJobPinned() {
            SourceInstance sourceInstance = JobAutomaton.this.job.getSource();
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnablePinned());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createRunnableActivated());
            JobAutomaton.this.executionService.addEvent(sourceInstance.getAutomaton().createQueueRunnable(JobAutomaton.this.job));
            return JobAutomaton.this.QUEUED;
        }
    }

    private abstract class AbstractUnpinnedActions
    extends JobActions {
        AbstractUnpinnedActions(String string) {
            super(string);
        }

        @Override
        JobActions itemPinned(ItemInstance itemInstance) {
            itemInstance.getJobPartition().onItemPinned();
            JobAutomaton.this.pinnedItemCount = JobAutomaton.this.pinnedItemCount + 1;
            return this.onJobPinned();
        }

        @Override
        JobActions itemUnpinned(ItemInstance itemInstance) {
            JobAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event ''{0}''", JobAutomaton.this.job.getId());
            return this;
        }

        abstract JobActions onJobPinned();
    }

    private abstract class AbstractPinnedActions
    extends JobActions {
        AbstractPinnedActions(String string) {
            super(string);
        }

        @Override
        JobActions itemPinned(ItemInstance itemInstance) {
            itemInstance.getJobPartition().onItemPinned();
            JobAutomaton.this.pinnedItemCount = JobAutomaton.this.pinnedItemCount + 1;
            return this;
        }

        @Override
        JobActions itemUnpinned(ItemInstance itemInstance) {
            itemInstance.getJobPartition().onItemUnpinned();
            JobAutomaton.this.pinnedItemCount = JobAutomaton.this.pinnedItemCount - 1;
            JobActions jobActions = JobAutomaton.this.pinnedItemCount == 0 ? this.onJobUnpinned() : this;
            return jobActions;
        }

        abstract JobActions onJobUnpinned();
    }

    private abstract class JobActions
    extends JobAutomatonActions {
        JobActions(String string) {
            super(string);
        }

        @Override
        void logStateEventError() {
            JobAutomaton.this.getContext().getLogger().log(Level.SEVERE, "unexpected state machine event whilst in state '" + ((JobAutomatonActions)JobAutomaton.this.getState()).getName() + "' for job '" + JobAutomaton.this.job.getId() + "'", new IllegalStateException());
        }

        void updateItems(JobPartition jobPartition, DataMap dataMap) {
            ValueConverter valueConverter = jobPartition.getJob().getSource().getValueConverter();
            for (ItemInstance object : jobPartition.getItems()) {
                try {
                    object.update(valueConverter, dataMap);
                }
                catch (RuntimeException itemInstance) {
                    JobAutomaton.this.getContext().getLogger().log(Level.WARNING, itemInstance.getStackTrace()[0].toString(), itemInstance);
                }
            }
            jobPartition.setRunAtLeastOnce(true);
            final ArrayList arrayList = new ArrayList();
            for (ItemInstance itemInstance : jobPartition.getItems()) {
                Runnable runnable = itemInstance.createChangeNotifier();
                if (runnable == null) continue;
                arrayList.add(runnable);
            }
            JobAutomaton.this.executionService.addNotification(new Notification(){

                @Override
                void execute() {
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                }
            });
        }

        void updateFollowingLoad(long l, long l2, boolean bl, DXException dXException) {
            JobAutomaton.this.executionService.addEvent(JobAutomaton.this.job.getSource().getAutomaton().createRunCompleted(dXException));
            if (!bl && dXException == null) {
                JobAutomaton.this.getContext().getLogger().log(Level.INFO, "job run complete ''{0}'' in {1} seconds", new Object[]{JobAutomaton.this.job.getId(), (double)l / 1.0E9});
                JobAutomaton.this.getContext().getObjectManager().invokeTriggers(JobAutomaton.this.job);
                for (JobPartition jobPartition : JobAutomaton.this.job.getPartitions()) {
                    if (jobPartition.hasRunAtLeastOnce()) continue;
                    JobAutomaton.this.executionService.addEvent(JobAutomaton.this.createRequestRun());
                    break;
                }
            } else if (dXException != null) {
                JobAutomaton.this.getContext().getLogger().log(Level.WARNING, "job run failure for '" + JobAutomaton.this.job.getId() + "'", dXException);
            } else {
                JobAutomaton.this.getContext().getLogger().log(Level.WARNING, "job run canceled for ''{0}''", JobAutomaton.this.job.getId());
                JobAutomaton.this.executionService.enqueueCommand(new Command(){

                    @Override
                    void execute() {
                        JobAutomaton.this.job.getDisabled().set(true, false);
                    }

                    @Override
                    URI getId() {
                        return JobAutomaton.this.job.getId();
                    }

                    @Override
                    String getName() {
                        return "autoDisableJob";
                    }
                });
            }
        }
    }
}

