/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.AccessCommand;
import oracle.dbtools.raptor.metrics.engine.ActivityListenerService;
import oracle.dbtools.raptor.metrics.engine.CallbackCommand;
import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.ListenerEntry;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.ObjectService;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.listener.DXAccessCallback;
import oracle.dbtools.raptor.metrics.listener.DXActivityListener;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.support.MetaURLReference;

class Engine {
    private static final Engine theInstance = new Engine();
    private final Context context = Context.createContext();
    private final ObjectManager objectManager = this.context.getObjectManager();

    static Engine getInstance() {
        return theInstance;
    }

    private Engine() {
        this.context.getLogger().log(Level.INFO, "metrics engine started");
    }

    Context getContext() {
        return this.context;
    }

    <V> ListenerEntry createItemListenerEntry(final URI uRI, final Class<V> clazz, final DXItemListener<V> dXItemListener) {
        final ObjectService objectService = this.context.getObjectService();
        return new ListenerEntry(){

            @Override
            void addListener() {
                objectService.addItemListener(Engine.this.objectManager.createHandle(uRI), clazz, dXItemListener);
            }

            @Override
            void removeListener() {
                objectService.removeItemListener(Engine.this.objectManager.createHandle(uRI), dXItemListener);
            }
        };
    }

    ListenerEntry createActivityListenerEntry(final DXActivityListener dXActivityListener) {
        final ActivityListenerService activityListenerService = this.context.getActivityListenerService();
        return new ListenerEntry(){

            @Override
            void addListener() {
                activityListenerService.addActivityListener(dXActivityListener);
            }

            @Override
            void removeListener() {
                activityListenerService.removeActivityListener(dXActivityListener);
            }
        };
    }

    void enqueueCommand(Command command) {
        this.context.getExecutionService().enqueueCommand(command);
    }

    Command createRegisterListenersCommand(final List<ListenerEntry> list) {
        return new Command(){

            @Override
            void execute() {
                Engine.this.registerListeners(list);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "registerListeners";
            }
        };
    }

    Command createUnregisterListenersCommand(final List<ListenerEntry> list) {
        return new Command(){

            @Override
            void execute() {
                Engine.this.unregisterListeners(list);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "unregisterListeners";
            }
        };
    }

    Command createRequestSourceKeepAliveCommand(final URI uRI, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(this.context, dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.context.getObjectService().requestSourceKeepAlive(Engine.this.objectManager.createHandle(uRI));
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "requestSourceKeepAlive";
            }
        };
    }

    Command createRequestJobRunCommand(final URI uRI, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(this.context, dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.context.getObjectService().requestJobRun(Engine.this.objectManager.createHandle(uRI));
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "requestJobRun";
            }
        };
    }

    Command createUseMergeSetCommand(final MetaURLReference metaURLReference, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(this.context, dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.objectManager.useMergeSet(metaURLReference);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "useMergeSet";
            }
        };
    }

    Command createDiagnosticsCommand(final boolean bl) {
        return new Command(){

            @Override
            void execute() {
                Engine.this.diagnostics(bl);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "diagnostics";
            }
        };
    }

    Command createReleaseMergeSetCommand(final MetaURLReference metaURLReference, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(this.context, dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.objectManager.releaseMergeSet(metaURLReference);
            }

            @Override
            URI getId() {
                return null;
            }

            @Override
            String getName() {
                return "releaseMergeSet";
            }
        };
    }

    <T> Command createGetPropertyCommand(final URI uRI, final Class<T> clazz, final String string, DXAccessCallback<T> dXAccessCallback) {
        return new AccessCommand<T>(this.context, dXAccessCallback){

            @Override
            T executeImpl() {
                return Engine.this.context.getObjectService().getProperty(Engine.this.objectManager.createHandle(uRI), clazz, string);
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            String getName() {
                return "get";
            }
        };
    }

    <T> Command createSetPropertyCommand(final URI uRI, final Class<T> clazz, final String string, final T t, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(this.context, dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.context.getObjectService().setProperty(Engine.this.objectManager.createHandle(uRI), clazz, string, t, true);
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            String getName() {
                return "setProperty";
            }
        };
    }

    <T> Command createUseDefaultPropertyCommand(final URI uRI, final Class<T> clazz, final String string, DXOperationCallback dXOperationCallback) {
        return new CallbackCommand(this.context, dXOperationCallback){

            @Override
            void executeImpl() {
                Engine.this.context.getObjectService().useDefaultProperty(Engine.this.objectManager.createHandle(uRI), clazz, string, true);
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            String getName() {
                return "useDefaultProperty";
            }
        };
    }

    Command createInvokeOperationCommand(final URI uRI, final DXOperationCallback dXOperationCallback) {
        return new Command(){

            @Override
            void execute() {
                Engine.this.context.getObjectService().invokeOperation(Engine.this.objectManager.createHandle(uRI), dXOperationCallback);
            }

            @Override
            URI getId() {
                return uRI;
            }

            @Override
            String getName() {
                return "invokeOperation";
            }
        };
    }

    private void registerListeners(List<ListenerEntry> list) {
        for (ListenerEntry listenerEntry : list) {
            listenerEntry.addListener();
        }
    }

    private void unregisterListeners(List<ListenerEntry> list) {
        for (ListenerEntry listenerEntry : list) {
            listenerEntry.removeListener();
        }
    }

    private void diagnostics(boolean bl) {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("------> DIAGNOSTICS ------>");
        if (bl) {
            stringBuilder.append("\nSOURCE TYPES");
            bl2 = false;
            for (SourceType abstractEngineObject : this.objectManager.getSourceTypes()) {
                bl2 = true;
                stringBuilder.append("\n  ");
                stringBuilder.append(abstractEngineObject.getTypeId());
                for (JobType jobType : abstractEngineObject.jobTypeMap().values()) {
                    stringBuilder.append("\n    ");
                    stringBuilder.append(jobType.getTypeId());
                    for (ItemType itemType : jobType.itemTypeMap().values()) {
                        stringBuilder.append("\n      ");
                        stringBuilder.append(itemType.getTypeId());
                    }
                }
            }
            if (!bl2) {
                stringBuilder.append("\n -- none --");
            }
        }
        stringBuilder.append("\nLISTENERS");
        bl2 = false;
        for (SourceInstance sourceInstance : this.objectManager.getSources()) {
            bl2 = true;
            stringBuilder.append("\n  ");
            stringBuilder.append(sourceInstance.getId()).append(" ").append(sourceInstance.getAutomaton().getCurrentStateName());
            for (JobInstance jobInstance : sourceInstance.getFaultedJobs()) {
                stringBuilder.append("\n    ");
                stringBuilder.append(jobInstance.getId()).append(" ").append(jobInstance.getAutomaton().getCurrentStateName());
                for (JobPartition jobPartition : jobInstance.getPartitions()) {
                    for (ItemInstance itemInstance : jobPartition.getItems()) {
                        stringBuilder.append("\n      ");
                        stringBuilder.append(itemInstance.getId().toString());
                        for (DXItemListener<?> dXItemListener : itemInstance.getItemListeners()) {
                            stringBuilder.append("\n        ");
                            stringBuilder.append(dXItemListener.getClass());
                        }
                    }
                }
            }
        }
        if (!bl2) {
            stringBuilder.append("\n -- none --");
        }
        this.context.getLogger().log(Level.SEVERE, stringBuilder.toString());
    }
}

