/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.AbstractEngineObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.EngineObjectProperty;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobPartition;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.DXActivityEvent;
import oracle.dbtools.raptor.metrics.listener.DXActivityListener;
import oracle.dbtools.raptor.metrics.listener.DXBindEvent;
import oracle.dbtools.raptor.metrics.listener.EngineObjectChange;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

class ActivityListenerService {
    private Context context;
    private final Set<DXActivityListener> activityListeners = new HashSet<DXActivityListener>();
    private final Map<AbstractEngineObject, ChangeType> changedObjects = new HashMap<AbstractEngineObject, ChangeType>();
    private final List<AbstractEngineObject> orderedChangedObjects = new ArrayList<AbstractEngineObject>();

    ActivityListenerService() {
    }

    void setContext(Context context) {
        this.context = context;
    }

    void addEngineObjectChange(AbstractEngineObject abstractEngineObject, ChangeType changeType) {
        if (!this.activityListeners.isEmpty()) {
            if (this.changedObjects.isEmpty()) {
                this.context.getExecutionService().addNotification(new Notification(){

                    @Override
                    void execute() {
                        ArrayList<EngineObjectChange> arrayList = new ArrayList<EngineObjectChange>();
                        for (Object object : ActivityListenerService.this.orderedChangedObjects) {
                            arrayList.add(((AbstractEngineObject)object).createChangeObject((ChangeType)((Object)ActivityListenerService.this.changedObjects.get(object)), ActivityListenerService.this.createPropertyValues((AbstractEngineObject)object)));
                        }
                        ActivityListenerService.this.changedObjects.clear();
                        ActivityListenerService.this.orderedChangedObjects.clear();
                        DXActivityEvent dXActivityEvent = new DXActivityEvent(arrayList);
                        for (DXActivityListener dXActivityListener : ActivityListenerService.this.activityListeners) {
                            dXActivityListener.onUpdate(dXActivityEvent);
                        }
                    }
                });
            }
            if (changeType == ChangeType.UPDATE) {
                if (this.changedObjects.get(abstractEngineObject) == null) {
                    this.changedObjects.put(abstractEngineObject, changeType);
                    this.orderedChangedObjects.add(abstractEngineObject);
                }
            } else {
                this.changedObjects.put(abstractEngineObject, changeType);
                if (this.changedObjects.get(abstractEngineObject) != null) {
                    this.orderedChangedObjects.remove(abstractEngineObject);
                }
                this.orderedChangedObjects.add(abstractEngineObject);
            }
        }
    }

    void addActivityListener(final DXActivityListener dXActivityListener) {
        this.activityListeners.add(dXActivityListener);
        ExecutionService executionService = this.context.getExecutionService();
        executionService.addNotification(new Notification(){

            @Override
            void execute() {
                dXActivityListener.onBind(new DXBindEvent(null));
                ObjectManager objectManager = ActivityListenerService.this.context.getObjectManager();
                ArrayList<EngineObjectChange> arrayList = new ArrayList<EngineObjectChange>();
                for (SourceType abstractEngineObject : objectManager.getSourceTypes()) {
                    arrayList.add(abstractEngineObject.createChangeObject(ChangeType.ADD, ActivityListenerService.this.createPropertyValues(abstractEngineObject)));
                    for (JobType jobType : abstractEngineObject.jobTypeMap().values()) {
                        arrayList.add(jobType.createChangeObject(ChangeType.ADD, ActivityListenerService.this.createPropertyValues(jobType)));
                        for (ItemType itemType : jobType.itemTypeMap().values()) {
                            arrayList.add(itemType.createChangeObject(ChangeType.ADD, ActivityListenerService.this.createPropertyValues(itemType)));
                        }
                    }
                }
                for (SourceInstance sourceInstance : objectManager.getSources()) {
                    arrayList.add(sourceInstance.createChangeObject(ChangeType.ADD, ActivityListenerService.this.createPropertyValues(sourceInstance)));
                    for (JobInstance jobInstance : sourceInstance.getFaultedJobs()) {
                        arrayList.add(jobInstance.createChangeObject(ChangeType.ADD, ActivityListenerService.this.createPropertyValues(jobInstance)));
                        for (JobPartition jobPartition : jobInstance.getPartitions()) {
                            for (ItemInstance itemInstance : jobPartition.getItems()) {
                                arrayList.add(itemInstance.createChangeObject(ChangeType.ADD, ActivityListenerService.this.createPropertyValues(itemInstance)));
                            }
                        }
                    }
                }
                DXActivityEvent dXActivityEvent = new DXActivityEvent(arrayList);
                dXActivityListener.onUpdate(dXActivityEvent);
            }
        });
    }

    void removeActivityListener(final DXActivityListener dXActivityListener) {
        if (this.activityListeners.remove(dXActivityListener)) {
            this.context.getExecutionService().addNotification(new Notification(){

                @Override
                void execute() {
                    dXActivityListener.onUnbind(new DXBindEvent(null));
                }
            });
        } else {
            this.context.getLogger().log(Level.SEVERE, "Listener cannot be removed because it has not been added: {0}", dXActivityListener);
        }
    }

    private List<PropertyValue<?>> createPropertyValues(AbstractEngineObject abstractEngineObject) {
        ArrayList arrayList = new ArrayList();
        for (EngineObjectProperty<?> engineObjectProperty : abstractEngineObject.getProperties()) {
            arrayList.add(engineObjectProperty.createPropertyValue());
        }
        return arrayList;
    }
}

