/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.DefaultProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.engine.AbstractTypeBuilder;
import oracle.dbtools.raptor.metrics.engine.AbstractTypeObject;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.Library;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.SourceContentObject;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.Trigger;
import oracle.dbtools.raptor.metrics.engine.TriggerType;

@DefaultProperty(value="sourceContentObjects")
public abstract class AbstractSource<S extends SourceType, J extends JobType, O extends OperationType>
extends AbstractTypeBuilder<S> {
    private final ObservableList<Library> libraries = FXCollections.observableArrayList();
    private final ObservableList<SourceContentObject<?, S, J, O>> sourceContentObjects = FXCollections.observableArrayList();
    private Map<String, String> libraryMap;

    public AbstractSource() {
        this.sourceContentObjects.addListener(change -> {
            while (change.next()) {
                for (SourceContentObject sourceContentObject : change.getAddedSubList()) {
                    sourceContentObject.setContainingSource(this);
                }
            }
        });
    }

    public ObservableList<Library> getLibraries() {
        return this.libraries;
    }

    public ObservableList<SourceContentObject<?, S, J, O>> getSourceContentObjects() {
        return this.sourceContentObjects;
    }

    public abstract S createTypeObject(ClassLoader var1);

    @Override
    protected void initializeTypeObject(ClassLoader classLoader, S s) {
        List<TriggerType> list = this.createTypeObjects(Trigger.class, classLoader, s);
        ((SourceType)s).setTriggerTypes(list);
    }

    protected <T extends AbstractTypeObject, C extends SourceContentObject<T, S, J, O>> List<C> filterSourceContentObjects(Class<C> clazz) {
        return this.sourceContentObjects.stream().filter(sourceContentObject -> clazz.isAssignableFrom(sourceContentObject.getClass())).collect(Collectors.toList());
    }

    protected <T extends AbstractTypeObject, C extends SourceContentObject<T, S, J, O>> List<T> createTypeObjects(Class<C> clazz, ClassLoader classLoader, S s) {
        ArrayList arrayList = new ArrayList();
        for (SourceContentObject sourceContentObject : this.filterSourceContentObjects(clazz)) {
            Object t = sourceContentObject.createTypeObject(classLoader, s);
            arrayList.add(t);
        }
        return arrayList;
    }

    protected String resolveLibraryRefs(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        block4: while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '&': {
                    n = this.processLibraryRef(stringBuilder, string, n + 1);
                    continue block4;
                }
                case '\\': {
                    stringBuilder.append(string.charAt(n + 1));
                    n += 2;
                    continue block4;
                }
            }
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    private int processLibraryRef(StringBuilder stringBuilder, String string, int n) {
        char c;
        StringBuilder stringBuilder2 = new StringBuilder();
        while (n < string.length() && (Character.isAlphabetic(c = string.charAt(n)) || Character.isDigit(c) || c == '_')) {
            stringBuilder2.append(c);
            ++n;
        }
        if (this.libraryMap == null) {
            this.libraryMap = new HashMap<String, String>();
            for (Library library : this.libraries) {
                this.libraryMap.put(library.getName(), library.getText());
            }
        }
        stringBuilder.append(this.libraryMap.get(stringBuilder2.toString()));
        return n;
    }
}

