/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.engine.AbstractItem;
import oracle.dbtools.raptor.metrics.engine.AbstractRunnable;
import oracle.dbtools.raptor.metrics.engine.DataTransformer;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.SourceType;

@DefaultProperty(value="items")
public abstract class AbstractJob<J extends JobType, S extends SourceType, O extends OperationType>
extends AbstractRunnable<J, S, J, O> {
    private final BooleanProperty disabledProperty = new SimpleBooleanProperty();
    private final DoubleProperty minimumIntervalProperty = new SimpleDoubleProperty(-1.0);
    private final StringProperty transformerClassProperty = new SimpleStringProperty();
    private final ObservableList<AbstractItem> items = FXCollections.observableArrayList();

    public boolean isDisabled() {
        return this.disabledProperty.get();
    }

    public void setDisabled(boolean bl) {
        this.disabledProperty.set(bl);
    }

    public BooleanProperty disabledProperty() {
        return this.disabledProperty;
    }

    public double getMinimumInterval() {
        return this.minimumIntervalProperty.get();
    }

    public void setMinimumInterval(double d) {
        this.minimumIntervalProperty.set(d);
    }

    public DoubleProperty minimumIntervalProperty() {
        return this.minimumIntervalProperty;
    }

    public String getTransformerClass() {
        return (String)this.transformerClassProperty.get();
    }

    public void setTransformerClass(String string) {
        this.transformerClassProperty.set((Object)string);
    }

    public StringProperty transformerClassProperty() {
        return this.transformerClassProperty;
    }

    public ObservableList<AbstractItem> getItems() {
        return this.items;
    }

    @Override
    protected void initializeTypeObject(ClassLoader classLoader, J j) {
        super.initializeTypeObject(classLoader, j);
        ((JobType)j).setHardDefaultDisabled(this.isDisabled());
        ((JobType)j).setHardDefaultMinimumInterval(this.getMinimumInterval());
        ((JobType)j).setItemTypes(this.createItemTypes(classLoader, j));
        ((JobType)j).setTransformerClass(this.createTransformer(classLoader));
    }

    private List<ItemType> createItemTypes(ClassLoader classLoader, J j) {
        ArrayList<ItemType> arrayList = new ArrayList<ItemType>();
        for (AbstractItem abstractItem : this.items) {
            arrayList.add(abstractItem.createTypeObject(classLoader, (JobType)j));
        }
        return arrayList;
    }

    private DataTransformer createTransformer(ClassLoader classLoader) {
        DataTransformer dataTransformer = null;
        String string = this.getTransformerClass();
        if (string != null && !string.isEmpty()) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                dataTransformer = (DataTransformer)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to instantiate transformer of class '" + string + "'", exception);
            }
        }
        return dataTransformer;
    }
}

