/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.NumberExpressionDataObject;

public abstract class ArithmeticDataObject
extends NumberExpressionDataObject {
    private ObservableNumberValue observable;
    private final ObjectProperty<Double> whenNaNProperty = new SimpleObjectProperty((Object)this, "whenNaN");

    public Double getWhenNaN() {
        return (Double)this.whenNaNProperty.get();
    }

    public void setWhenNaN(Double d) {
        this.whenNaNProperty.set((Object)d);
    }

    public ObjectProperty<Double> whenNaNProperty() {
        return this.whenNaNProperty;
    }

    @Override
    public ObservableNumberValue getObservable() {
        return this.observable;
    }

    @Override
    public void initialize() {
        final ObservableNumberValue observableNumberValue = this.createObservable();
        this.observable = new DoubleBinding(){
            {
                super.bind(new Observable[]{observableNumberValue});
            }

            public void dispose() {
                super.unbind(new Observable[]{observableNumberValue});
            }

            protected double computeValue() {
                double d = ((Number)observableNumberValue.getValue()).doubleValue();
                Double d2 = ArithmeticDataObject.this.getWhenNaN();
                if (d2 == null) {
                    return d;
                }
                return Double.isFinite(d) ? d : d2;
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)ArithmeticDataObject.this.observable);
            }
        };
    }

    protected abstract ObservableNumberValue createObservable();
}

