/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extract.models;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class ExtractReconciler {
    ExtractListModel _listModel;
    private static final Logger LOGGER = Logger.getLogger(ExtractReconciler.class.getName());

    public ExtractReconciler(ExtractListModel extractListModel) {
        this._listModel = extractListModel;
    }

    public void reconcileTypesAndObjects(int n) {
        try {
            this.reconcileTypesAndObjects(n, null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileTypesAndObjects(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        DDLFormat dDLFormat = this._listModel.getDDLFormat();
        boolean bl = false;
        Map<String, String> map = dDLTypes.getTypes(this._listModel.isDataEnabled());
        ArrayList arrayList = (ArrayList)this._listModel.getListURLs(0, new int[]{108});
        ArrayList arrayList2 = (ArrayList)this._listModel.getListURLs(0, new int[]{109});
        ArrayList arrayList3 = (ArrayList)this._listModel.getURLListForType(arrayList, "TABLE");
        String string = null;
        Connection connection = null;
        String string2 = null;
        if (n == 103) {
            string = this._listModel.getSourceConnName();
            connection = this._listModel.getSourceConn();
            string2 = this._listModel.getSourceConnUser();
        } else if (n == 104 && this._listModel.getDestConn() != null) {
            string = this._listModel.getDestConnName();
            connection = this._listModel.getDestConn();
            string2 = this._listModel.getDestConnUser();
        } else {
            return;
        }
        String[] stringArray = new String[]{""};
        if (this._listModel.getSchemas().length > 0 || this._listModel.getTablespaces() != null && this._listModel.getTablespaces().length > 0) {
            stringArray = this._listModel.getSchemas();
        } else {
            stringArray[0] = string2;
        }
        block0: for (String string3 : stringArray) {
            for (String string4 : map.keySet()) {
                List<DBObject> list;
                Object object32;
                List<DBObject> list2;
                if (bl) continue block0;
                String string5 = map.get(string4);
                String string6 = ExtractResources.format("RECONCILE_PROGRESS", DDLTypes.getFolderName(string4));
                if (string4.equals("DATA")) {
                    list2 = string4;
                    object32 = new String[DDLTypes.DATA_OBJECT_TYPES.length];
                    int n2 = 0;
                    if (dDLTypes.getTable()) {
                        object32[n2++] = "TABLE";
                    }
                    if (dDLTypes.getView() && this.isExportViews(arrayList2, "VIEW")) {
                        object32[n2++] = "VIEW";
                    }
                    if (dDLTypes.getMatView() && this.isExportViews(arrayList2, "MATERIALIZED VIEW")) {
                        object32[n2++] = "MATERIALIZED VIEW";
                    }
                    boolean bl2 = true;
                    for (n2 = 0; n2 < ((String[])object32).length && object32[n2] != null; ++n2) {
                        list2 = "TABLE";
                        string5 = map.get("TABLE");
                        if (((String)object32[n2]).equals("VIEW")) {
                            list2 = "VIEW";
                            string5 = map.get("VIEW");
                        } else if (((String)object32[n2]).equals("MATERIALIZED VIEW")) {
                            list2 = "MATERIALIZED VIEW";
                            string5 = map.get("MATERIALIZED VIEW");
                        }
                        if (bl2) {
                            bl2 = false;
                            this.taskProgress(string6, iRaptorTaskProgressUpdater);
                        }
                        if (this._listModel.isExistsForType(arrayList2, (String)object32[n2])) {
                            list = this._listModel.getURLListForType(arrayList2, (String)object32[n2]);
                            for (URL uRL : list) {
                                DBObject dBObject = this.getDBObject(uRL);
                                this._listModel.getOrAddExtractObject(dBObject, new int[]{101, n});
                            }
                            continue;
                        }
                        list = null;
                        list = this._listModel.getTablespaces() == null ? DDLGenerator.getInstance().getSchemaObjects(connection, string3, (String)((Object)list2), string5) : this.getTablespaceScemaObjects(connection, string3, (String)((Object)list2));
                        if (list == null) continue;
                        for (DBObject dBObject : list) {
                            this._listModel.getOrAddExtractObject(dBObject, new int[]{101, n});
                        }
                    }
                    continue;
                }
                if (dDLFormat.isExtractEnabled() && (string4.equals("CONSTRAINT") || string4.equals("REFCONSTRAINT")) && arrayList3.size() > 0) {
                    this.taskProgress(string6, iRaptorTaskProgressUpdater);
                    for (Object object32 : arrayList3) {
                        DBObject dBObject = this.getDBObject((URL)object32);
                        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string, null, dBObject.getSchemaName(), string4);
                        list = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                        DBObject dBObject2 = new DBObject((URL)((Object)list));
                        this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                    }
                    continue;
                }
                if (dDLFormat.isExtractEnabled() && string4.equals("TRIGGER") && arrayList3.size() > 0) {
                    this.taskProgress(string6, iRaptorTaskProgressUpdater);
                    for (Object object32 : arrayList3) {
                        DBObject dBObject = this.getDBObject((URL)object32);
                        List<DBObject> list3 = this.getTriggerFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                        for (DBObject dBObject3 : list3) {
                            this._listModel.getOrAddExtractObject(dBObject3, new int[]{100, n});
                            this.addDependents(dBObject3, n);
                        }
                    }
                    continue;
                }
                if (dDLFormat.isExtractEnabled() && string4.equals("INDEX") && arrayList3.size() > 0) {
                    this.taskProgress(string6, iRaptorTaskProgressUpdater);
                    for (Object object32 : arrayList3) {
                        DBObject dBObject = this.getDBObject((URL)object32);
                        List<DBObject> list4 = this.getIndexFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                        for (DBObject dBObject4 : list4) {
                            this._listModel.getOrAddExtractObject(dBObject4, new int[]{100, n});
                            this.addDependents(dBObject4, n);
                        }
                    }
                    continue;
                }
                if (this._listModel.isExistsForType(arrayList, string4) && dDLFormat.isExtractEnabled()) {
                    this.taskProgress(string6, iRaptorTaskProgressUpdater);
                    list2 = this._listModel.getURLListForType(arrayList, string4);
                    object32 = list2.iterator();
                    while (object32.hasNext()) {
                        URL uRL = (URL)object32.next();
                        DBObject dBObject = this.getDBObject(uRL);
                        this._listModel.getOrAddExtractObject(dBObject, new int[]{100, n});
                        this.addDependents(dBObject, n);
                    }
                    continue;
                }
                if (!dDLFormat.isExtractEnabled()) continue;
                this.taskProgress(string6, iRaptorTaskProgressUpdater);
                list2 = this._listModel.getTablespaces() == null ? DDLGenerator.getInstance().getSchemaObjects(connection, string3, string4, string5) : this.getTablespaceScemaObjects(connection, string3, string4);
                if (list2 == null) continue;
                object32 = list2.iterator();
                while (object32.hasNext()) {
                    DBObject dBObject = (DBObject)object32.next();
                    this._listModel.getOrAddExtractObject(dBObject, new int[]{100, n});
                    this.addDependents(dBObject, n);
                }
            }
        }
    }

    public void reconcileObjects(int n) {
        try {
            this.reconcileObjects(n, -1, null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileObjects(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        try {
            this.reconcileObjects(n, -1, iRaptorTaskProgressUpdater);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileObjects(int n, int n2, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        DDLFormat dDLFormat = this._listModel.getDDLFormat();
        boolean bl = false;
        Map<String, String> map = dDLTypes.getTypes(this._listModel.isDataEnabled());
        ArrayList arrayList = n2 < 0 ? (ArrayList)this._listModel.getListForType(this._listModel.getList(0, new int[]{100}), "TABLE") : (ArrayList)this._listModel.getListForType(ExtractListModel.getList(this._listModel.getList(0, new int[]{n2}), new int[]{100}), "TABLE");
        String string = null;
        Connection connection = null;
        for (String string2 : map.keySet()) {
            List<DBObject> list;
            DBObject dBObject;
            if (bl) break;
            String string3 = ExtractResources.format("RECONCILE_PROGRESS", DDLTypes.getFolderName(string2));
            if (dDLFormat.isExtractEnabled() && (string2.equals("CONSTRAINT") || string2.equals("REFCONSTRAINT")) && arrayList.size() > 0) {
                this.taskProgress(string3, iRaptorTaskProgressUpdater);
                for (ExtractObject extractObject : arrayList) {
                    string = extractObject.getSourceConnName();
                    dBObject = this.getDBObject(extractObject.getUrl());
                    list = DBURLFormatHelper.getURL("sqldev.nav", string, null, dBObject.getSchemaName(), string2);
                    Iterator<DBObject> iterator = DBURLFormatHelper.getURL((URL)((Object)list), dBObject.getObjectName());
                    DBObject dBObject2 = new DBObject((URL)((Object)iterator));
                    this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                }
                continue;
            }
            if (dDLFormat.isExtractEnabled() && dDLFormat.getTrigger() && string2.equals("TRIGGER") && arrayList.size() > 0) {
                this.taskProgress(string3, iRaptorTaskProgressUpdater);
                for (ExtractObject extractObject : arrayList) {
                    connection = extractObject.getSourceConn();
                    dBObject = this.getDBObject(extractObject.getUrl());
                    list = this.getTriggerFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                    for (DBObject dBObject2 : list) {
                        this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                    }
                }
                continue;
            }
            if (!dDLFormat.isExtractEnabled() || !string2.equals("INDEX") || arrayList.size() <= 0) continue;
            this.taskProgress(string3, iRaptorTaskProgressUpdater);
            for (ExtractObject extractObject : arrayList) {
                connection = extractObject.getSourceConn();
                dBObject = this.getDBObject(extractObject.getUrl());
                list = this.getIndexFilter(connection, dBObject.getSchemaName(), dBObject.getObjectName());
                for (DBObject dBObject2 : list) {
                    this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<DBObject> getTablespaceScemaObjects(Connection connection, String string, String string2) {
        String[] stringArray;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        String string3 = "select o.owner,o.object_name,o.object_type from dba_segments s, dba_objects o where s.segment_type = o.object_type and s.segment_name = o.object_name and s.tablespace_name = :TABLESPACE and o.owner = :OWNER and o.object_type = :TYPE ";
        for (String string4 : stringArray = this._listModel.getTablespaces()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSet resultSet = null;
            hashMap.put("OWNER", string);
            hashMap.put("TABLESPACE", string4);
            hashMap.put("TYPE", string2);
            if (!Connections.getInstance().lock(connection)) continue;
            try {
                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string3, hashMap);
                String string5 = Connections.getInstance().getConnectionName(connection);
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string5, null, resultSet.getString(1), resultSet.getString(3));
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
                continue;
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return arrayList;
    }

    public boolean reconcileExistence(List<ExtractObject> list) throws Exception {
        return this.reconcileExistence(list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconcileExistence(List<ExtractObject> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws Exception {
        Object object;
        HashMap hashMap = new HashMap();
        boolean bl = true;
        for (ExtractObject object2 : list) {
            if (!object2.isTypeScript()) {
                object = object2.getSourceConnName();
                if (!hashMap.containsKey(object)) {
                    hashMap.put((String)object, new ArrayList());
                }
                ((ArrayList)hashMap.get(object)).add(object2);
                continue;
            }
            if (!object2.isScriptError()) continue;
            bl = false;
        }
        for (String string : hashMap.keySet()) {
            object = (ArrayList)hashMap.get(string);
            boolean bl2 = false;
            Connection connection = null;
            try {
                Object object2;
                connection = Connections.getInstance().getConnection(string);
                if (connection != null && (bl2 = Connections.getInstance().lock(connection))) {
                    boolean bl3 = ExtractReconciler.isConnDba(connection);
                    object2 = ((ArrayList)object).iterator();
                    while (object2.hasNext()) {
                        ExtractObject extractObject = (ExtractObject)object2.next();
                        DBObject dBObject = extractObject.getDBObject();
                        String string2 = ExtractResources.format("EXISTS_PROGRESS", dBObject.getObjectName());
                        this.taskProgress(string2, iRaptorTaskProgressUpdater);
                        extractObject.isExistsSource(ExtractReconciler.isExistsObject(connection, bl3, dBObject));
                        if (!extractObject.isExistsSource()) {
                            bl = false;
                            continue;
                        }
                        if (!extractObject.isScriptError()) continue;
                        bl = false;
                    }
                    continue;
                }
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    object2 = (ExtractObject)iterator.next();
                    ((ExtractObject)object2).isExistsSource(false);
                }
                bl = false;
            }
            finally {
                if (connection == null || !bl2) continue;
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    public static boolean reconcileExistence(ExtractObject extractObject) {
        DBObject dBObject = extractObject.getDBObject();
        boolean bl = ExtractReconciler.isConnDba(extractObject.getSourceConn());
        extractObject.isExistsSource(extractObject.getSourceConn() == null ? false : ExtractReconciler.isExistsObject(extractObject.getSourceConn(), bl, dBObject));
        return extractObject.isExistsSource();
    }

    public void reconcileDestFromSource() {
        try {
            this.reconcileDestFromSource(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileDestFromSource(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (this._listModel.getDestConn() == null) {
            return;
        }
        List<ExtractObject> list = this._listModel.getList(0);
        for (ExtractObject extractObject : list) {
            DBObject dBObject = extractObject.getDBObject();
            String string = ExtractResources.format("EXISTS_PROGRESS", dBObject.getObjectName());
            this.taskProgress(string, iRaptorTaskProgressUpdater);
            boolean bl = ExtractReconciler.isConnDba(this._listModel.getDestConn());
            Map<String, Object> map = dBObject.getDictionary();
            Object object = null;
            Object object2 = null;
            String string2 = dBObject.getObjectName();
            if (map != null) {
                object = map.get("WORKSPACE");
                object2 = map.get("APPLICATION_NAME");
                if (dBObject.getObjectType().equals("APEX")) {
                    string2 = (String)object2;
                }
            }
            if (this._listModel.getSchemas() != null && this._listModel.getDDLFormat() != null && this._listModel.getDDLFormat().getSchema()) {
                if (extractObject.isReconciledDest()) continue;
                extractObject.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), bl, extractObject.getDBObject().getSchemaName(), string2, dBObject.getObjectType(), object != null ? (String)object : ""));
                extractObject.isReconciledDest(true);
                continue;
            }
            if (this._listModel.getDDLFormat().getIgnoreSchema()) {
                if (extractObject.isReconciledDest()) continue;
                extractObject.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), bl, this._listModel.getDestConnUser(), string2, dBObject.getObjectType(), object != null ? (String)object : ""));
                extractObject.isReconciledDest(true);
                continue;
            }
            if (this._listModel.getDDLFormat().getUseOtherSchema() && this._listModel.getSchemas() != null && this._listModel.getSchemas().length > 0) {
                if (extractObject.isReconciledDest()) continue;
                extractObject.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), bl, this._listModel.getSchemas()[0], string2, dBObject.getObjectType(), object != null ? (String)object : ""));
                extractObject.isReconciledDest(true);
                continue;
            }
            if (extractObject.isReconciledDest()) continue;
            extractObject.isExistsDest(ExtractReconciler.isExistsObject(this._listModel.getDestConn(), bl, dBObject.getSchemaName(), string2, dBObject.getObjectType(), object != null ? (String)object : ""));
            extractObject.isReconciledDest(true);
        }
    }

    public void reconcileDestListFromSource() {
        try {
            this.reconcileDestListFromSource(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileDestListFromSource(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (this._listModel.getDestExtractObjects() == null) {
            return;
        }
        List<ExtractObject> list = this._listModel.getList(0);
        for (ExtractObject extractObject : list) {
            ExtractObject extractObject2;
            DBObject dBObject = extractObject.getDBObject();
            String string = ExtractResources.format("EXISTS_PROGRESS", dBObject.getObjectName());
            this.taskProgress(string, iRaptorTaskProgressUpdater);
            if (this._listModel.getDDLFormat().getIgnoreSchema()) {
                extractObject2 = this._listModel.getExtractObject(this._listModel.getDestExtractObjects(), dBObject.getObjectType(), dBObject.getObjectName());
                if (extractObject2 == null) continue;
                extractObject.isExistsDest(true);
                extractObject.setDestConnName(extractObject2.getDestConnName());
                extractObject.setDestConnUserName();
                continue;
            }
            extractObject2 = this._listModel.getExtractObject(this._listModel.getDestExtractObjects(), dBObject.getSchemaName(), dBObject.getObjectType(), dBObject.getObjectName());
            if (extractObject2 == null) continue;
            extractObject.isExistsDest(true);
            extractObject.setDestConnName(extractObject2.getDestConnName());
            extractObject.setDestConnUserName();
        }
    }

    public void expandFolders(int n, int[] nArray) {
        try {
            this.expandFolders(n, nArray, null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void expandFolders(int n, int[] nArray, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        DDLTypes dDLTypes = this._listModel.getDDLTypes();
        List<ExtractObject> list = this._listModel.getList(n);
        for (ExtractObject extractObject : list) {
            DBObject dBObject = extractObject.getDBObject();
            Map<String, Object> map = dBObject.getDictionary();
            Object object = null;
            Object object2 = null;
            String string = dBObject.getObjectName();
            if (string != null && !string.isEmpty()) continue;
            String string2 = ExtractResources.format("EXPANDING_PROGRESS", Connections.getDisplayName(dBObject.getConnectionName()) + "." + dBObject.getSchemaName() + "." + dBObject.getObjectFolderType());
            this.taskProgress(string2, iRaptorTaskProgressUpdater);
            if (map != null) {
                object = map.get("WORKSPACE");
                object2 = map.get("APPLICATION_NAME");
            }
            this._listModel.removeExtractObject(extractObject);
            ArrayList<DBObject> arrayList = DDLGenerator.getInstance().getSchemaObjects(dBObject.getConnection(), dBObject.getSchemaName(), dBObject.getObjectFolderType(), dDLTypes.getTypeKey(dBObject.getObjectFolderType()));
            if (arrayList == null) continue;
            for (DBObject dBObject2 : arrayList) {
                this._listModel.getOrAddExtractObject(dBObject2, nArray);
            }
        }
    }

    private DBObject getDBObject(URL uRL) {
        DBObject dBObject = this._listModel.getDBObject(uRL);
        return dBObject != null ? dBObject : new DBObject(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnDba(Connection connection) {
        String string = "select 1 from DBA_OBJECTS where 1=2";
        Statement statement = null;
        boolean bl = false;
        try {
            if (connection != null) {
                statement = connection.createStatement();
                statement.execute(string);
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 942) {
                LOGGER.severe(sQLException.getMessage());
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public static boolean isExistsObject(Connection connection, DBObject dBObject) {
        return ExtractReconciler.isExistsObject(connection, ExtractReconciler.isConnDba(connection), dBObject);
    }

    public static boolean isExistsObject(Connection connection, boolean bl, DBObject dBObject) {
        Map<String, Object> map = dBObject.getDictionary();
        Object object = null;
        Object object2 = null;
        String string = dBObject.getObjectName();
        if (map != null) {
            object = map.get("WORKSPACE");
            object2 = map.get("APPLICATION_NAME");
            if (dBObject.getObjectType().equals("APEX")) {
                string = (String)object2;
            }
        }
        return ExtractReconciler.isExistsObject(connection, bl, dBObject.getSchemaName(), string, dBObject.getObjectType(), (String)object);
    }

    public static boolean isExistsObject(Connection connection, String string, String string2, String string3) {
        return ExtractReconciler.isExistsObject(connection, ExtractReconciler.isConnDba(connection), string, string2, string3, "");
    }

    public static boolean isExistsObject(Connection connection, boolean bl, String string, String string2, String string3) {
        return ExtractReconciler.isExistsObject(connection, bl, string, string2, string3, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isExistsObject(Connection connection, boolean bl, String string, String string2, String string3, String string4) {
        if (connection == null) {
            return false;
        }
        String string5 = "";
        string5 = string3.equals("QUEUE TABLE") ? "select 1 from all_queue_tables where owner = :OWNER  and queue_table = :NAME " : (string3.equals("MATERIALIZED VIEW LOG") ? "select 1 from all_snapshot_logs where log_owner = :OWNER  and master = :NAME" : (string3.equals("APEX") ? " select 1 from apex_applications where owner = :OWNER  and application_name = :NAME  and workspace = :WORKSPACE" : " select 1 from " + (bl ? "dba_objects" : "all_objects") + " where owner = :OWNER  and object_type = :TYPE  and object_name = :NAME "));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        hashMap.put("TYPE", string3);
        hashMap.put("WORKSPACE", string4);
        if (Connections.getInstance().lock(connection)) {
            block6: {
                boolean bl2;
                try {
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string5, hashMap);
                    if (!resultSet.next()) break block6;
                    bl2 = true;
                }
                catch (Exception exception) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(connection);
                return bl2;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<DBObject> getObjectDeps(Connection connection, String string, String string2, String string3) {
        String string4 = "\tselect referenced_owner, referenced_name, referenced_type from ALL_DEPENDENCIES where owner = :OWNER and name = :NAME and type = decode(:TYPE,'QUEUE','UNDEFINED',:TYPE) and referenced_owner != 'SYS'  union  select b.owner, b.table_name,'TABLE' type from ALL_CONSTRAINTS a, all_constraints b  where a.owner = :OWNER  and a.table_name = :NAME  and a.constraint_type = 'R'  and a.r_constraint_name = b.constraint_name  and a.owner = b.owner  and :TYPE='TABLE'  union  select log_owner,master,'TABLE' from all_snapshot_logs where master = :NAME and :TYPE='MATERIALIZED VIEW LOG'  union  select table_owner owner,table_name name,  case (select count(*) from all_objects where object_name = table_name and owner = :OWNER \t) when 1 then 'TABLE'  when 2 then 'MATERIALIZED VIEW'  else 'UNKNOWN'  end as type  from all_indexes where index_name = :NAME and owner = :OWNER and :TYPE = 'INDEX' ";
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        hashMap.put("TYPE", string3);
        if (Connections.getInstance().lock(connection)) {
            try {
                resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string4, hashMap);
                String string5 = Connections.getInstance().getConnectionName(connection);
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string5, null, resultSet.getString(1), resultSet.getString(3));
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    throw throwable;
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> getTriggerFilter(Connection connection, String string, String string2) {
        String string3 = "Select trigger_name from all_triggers where table_owner = :OWNER and table_name = :NAME";
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        if (Connections.getInstance().lock(connection)) {
            resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string3, hashMap);
            String string4 = Connections.getInstance().getConnectionName(connection);
            try {
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, "TRIGGER");
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBObject> getIndexFilter(Connection connection, String string, String string2) {
        String string3 = "Select index_name from all_indexes where table_owner = :OWNER and table_name = :NAME";
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL uRL = null;
        ResultSet resultSet = null;
        hashMap.put("OWNER", string);
        hashMap.put("NAME", string2);
        if (Connections.getInstance().lock(connection)) {
            resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string3, hashMap);
            String string4 = Connections.getInstance().getConnectionName(connection);
            try {
                while (resultSet.next()) {
                    URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, "INDEX");
                    uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                    arrayList.add(new DBObject(uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    private void addDependents(DBObject dBObject, int n) {
        if (this._listModel.getDDLFormat() == null || !this._listModel.getDDLFormat().getDep()) {
            return;
        }
        if (!this._listModel.isSelectedData() && !this._listModel.isSelectedMetaData()) {
            return;
        }
        List<DBObject> list = this.getObjectDeps(this._listModel.getSourceConn(), dBObject.getSchemaName(), dBObject.getObjectName(), dBObject.getObjectType());
        for (DBObject dBObject2 : list) {
            this._listModel.getOrAddExtractObject(dBObject2, new int[]{100, n});
        }
    }

    private boolean isExportViews(ArrayList<URL> arrayList, String string) {
        if (this._listModel.getDataFormat().isLoader()) {
            return false;
        }
        if (!this._listModel.getDataFormat().isInsert()) {
            return true;
        }
        return this._listModel.isExistsForType(arrayList, string);
    }

    private void taskProgress(String string, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (iRaptorTaskProgressUpdater != null) {
            iRaptorTaskProgressUpdater.checkCanProceed();
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(string);
        }
    }
}

