/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.pdf;

import java.util.ArrayList;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.dbtools.raptor.format.ReportFormatOptions;
import oracle.dbtools.raptor.format.ReportPatternInfo;
import oracle.ide.panels.TraversableContext;

public class PDFConfig {
    private static final String DELIMITER = "^";
    private static final String SEPARATOR = "|";

    public void saveDocPropertiesPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("PDF_AUTHOR", pDFFormatOptions.getAuthor());
        dBConfig.putString("PDF_KEYWORDS", pDFFormatOptions.getKeywords());
        dBConfig.putString("PDF_SUBJECT", pDFFormatOptions.getSubject());
        dBConfig.putString("PDF_TITLE", pDFFormatOptions.getTitle());
        dBConfig.putInt("PDF_VERSION_SUPPORT", pDFFormatOptions.getSupportedVersion().ordinal());
        dBConfig.putInt("PDF_COMPRESSION_LEVEL", pDFFormatOptions.getCompressionLevel().ordinal());
        dBConfig.putString("PDF_FONT_LOCATION", pDFFormatOptions.getFontLocations());
        dBConfig.putString("PDF_EXTERNAL_LIBRARY", pDFFormatOptions.getExternalLibrary());
        dBConfig.putBoolean("PDF_EMBED_FONTS", pDFFormatOptions.isEmbedFonts());
    }

    public void saveHeaderFooterPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("PDF_HEADER", pDFFormatOptions.getHeader());
        dBConfig.putString("PDF_FOOTER", pDFFormatOptions.getFooter());
        dBConfig.putBoolean("PDF_INSERT_HEADER", pDFFormatOptions.isInsertHeader());
        dBConfig.putBoolean("PDF_INSERT_FOOTER", pDFFormatOptions.isInsertFooter());
        dBConfig.putBoolean("PDF_AUTO_UPDATE_DATE", pDFFormatOptions.isAutoUpdateDate());
        String string = this.formatPatterns(pDFFormatOptions.getHeaderPatternList());
        dBConfig.putString("PDF_HEADER_PATTERN", string);
        string = this.formatPatterns(pDFFormatOptions.getFooterPatternList());
        dBConfig.putString("PDF_FOOTER_PATTERN", string);
    }

    public void saveTableLayoutPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("PDF_FONT_NAME", pDFFormatOptions.getFontName());
        dBConfig.putInt("PDF_FONT_STYLE", pDFFormatOptions.getFontStyle().ordinal());
        dBConfig.putInt("PDF_FONT_SIZE", pDFFormatOptions.getFontSize());
        dBConfig.putInt("PDF_FONT_COLOR", pDFFormatOptions.getFontColor());
        dBConfig.putBoolean("PDF_USE_ROW_SHADING", pDFFormatOptions.isUseRowShading());
        dBConfig.putInt("PDF_ODD_ROW_SHADING", pDFFormatOptions.getOddRowShading());
        dBConfig.putInt("PDF_EVEN_ROW_SHADING", pDFFormatOptions.getEvenRowShading());
        dBConfig.putBoolean("PDF_SHOW_ALL_BORDERS", pDFFormatOptions.isShowAllBorders());
        dBConfig.putInt("PDF_BORDER_COLOR", pDFFormatOptions.getBorderColor());
        dBConfig.putInt("PDF_SPACING_BEFORE_TABLE", pDFFormatOptions.getSpacingBeforeTable());
        dBConfig.putInt("PDF_SPACING_AFTER_TABLE", pDFFormatOptions.getSpacingAfterTable());
        dBConfig.putInt("PDF_TABLE_HORIZONTAL_ALIGNMENT", pDFFormatOptions.getTableHorizontalAlignment().ordinal());
    }

    public void saveColumnLayoutPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("PDF_HEADER_FONT_NAME", pDFFormatOptions.getHeaderFontName());
        dBConfig.putInt("PDF_HEADER_FONT_STYLE", pDFFormatOptions.getHeaderFontStyle().ordinal());
        dBConfig.putInt("PDF_HEADER_FONT_SIZE", pDFFormatOptions.getHeaderFontSize());
        dBConfig.putInt("PDF_HEADER_FONT_COLOR", pDFFormatOptions.getHeaderFontColor());
        dBConfig.putInt("PDF_HEADER_ROW_SHADING", pDFFormatOptions.getHeaderRowShading());
        dBConfig.putInt("PDF_HEADER_LABELING", pDFFormatOptions.getColumnHeadingsAction().ordinal());
        dBConfig.putString("PDF_FOOTER_FONT_NAME", pDFFormatOptions.getFooterFontName());
        dBConfig.putInt("PDF_FOOTER_FONT_STYLE", pDFFormatOptions.getFooterFontStyle().ordinal());
        dBConfig.putInt("PDF_FOOTER_FONT_SIZE", pDFFormatOptions.getFooterFontSize());
        dBConfig.putInt("PDF_FOOTER_FONT_COLOR", pDFFormatOptions.getFooterFontColor());
        dBConfig.putInt("PDF_FOOTER_ROW_SHADING", pDFFormatOptions.getFooterRowShading());
        dBConfig.putInt("PDF_FOOTER_LABELING", pDFFormatOptions.getColumnFootingsAction().ordinal());
        dBConfig.putInt("PDF_BLOB_ACTION", pDFFormatOptions.getBlobAction().ordinal());
        dBConfig.putBoolean("PDF_CREATE_ZIP_FILE", pDFFormatOptions.isCreateZipFile());
    }

    public void saveBlobPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("PDF_BLOB_ACTION", pDFFormatOptions.getBlobAction().ordinal());
        dBConfig.putBoolean("PDF_CREATE_ZIP_FILE", pDFFormatOptions.isCreateZipFile());
    }

    public void saveCellLayoutPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("PDF_CELL_PADTOP", pDFFormatOptions.getCellPaddingTop());
        dBConfig.putInt("PDF_CELL_PADBOTTOM", pDFFormatOptions.getCellPaddingBottom());
        dBConfig.putInt("PDF_CELL_PADLEFT", pDFFormatOptions.getCellPaddingLeft());
        dBConfig.putInt("PDF_CELL_PADRIGHT", pDFFormatOptions.getCellPaddingRight());
        dBConfig.putInt("PDF_CELL_HORIZONTALALIGN", pDFFormatOptions.getCellHorizontalAlignment().ordinal());
        dBConfig.putInt("PDF_CELL_VERTICALALIGN", pDFFormatOptions.getCellVerticalAlignment().ordinal());
        dBConfig.putBoolean("PDF_CELL_WRAPTEXT", pDFFormatOptions.isWrapText());
    }

    public void savePDFPreferences(TraversableContext traversableContext, PDFFormatOptions pDFFormatOptions) {
        this.saveDocPropertiesPreferences(traversableContext, pDFFormatOptions);
        this.saveHeaderFooterPreferences(traversableContext, pDFFormatOptions);
        this.saveTableLayoutPreferences(traversableContext, pDFFormatOptions);
        this.saveColumnLayoutPreferences(traversableContext, pDFFormatOptions);
        this.saveCellLayoutPreferences(traversableContext, pDFFormatOptions);
    }

    public PDFFormatOptions getPDFPreferences() {
        DBConfig dBConfig = DBConfig.getInstance();
        PDFFormatOptions pDFFormatOptions = new PDFFormatOptions();
        pDFFormatOptions.setAuthor(dBConfig.getString("PDF_AUTHOR"));
        pDFFormatOptions.setKeywords(dBConfig.getString("PDF_KEYWORDS"));
        pDFFormatOptions.setSubject(dBConfig.getString("PDF_SUBJECT"));
        pDFFormatOptions.setTitle(dBConfig.getString("PDF_TITLE"));
        PDFFormatOptions.PDF_COMPATIBILITY[] pDF_COMPATIBILITYArray = PDFFormatOptions.PDF_COMPATIBILITY.values();
        pDFFormatOptions.setSupportedVersion(pDF_COMPATIBILITYArray[dBConfig.getInt("PDF_VERSION_SUPPORT")]);
        PDFFormatOptions.COMPRESSION_LEVEL[] cOMPRESSION_LEVELArray = PDFFormatOptions.COMPRESSION_LEVEL.values();
        pDFFormatOptions.setCompressionLevel(cOMPRESSION_LEVELArray[dBConfig.getInt("PDF_COMPRESSION_LEVEL")]);
        pDFFormatOptions.setFontLocations(dBConfig.getString("PDF_FONT_LOCATION"));
        pDFFormatOptions.setExternalLibrary(dBConfig.getString("PDF_EXTERNAL_LIBRARY"));
        pDFFormatOptions.setEmbedFonts(dBConfig.getBoolean("PDF_EMBED_FONTS").booleanValue());
        pDFFormatOptions.setHeader(dBConfig.getString("PDF_HEADER"));
        pDFFormatOptions.setFooter(dBConfig.getString("PDF_FOOTER"));
        pDFFormatOptions.setInsertHeader(dBConfig.getBoolean("PDF_INSERT_HEADER").booleanValue());
        pDFFormatOptions.setInsertFooter(dBConfig.getBoolean("PDF_INSERT_FOOTER").booleanValue());
        pDFFormatOptions.setAutoUpdateDate(dBConfig.getBoolean("PDF_AUTO_UPDATE_DATE").booleanValue());
        String string = dBConfig.getString("PDF_HEADER_PATTERN");
        pDFFormatOptions.setHeaderPatternList(this.getPatterns(string));
        string = dBConfig.getString("PDF_FOOTER_PATTERN");
        pDFFormatOptions.setFooterPatternList(this.getPatterns(string));
        pDFFormatOptions.setFontName(dBConfig.getString("PDF_FONT_NAME"));
        pDFFormatOptions.setFontSize(dBConfig.getInt("PDF_FONT_SIZE"));
        pDFFormatOptions.setFontColor(dBConfig.getInt("PDF_FONT_COLOR"));
        ReportFormatOptions.FONT_STYLE[] fONT_STYLEArray = ReportFormatOptions.FONT_STYLE.values();
        pDFFormatOptions.setFontStyle(fONT_STYLEArray[dBConfig.getInt("PDF_FONT_STYLE")]);
        pDFFormatOptions.setUseRowShading(dBConfig.getBoolean("PDF_USE_ROW_SHADING").booleanValue());
        pDFFormatOptions.setOddRowShading(dBConfig.getInt("PDF_ODD_ROW_SHADING"));
        pDFFormatOptions.setEvenRowShading(dBConfig.getInt("PDF_EVEN_ROW_SHADING"));
        pDFFormatOptions.setShowAllBorders(dBConfig.getBoolean("PDF_SHOW_ALL_BORDERS").booleanValue());
        pDFFormatOptions.setBorderColor(dBConfig.getInt("PDF_BORDER_COLOR"));
        pDFFormatOptions.setSpacingBeforeTable(dBConfig.getInt("PDF_SPACING_BEFORE_TABLE"));
        pDFFormatOptions.setSpacingAfterTable(dBConfig.getInt("PDF_SPACING_AFTER_TABLE"));
        ReportFormatOptions.HORIZONTAL_ALIGNMENT[] hORIZONTAL_ALIGNMENTArray = ReportFormatOptions.HORIZONTAL_ALIGNMENT.values();
        pDFFormatOptions.setTableHorizontalAlignment(hORIZONTAL_ALIGNMENTArray[dBConfig.getInt("PDF_TABLE_HORIZONTAL_ALIGNMENT")]);
        pDFFormatOptions.setHeaderFontName(dBConfig.getString("PDF_HEADER_FONT_NAME"));
        pDFFormatOptions.setHeaderFontSize(dBConfig.getInt("PDF_HEADER_FONT_SIZE"));
        pDFFormatOptions.setHeaderFontColor(dBConfig.getInt("PDF_HEADER_FONT_COLOR"));
        pDFFormatOptions.setHeaderFontStyle(fONT_STYLEArray[dBConfig.getInt("PDF_HEADER_FONT_STYLE")]);
        pDFFormatOptions.setHeaderRowShading(dBConfig.getInt("PDF_HEADER_ROW_SHADING"));
        ReportFormatOptions.COLUMN_LABELING[] cOLUMN_LABELINGArray = ReportFormatOptions.COLUMN_LABELING.values();
        pDFFormatOptions.setColumnHeadingsAction(cOLUMN_LABELINGArray[dBConfig.getInt("PDF_HEADER_LABELING")]);
        pDFFormatOptions.setFooterFontName(dBConfig.getString("PDF_FOOTER_FONT_NAME"));
        pDFFormatOptions.setFooterFontSize(dBConfig.getInt("PDF_FOOTER_FONT_SIZE"));
        pDFFormatOptions.setFooterFontColor(dBConfig.getInt("PDF_FOOTER_FONT_COLOR"));
        pDFFormatOptions.setFooterFontStyle(fONT_STYLEArray[dBConfig.getInt("PDF_FOOTER_FONT_STYLE")]);
        pDFFormatOptions.setFooterRowShading(dBConfig.getInt("PDF_FOOTER_ROW_SHADING"));
        pDFFormatOptions.setColumnFootingsAction(cOLUMN_LABELINGArray[dBConfig.getInt("PDF_FOOTER_LABELING")]);
        PDFFormatOptions.BLOB_ACTION[] bLOB_ACTIONArray = PDFFormatOptions.BLOB_ACTION.values();
        pDFFormatOptions.setBlobAction(bLOB_ACTIONArray[dBConfig.getInt("PDF_BLOB_ACTION")]);
        pDFFormatOptions.setCreateZipFile(dBConfig.getBoolean("PDF_CREATE_ZIP_FILE").booleanValue());
        pDFFormatOptions.setCellPaddingTop(dBConfig.getInt("PDF_CELL_PADTOP"));
        pDFFormatOptions.setCellPaddingBottom(dBConfig.getInt("PDF_CELL_PADBOTTOM"));
        pDFFormatOptions.setCellPaddingLeft(dBConfig.getInt("PDF_CELL_PADLEFT"));
        pDFFormatOptions.setCellPaddingRight(dBConfig.getInt("PDF_CELL_PADRIGHT"));
        pDFFormatOptions.setWrapText(dBConfig.getBoolean("PDF_CELL_WRAPTEXT").booleanValue());
        pDFFormatOptions.setCellHorizontalAlignment(hORIZONTAL_ALIGNMENTArray[dBConfig.getInt("PDF_CELL_HORIZONTALALIGN")]);
        ReportFormatOptions.VERTICAL_ALIGNMENT[] vERTICAL_ALIGNMENTArray = ReportFormatOptions.VERTICAL_ALIGNMENT.values();
        pDFFormatOptions.setCellVerticalAlignment(vERTICAL_ALIGNMENTArray[dBConfig.getInt("PDF_CELL_VERTICALALIGN")]);
        return pDFFormatOptions;
    }

    private String formatPatterns(ArrayList<ReportPatternInfo> arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (ReportPatternInfo reportPatternInfo : arrayList) {
            stringBuffer.append(reportPatternInfo.getPosition()).append(DELIMITER);
            stringBuffer.append(reportPatternInfo.getPattern()).append(DELIMITER);
            stringBuffer.append(reportPatternInfo.getText()).append(SEPARATOR);
        }
        return stringBuffer.toString();
    }

    private ArrayList<ReportPatternInfo> getPatterns(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty() || !string.contains(DELIMITER) || !string.contains(SEPARATOR)) {
            return null;
        }
        ArrayList<ReportPatternInfo> arrayList = new ArrayList<ReportPatternInfo>();
        for (String string2 : stringArray = string.split("\\|")) {
            String[] stringArray2 = string2.split("\\^");
            ReportPatternInfo reportPatternInfo = new ReportPatternInfo(Integer.parseInt(stringArray2[0]), stringArray2[1], stringArray2[2]);
            arrayList.add(reportPatternInfo);
        }
        return arrayList;
    }
}

