/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.data;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.databasecopy.CopyPanelArb;
import oracle.dbtools.raptor.databasecopy.DatabaseCopyException;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Service;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.util.IdeUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdeveloper.db.ConnectionException;
import oracle.sql.BFILE;
import oracle.sql.DATE;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.xdb.XMLType;

public class DataMover
extends CommandListener {
    private Connection _fromConn;
    private Connection _toConn;
    private String _toSchema;
    private OutputStreamWriter _out;
    private boolean m_ignoreAllDataErrors = false;
    private String _EOL = null;
    private boolean m_isBlobColumnExists = false;

    public DataMover() {
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public DataMover(String string, String string2, List<DBObject> list) throws ConnectionException {
        this._fromConn = Connections.getInstance().getUniqueConnection(string);
        this._toConn = Connections.getInstance().getUniqueConnection(string2);
    }

    public DataMover(Connection connection, Connection connection2, ArrayList<DBObject> arrayList) throws ConnectionException {
        this._fromConn = Connections.getInstance().cloneConnection(connection);
        this._toConn = Connections.getInstance().cloneConnection(connection2);
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
    }

    public DataMover(Connection connection, Connection connection2) {
        this(connection, connection2, false);
    }

    public DataMover(Connection connection, Connection connection2, boolean bl) {
        this._fromConn = connection;
        this._toConn = connection2;
        this.m_ignoreAllDataErrors = bl;
    }

    private synchronized void feedback(String string) {
        String string2 = IdeUtil.getIdeEncoding();
        if (string == null) {
            return;
        }
        if (this._out != null) {
            try {
                this._out.write(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setLogFile(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
    }

    public void close() {
        try {
            if (!this._fromConn.isClosed()) {
                this._fromConn.close();
            }
            if (!this._toConn.isClosed()) {
                this._toConn.close();
            }
        }
        catch (SQLException sQLException) {
            this.feedback(sQLException.getMessage() + this.getTerm());
        }
    }

    public void setToSchema(String string) {
        this._toSchema = string;
    }

    public void move(DBObject dBObject, boolean bl) {
        String string = "";
        int n = 0;
        this.move(dBObject, string, n, bl);
    }

    public boolean move(DBObject dBObject, String string, boolean bl) {
        int n = 0;
        return this.move(dBObject, string, n, bl);
    }

    public boolean move(DBObject dBObject, String string, int n, boolean bl) {
        return this.move(dBObject, "*", string, n, bl);
    }

    public boolean move(DBObject dBObject, String string, String string2, int n, boolean bl) {
        return this.move(dBObject, string, null, string2, null, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean move(DBObject dBObject, String string, String string2, String string3, String string4, int n, boolean bl) {
        Serializable serializable;
        Object object;
        Object object2;
        String string5;
        Object object3;
        String string6 = null;
        String string7 = null;
        long l = System.currentTimeMillis();
        switch (n) {
            case 0: {
                string6 = "select " + string + " from " + DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName()) + " " + string3;
                string7 = "insert into " + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                break;
            }
            case 1: {
                String string8 = DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string6 = "select " + string + " from " + string8 + " " + string3;
                string7 = "insert into " + string8;
                break;
            }
            case 2: {
                String string8 = DBUtil.addDoubleQuote((String)dBObject.getSchemaName()) + "." + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                string6 = "select " + string + " from " + string8 + " " + string3;
                string7 = "insert into " + DBUtil.addDoubleQuote((String)dBObject.getObjectName());
                break;
            }
            case 4: {
                object3 = "MDSYS.ALL_SDO_GEOM_METADATA";
                string5 = "OWNER=";
                object2 = "TABLE_NAME";
                string6 = "select " + string + " from " + (String)object3 + " " + string3;
                if (string4 == null) break;
                if (bl) {
                    this.feedback(string4 + this.getTerm());
                }
                object = DBUtil.getInstance((Connection)this._toConn);
                try {
                    object.execute(string4);
                }
                finally {
                    serializable = object.getLastException();
                    if (serializable == null) break;
                    if (bl) {
                        this.feedback(((Throwable)serializable).getLocalizedMessage());
                    }
                    if (this.dataCopyExceptionHandling(string4) != 2) break;
                    return false;
                }
            }
        }
        object3 = null;
        string5 = null;
        object2 = null;
        object = null;
        serializable = Integer.valueOf(0);
        Integer n2 = 1;
        try {
            long l2;
            block71: {
                Object object4;
                object2 = this._fromConn.prepareStatement(string6);
                object3 = object2.executeQuery();
                object3.setFetchSize(100);
                int n3 = object3.getMetaData().getColumnCount();
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                for (int i = 1; i <= n3; ++i) {
                    if (i != 1) {
                        stringBuilder.append(",");
                        stringBuilder2.append(",");
                    }
                    stringBuilder.append(DBUtil.addDoubleQuote((String)object3.getMetaData().getColumnName(i)));
                    stringBuilder2.append(":");
                    stringBuilder2.append(Service.cleanScriptFileName((String)object3.getMetaData().getColumnName(i).replaceAll(" ", "_")));
                }
                string7 = string2 == null ? string7 + "(" + stringBuilder.toString() + ") values (" + stringBuilder2.toString() + ")" : string2 + " values (" + stringBuilder2.toString() + ")";
                string5 = (OracleCallableStatement)this._toConn.prepareCall(string7);
                l2 = 0L;
                while (object3.next()) {
                    block70: {
                        if (Thread.interrupted()) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        this.m_isBlobColumnExists = false;
                        block46: for (int i = 1; i <= n3; ++i) {
                            int n4 = object3.getMetaData().getColumnType(i);
                            switch (n4) {
                                case 2004: {
                                    this.m_isBlobColumnExists = true;
                                    Blob blob = object3.getBlob(i);
                                    if (blob != null) {
                                        string5.setBlob(i, blob.getBinaryStream());
                                        continue block46;
                                    }
                                    string5.setBlob(i, blob);
                                    continue block46;
                                }
                                case 2007: {
                                    Clob clob;
                                    if (object3.getMetaData().getColumnTypeName(i).compareTo("SYS.XMLTYPE") != 0) continue block46;
                                    BFILE bFILE = ((OracleResultSet)object3).getOPAQUE(i);
                                    if (bFILE != null) {
                                        clob = XMLType.createXML((OPAQUE)bFILE);
                                        string5.setObject(i, (Object)(clob != null ? clob.getStringVal() : null));
                                        continue block46;
                                    }
                                    string5.setObject(i, (Object)bFILE);
                                    continue block46;
                                }
                                case -13: {
                                    BFILE bFILE = ((OracleResultSet)object3).getBFILE(i);
                                    string5.setBfile(i, bFILE);
                                    continue block46;
                                }
                                case 2005: {
                                    Clob clob = object3.getClob(i);
                                    if (clob != null) {
                                        string5.setClob(i, clob.getCharacterStream());
                                        continue block46;
                                    }
                                    string5.setClob(i, clob);
                                    continue block46;
                                }
                                case 2011: {
                                    NClob nClob = object3.getNClob(i);
                                    if (nClob != null) {
                                        string5.setNClob(i, nClob.getCharacterStream());
                                        continue block46;
                                    }
                                    string5.setNClob(i, nClob);
                                    continue block46;
                                }
                                case 91: {
                                    DATE dATE = ((OracleResultSet)object3).getDATE(i);
                                    string5.setDATE(i, dATE);
                                    continue block46;
                                }
                                case 101: {
                                    string5.setString(i, object3.getString(i));
                                    continue block46;
                                }
                                case -1: {
                                    if (!this.m_isBlobColumnExists) {
                                        string5.setString(i, object3.getString(i));
                                        continue block46;
                                    }
                                    string5.setString(i, null);
                                    continue block46;
                                }
                                case 92: 
                                case 93: {
                                    TIMESTAMP tIMESTAMP = ((OracleResultSet)object3).getTIMESTAMP(i);
                                    TIMESTAMP tIMESTAMP2 = tIMESTAMP != null ? new TIMESTAMP(tIMESTAMP.timestampValue()) : null;
                                    string5.setTIMESTAMP(i, tIMESTAMP2);
                                    continue block46;
                                }
                                default: {
                                    string5.setObject(i, object3.getObject(i));
                                }
                            }
                        }
                        string5.addBatch();
                        Serializable serializable2 = serializable;
                        serializable = Integer.valueOf((Integer)serializable + 1);
                        object4 = serializable;
                        if ((Integer)serializable < 500) continue;
                        try {
                            object = string5.executeBatch();
                            n2 = n2 + 1;
                        }
                        catch (SQLException sQLException) {
                            object4 = this.getDataErrorObject(dBObject, n2, (Integer)serializable) + "  " + sQLException.getMessage() + this.getTerm();
                            if (bl) {
                                this.feedback((String)object4);
                            }
                            if (this.dataCopyExceptionHandling((String)object4) != 2) break block70;
                            boolean bl3 = false;
                            try {
                                if (object2 != null) {
                                    object2.close();
                                }
                                if (object3 != null) {
                                    object3.close();
                                }
                                if (string5 != null) {
                                    string5.close();
                                }
                            }
                            catch (Exception exception) {
                                this.feedback(exception.getMessage() + this.getTerm());
                            }
                            return bl3;
                        }
                    }
                    l2 += (long)((Integer)serializable).intValue();
                    serializable = Integer.valueOf(0);
                }
                if ((Integer)serializable > 0) {
                    l2 += (long)((Integer)serializable).intValue();
                    try {
                        object = string5.executeBatch();
                    }
                    catch (SQLException sQLException) {
                        l2 -= (long)((Integer)serializable).intValue();
                        object4 = this.getDataErrorObject(dBObject, n2, (Integer)serializable) + "  " + sQLException.getMessage() + this.getTerm();
                        if (bl) {
                            this.feedback((String)object4);
                        }
                        if (this.dataCopyExceptionHandling((String)object4) != 2) break block71;
                        boolean bl4 = false;
                        try {
                            if (object2 != null) {
                                object2.close();
                            }
                            if (object3 != null) {
                                object3.close();
                            }
                            if (string5 != null) {
                                string5.close();
                            }
                        }
                        catch (Exception exception) {
                            this.feedback(exception.getMessage() + this.getTerm());
                        }
                        return bl4;
                    }
                }
            }
            if (bl) {
                this.feedback(MessageFormat.format(this.getTerm() + CopyPanelArb.getString("INSERTED_ROWS_INTO") + this.getTerm(), l2, dBObject.getObjectName(), System.currentTimeMillis() - l));
            }
            this._toConn.commit();
            boolean bl5 = true;
            return bl5;
        }
        catch (SQLException sQLException) {
            if (bl) {
                this.feedback(CopyPanelArb.getString(this.getDataErrorObject(dBObject, n2, (Integer)serializable) + "  " + sQLException.getMessage() + this.getTerm()));
            }
        }
        finally {
            try {
                if (object2 != null) {
                    object2.close();
                }
                if (object3 != null) {
                    object3.close();
                }
                if (string5 != null) {
                    string5.close();
                }
            }
            catch (Exception exception) {
                this.feedback(exception.getMessage() + this.getTerm());
            }
        }
        return true;
    }

    private OraDATEFormat getDateFormat() {
        try {
            return ((OracleNLSProvider)NLSProvider.getProvider((Connection)this._toConn)).getOraDATEFormat();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    private String getDataErrorObject(DBObject dBObject, Integer n, Integer n2) {
        return CopyPanelArb.format("DATA_ERROR_OBJECT", dBObject.getObjectType(), dBObject.getObjectName(), n.toString(), n2.toString()) + this.getTerm();
    }

    private int dataCopyExceptionHandling(String string) {
        if (!this.m_ignoreAllDataErrors) {
            DatabaseCopyException databaseCopyException = new DatabaseCopyException();
            int n = 0;
            try {
                n = databaseCopyException.askContinueOnError(string + CopyPanelArb.getString("DBCOPY_PROGRESS_CONTINUE"));
                if (n == 0) {
                    this.m_ignoreAllDataErrors = false;
                } else if (n == 1) {
                    this.m_ignoreAllDataErrors = true;
                } else if (n == 2) {
                    this.m_ignoreAllDataErrors = true;
                }
                return n;
            }
            catch (Throwable throwable) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(OutputStreamWriter outputStreamWriter, Connection connection, Connection connection2, HashMap<String, String> hashMap) throws Exception {
        ResultSet resultSet;
        this._out = outputStreamWriter;
        DDLFormat dDLFormat = DDLGenerator.getInstance().getFormating();
        DDLFormat dDLFormat2 = new DDLFormat();
        dDLFormat2.setDrop(true);
        dDLFormat2.setSchema(false);
        dDLFormat2.setSegments(false);
        dDLFormat2.setTerminiator(true);
        DDLGenerator.getInstance().setFormating(dDLFormat2);
        StringBuilder stringBuilder = new StringBuilder("select user ,object_name,object_type from user_objects ");
        boolean bl = false;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        if (hashMap.get("FILTER") != null) {
            if (bl) {
                stringBuilder.append(" and object_name like :FILTER");
            } else {
                stringBuilder.append(" where object_name like :FILTER");
                bl = true;
            }
        }
        if (hashMap.get("TYPES") != null) {
            if (bl) {
                stringBuilder.append(" and instr(:TYPES,upper(object_name)) > 0");
            } else {
                stringBuilder.append(" where instr(:TYPES,upper(object_name)) > 0");
                bl = true;
            }
        }
        if ((resultSet = DBUtil.getInstance((Connection)connection).executeQuery(stringBuilder.toString(), hashMap)) != null) {
            try {
                while (resultSet.next()) {
                    arrayList.add(new DBObject(DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", Connections.getInstance().getConnectionName(connection), null, resultSet.getString(1), resultSet.getString(3)), resultSet.getString(2))));
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        this._fromConn = connection;
        this._toConn = connection2;
        for (DBObject dBObject : arrayList) {
            this.move(dBObject, true);
        }
        DDLGenerator.getInstance().setFormating(dDLFormat);
    }

    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public void endEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
    }

    public boolean handleEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        try {
            if (iSQLCommand.getSql().trim().toLowerCase().startsWith("copyschema")) {
                String[] stringArray = iSQLCommand.getSql().split("\\W");
                Connection connection2 = Connections.getInstance().getConnection(stringArray[3]);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 3; i < stringArray.length; i += 2) {
                    hashMap.put(stringArray[i].toUpperCase(), stringArray[i + 1]);
                }
                return true;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return false;
    }
}

