/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.security;

import java.awt.Container;
import java.awt.Dimension;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.security.QuotaObject;
import oracle.dbtools.raptor.dialogs.security.QuotaPanel;
import oracle.dbtools.raptor.dialogs.security.SecurityArb;
import oracle.dbtools.raptor.dialogs.security.SubjectDialog;
import oracle.dbtools.raptor.dialogs.security.SubjectObject;
import oracle.dbtools.raptor.dialogs.security.UserObject;
import oracle.dbtools.raptor.dialogs.security.UserPanel;

public class UserDialog
extends SubjectDialog {
    private UserObject user;
    private UserPanel userPanel;
    private QuotaPanel quotaPanel;

    @Override
    protected boolean subjectIsUser() {
        return true;
    }

    @Override
    protected String getTitle(SubjectDialog.Operation operation) {
        if (operation == SubjectDialog.Operation.EDIT) {
            return SecurityArb.getString("EDIT_USER_TITLE");
        }
        return SecurityArb.getString("CREATE_USER_TITLE");
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.userPanel.userName.setEnabled(false);
        Container container = this.userPanel;
        while (!((container = container.getParent()) instanceof JEWTDialog)) {
        }
        ((JEWTDialog)container).dispose();
    }

    @Override
    protected void initialize(SubjectDialog.Operation operation, String string) {
        Object object;
        Object object22;
        this.user = new UserObject(this.connection, string, operation == SubjectDialog.Operation.EDIT);
        this.userPanel = new UserPanel(this.connection, operation == SubjectDialog.Operation.CREATE_LIKE);
        this.userPanel.setPreferredSize(new Dimension(600, 400));
        this.quotaPanel = new QuotaPanel();
        this.userPanel.userName.setText(this.operation == SubjectDialog.Operation.EDIT ? this.user.getSubjectName() : null);
        this.userPanel.userName.setEnabled(!this.user.isAlter());
        this.userPanel.userPass1.setText(this.user.getPassword());
        this.userPanel.userPass2.setText(this.user.getPassword());
        this.userPanel.accountLocked.setSelected(this.user.isLocked());
        this.userPanel.editionEnabled.setSelected(this.user.getEdition());
        this.userPanel.passExpired.setSelected(this.user.isExpired());
        this.userPanel.osUser.setSelected(this.user.isExternalUser());
        QuotaPanel.QuotaTableTableModel quotaTableTableModel = this.quotaPanel.getTableModel();
        TreeMap<String, QuotaObject> treeMap = new TreeMap<String, QuotaObject>(this.user.getQuotas());
        for (Object object22 : treeMap.keySet()) {
            if (this.user.getQuotas().get(object22).getContents().equals("TEMPORARY")) {
                this.userPanel.tempTablespace.addItem(object22);
            }
            this.userPanel.defTablespace.addItem(object22);
            object = (QuotaObject)treeMap.get(object22);
            if (!((QuotaObject)object).getContents().equals("PERMANENT")) continue;
            quotaTableTableModel.addRow((String)object22, ((QuotaObject)object).isUnlimited(), ((QuotaObject)object).getQuota(), ((QuotaObject)object).getUnit());
        }
        List<String> list = this.user.getTablespaceGroups();
        object22 = list.iterator();
        while (object22.hasNext()) {
            object = (String)object22.next();
            this.userPanel.tempTablespace.addItem(object);
        }
        this.userPanel.tempTablespace.setSelectedItem(this.user.getTempTableSpace());
        this.userPanel.defTablespace.setSelectedItem(this.user.getDefTableSpace());
    }

    @Override
    protected SubjectObject getSubject() {
        return this.user;
    }

    @Override
    protected JPanel[] getPanels() {
        JPanel[] jPanelArray = new JPanel[]{this.userPanel, this.grantedRolePanel, this.sysPrivPanel, this.quotaPanel, this.sqlPanel};
        return jPanelArray;
    }

    @Override
    protected String[] getTabNames() {
        String[] stringArray = new String[]{SecurityArb.getString("USER_TAB"), SecurityArb.getString("ROLES_TAB"), SecurityArb.getString("SYS_PRIV_TAB"), SecurityArb.getString("QUOTAS_TAB"), SecurityArb.getString("SQL_LABEL")};
        return stringArray;
    }

    @Override
    protected boolean updateUI() {
        this.user.setSubjectName(this.userPanel.userName.getText());
        this.user.setLocked(this.userPanel.accountLocked.isSelected());
        this.user.setExpired(this.userPanel.passExpired.isSelected());
        if (this.userPanel.copyObjectPrivs != null) {
            this.user.setCopyObjectPrivs(this.userPanel.copyObjectPrivs.isSelected());
        }
        this.user.setExternalUser(this.userPanel.osUser.isSelected());
        String string = new String(this.userPanel.userPass1.getPassword());
        String string2 = new String(this.userPanel.userPass2.getPassword());
        if (string.equals(string2) && !string.equals("")) {
            this.user.setPassword(string);
        }
        this.user.setDefTableSpace((String)this.userPanel.defTablespace.getSelectedItem());
        this.user.setTempTableSpace((String)this.userPanel.tempTablespace.getSelectedItem());
        if (this.userPanel.accountLocked.isSelected()) {
            this.user.setLocked(true);
        } else {
            this.user.setLocked(false);
        }
        if (this.userPanel.editionEnabled.isSelected()) {
            this.user.setEdition(true);
        } else {
            this.user.setEdition(false);
        }
        for (QuotaObject quotaObject : this.quotaPanel.getTableModel().getData()) {
            this.user.updateQuota(quotaObject);
        }
        return super.updateUI();
    }
}

