/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbreorg.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.dbdiff.Messages;
import oracle.dbtools.raptor.dbreorg.DBReorgArb;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class DBReorgWizDBSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox cbBlockFinish = new JCheckBox();
    private ExtractListModel _listModel;
    private OracleConnectionComboBox sourceConnSelector = new OracleConnectionComboBox();
    private boolean _first = true;
    private JRadioButton _schemaobjects = new JRadioButton();
    private JRadioButton _schema = new JRadioButton();
    private JRadioButton _tablespace = new JRadioButton();

    private void createValidator(DBConnectionComboBox dBConnectionComboBox) {
        final JComboBox jComboBox = dBConnectionComboBox.getJComboBox();
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                final String string = (String)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1 && ModelUtil.hasLength((String)string)) {
                    final WaitCursor waitCursor = new WaitCursor((Component)((Object)DBReorgWizDBSelector.this));
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("DiffWizDBSelector.0"), true, IRaptorTaskRunMode.TASKVIEWER){

                        protected Void doWork() throws TaskException {
                            try {
                                Connections.getInstance().getConnection(string);
                            }
                            catch (DBException dBException) {
                                throw new TaskException((Throwable)dBException);
                            }
                            return null;
                        }
                    };
                    raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanup(true);
                        }

                        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                            Throwable throwable;
                            Throwable throwable2 = raptorTaskEvent.getThrowable();
                            while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                                throwable2 = throwable;
                            }
                            ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                            this.cleanup(true);
                        }

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanup(false);
                        }

                        private void cleanup(final boolean bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    waitCursor.hide();
                                    if (bl) {
                                        jComboBox.setSelectedIndex(-1);
                                    }
                                }
                            });
                        }
                    });
                    waitCursor.show();
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            }
        });
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this._first) {
            this._first = false;
            this._schemaobjects.setText(StringUtils.stripMnemonic((String)DBReorgArb.getString("SCHEMA_OBJECT")));
            this._schemaobjects.setMnemonic(StringUtils.getMnemonicKeyCode((String)DBReorgArb.getString("SCHEMA_OBJECT")));
            this._schemaobjects.setSelected(true);
            this._schema.setText(StringUtils.stripMnemonic((String)DBReorgArb.getString("SCHEMA")));
            this._schema.setMnemonic(StringUtils.getMnemonicKeyCode((String)DBReorgArb.getString("SCHEMA")));
            this._tablespace.setText(StringUtils.stripMnemonic((String)DBReorgArb.getString("TABLESPACE")));
            this._tablespace.setMnemonic(StringUtils.getMnemonicKeyCode((String)DBReorgArb.getString("TABLESPACE")));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._schemaobjects);
            buttonGroup.add(this._schema);
            buttonGroup.add(this._tablespace);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this._schemaobjects, new GridBagConstraints(0, 0, 1, 1, 0.7, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
            jPanel.add((Component)this._schema, new GridBagConstraints(0, 1, 1, 1, 0.7, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
            jPanel.add((Component)this._tablespace, new GridBagConstraints(0, 2, 1, 1, 0.7, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
            TitledPane titledPane = new TitledPane((Component)new JLabel(DBReorgArb.getString("TYPE_TITLE")), (Component)jPanel);
            this.createValidator(this.sourceConnSelector);
            this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)DBReorgArb.getString("S_CON_LABEL")));
            jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DBReorgArb.getString("S_CON_LABEL")));
            jLabel.setLabelFor(this.sourceConnSelector.getJComboBox());
            this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.sourceConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 6, 5, 0), 0, 0));
            this.add((Component)titledPane, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 0, 5, 0), 0, 0));
            ResourceUtils.resButton((AbstractButton)this.cbBlockFinish, (String)DBReorgArb.getString("GOTO_SUMMARY"));
            this.add(this.cbBlockFinish, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(16, 0, 0, 0), 0, 0));
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private String getType() {
        if (this._schemaobjects.isSelected()) {
            return "OBJECT";
        }
        if (this._schema.isSelected()) {
            return "SCHEMA";
        }
        return "TABLESPACE";
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object object;
        if (this._listModel == null) {
            this._listModel = new ExtractListModel();
            this._listModel.isDataEnabled(false);
            object = new DDLTypes();
            ((DDLTypes)object).setShow(false);
            ((DDLTypes)object).setShowTable(true);
            ((DDLTypes)object).setShowIndex(true);
            this._listModel.setDDLTypes((DDLTypes)object);
        }
        object = this.sourceConnSelector.getCurrentConnectionName();
        Connection connection = null;
        if (object != null) {
            try {
                connection = Connections.getInstance().getConnection((String)object);
            }
            catch (DBException dBException) {
                this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            }
        }
        if (connection == null) {
            throw new TraversalException(DBReorgArb.getString("NO_SOURCE_CONNECTION"));
        }
        this._listModel.setSourceConnName((String)object);
        traversableContext.put("SOURCE_CONNECTION_NAME", object);
        traversableContext.put("SOURCE_CONNECTION", (Object)connection);
        this._listModel.setProperty("REORG_TYPE", this.getType());
        traversableContext.put("EXTRACT_LIST_MODEL", (Object)this._listModel);
    }

    public Object getExitTransition() {
        if (this.cbBlockFinish.isSelected()) {
            return "Fin";
        }
        return "A";
    }
}

