/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dbdiff.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.dbdiff.Messages;
import oracle.dbtools.raptor.dbdiff.ui.DBDiffWizArb;
import oracle.dbtools.raptor.dbdiff.ui.DbDiffDdlOptionsPanel;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class DBDiffWizDBSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox cbBlockFinish = new JCheckBox();
    private DDLFormat _ddlFormat;
    private ExtractListModel _listModel;
    private OracleConnectionComboBox sourceConnSelector = new OracleConnectionComboBox();
    private OracleConnectionComboBox destConnSelector = new OracleConnectionComboBox();
    private static DbDiffDdlOptionsPanel _ddlOptions;
    private boolean _first = true;

    private void createValidator(DBConnectionComboBox dBConnectionComboBox) {
        final JComboBox jComboBox = dBConnectionComboBox.getJComboBox();
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                final String string = (String)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1 && ModelUtil.hasLength((String)string)) {
                    final WaitCursor waitCursor = new WaitCursor((Component)((Object)DBDiffWizDBSelector.this));
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("DbDiffWizDBSelector.0"), true, IRaptorTaskRunMode.TASKVIEWER){

                        protected Void doWork() throws TaskException {
                            try {
                                Connections.getInstance().getConnection(string);
                            }
                            catch (DBException dBException) {
                                throw new TaskException((Throwable)dBException);
                            }
                            return null;
                        }
                    };
                    raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanup(true);
                        }

                        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                            Throwable throwable;
                            Throwable throwable2 = raptorTaskEvent.getThrowable();
                            while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                                throwable2 = throwable;
                            }
                            ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                            this.cleanup(true);
                        }

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            this.cleanup(false);
                        }

                        private void cleanup(final boolean bl) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    waitCursor.hide();
                                    if (bl) {
                                        jComboBox.setSelectedIndex(-1);
                                    }
                                }
                            });
                        }
                    });
                    waitCursor.show();
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            }
        });
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this._first) {
            this._first = false;
            this.createValidator(this.sourceConnSelector);
            this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            this.createValidator(this.destConnSelector);
            this.destConnSelector.getJComboBox().setSelectedIndex(-1);
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)DBDiffWizArb.getString("S_CON_LABEL")));
            jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DBDiffWizArb.getString("S_CON_LABEL")));
            jLabel.setLabelFor(this.sourceConnSelector.getJComboBox());
            this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.sourceConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 6, 5, 0), 0, 0));
            JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)DBDiffWizArb.getString("D_CON_LABEL")));
            jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DBDiffWizArb.getString("D_CON_LABEL")));
            jLabel2.setLabelFor(this.destConnSelector.getJComboBox());
            this.add(jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.destConnSelector.getJComboBox(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
            this._ddlFormat = new DDLFormat();
            this._ddlFormat.setDDLOptionsEnabled(false);
            this._ddlFormat.setShowDDLOptionsEnabled(false);
            this._ddlFormat.isExtractEnabled(true);
            this._ddlFormat.setShowCompareOptionsEnabled(true);
            _ddlOptions = new DbDiffDdlOptionsPanel(this._ddlFormat);
            this.add(_ddlOptions.getPanel(), new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 0, 0), 0, 0));
            ResourceUtils.resButton((AbstractButton)this.cbBlockFinish, (String)DBDiffWizArb.getString("GOTO_SUMMARY"));
            this.add(this.cbBlockFinish, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 0, 0), 0, 0));
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object object;
        if (this._listModel == null) {
            this._listModel = new ExtractListModel();
            this._listModel.isDataEnabled(false);
            object = new DDLTypes();
            ((DDLTypes)object).setShow(false);
            ((DDLTypes)object).setEnable(false);
            ((DDLTypes)object).setTable(true);
            ((DDLTypes)object).setShowTable(true);
            ((DDLTypes)object).setView(true);
            ((DDLTypes)object).setShowView(true);
            ((DDLTypes)object).setIndex(true);
            ((DDLTypes)object).setShowIndex(true);
            ((DDLTypes)object).setTrigger(true);
            ((DDLTypes)object).setShowTrigger(true);
            ((DDLTypes)object).setMatView(true);
            ((DDLTypes)object).setShowMatView(true);
            ((DDLTypes)object).setMatViewLog(true);
            ((DDLTypes)object).setShowMatViewLog(true);
            ((DDLTypes)object).setType(true);
            ((DDLTypes)object).setShowType(true);
            ((DDLTypes)object).setSequence(true);
            ((DDLTypes)object).setShowSequence(true);
            ((DDLTypes)object).setSynonymn(true);
            ((DDLTypes)object).setShowSynonymn(true);
            ((DDLTypes)object).setDbLink(true);
            ((DDLTypes)object).setShowDbLink(true);
            ((DDLTypes)object).setPackSpec(true);
            ((DDLTypes)object).setShowPackSpec(true);
            ((DDLTypes)object).setPackBody(true);
            ((DDLTypes)object).setShowPackBody(true);
            ((DDLTypes)object).setProcedure(true);
            ((DDLTypes)object).setShowProcedure(true);
            ((DDLTypes)object).setFunction(true);
            ((DDLTypes)object).setShowFunction(true);
            this._listModel.setDDLTypes((DDLTypes)object);
        }
        this._listModel.setDDLFormat(_ddlOptions.getFormat());
        object = this.sourceConnSelector.getCurrentConnectionName();
        Connection connection = null;
        if (object != null) {
            try {
                connection = Connections.getInstance().getConnection((String)object);
            }
            catch (DBException dBException) {
                this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            }
        }
        if (connection == null) {
            throw new TraversalException(DBDiffWizArb.getString("NO_SOURCE_CONNECTION"));
        }
        this._listModel.setSourceConnName((String)object);
        String string = this.destConnSelector.getCurrentConnectionName();
        Connection connection2 = null;
        if (string != null) {
            try {
                connection2 = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                this.destConnSelector.getJComboBox().setSelectedIndex(-1);
            }
        }
        if (connection2 == null) {
            throw new TraversalException(DBDiffWizArb.getString("NO_DEST_CONNECTION"));
        }
        this._listModel.setDestConnName(string);
        if (ModelUtil.areEqual((Object)object, (Object)string)) {
            throw new TraversalException(DBDiffWizArb.getString("SAME_CONNECTION"));
        }
        traversableContext.put("SOURCE_CONNECTION_NAME", object);
        traversableContext.put("SOURCE_CONNECTION", (Object)connection);
        traversableContext.put("DEST_CONNECTION_NAME", (Object)string);
        traversableContext.put("DEST_CONNECTION", (Object)connection2);
        traversableContext.put("EXTRACT_LIST_MODEL", (Object)this._listModel);
    }

    public Object getExitTransition() {
        if (this.cbBlockFinish.isSelected()) {
            return "Fin";
        }
        return "A";
    }
}

