/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.writers.ImportGen;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import org.stringtemplate.v4.ST;

public class ImportGenXTab
extends ImportGen {
    private ImportProperties _iProps;
    private boolean _isValid = false;
    private int _loadMethod;
    private LoadFile _loadFile;
    private Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public ImportGenXTab(ImportProperties importProperties) {
        super(importProperties);
        this._iProps = importProperties;
    }

    @Override
    public ExitCode start() {
        ExitCode exitCode = super.start();
        if (exitCode == ExitCode.EXIT_SEVERE) {
            return exitCode;
        }
        return this.validate();
    }

    @Override
    public ExitCode generate() {
        if (!this._isValid) {
            return ExitCode.EXIT_SEVERE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET DEFINE OFF\n");
        this._loadMethod = this._iProps.getValueInteger(ImportKeys.LOAD_METHOD);
        if (this._loadMethod == 3 && !this.isExistingTable()) {
            stringBuffer.append(this.getCreateTableStatementWithComments() + "\n\n");
        }
        stringBuffer.append(this.getExtCreateTableStatement() + "\n\n");
        if (this._loadMethod == 3) {
            stringBuffer.append(this.getInsertStatementFromStaging() + "\n\n");
        }
        String string = stringBuffer.toString();
        string = string.replaceAll("\\r", "");
        this.getStream().println(string);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.68"));
        if (!this.isBatch()) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, Messages.getString("ImportGenerator.77"));
            if (this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN) != null) {
                try {
                    ImportGenXTab.openSqlNodeForURL((URL)this._iProps.get(ImportKeys.URL_FOR_AUTO_OPEN));
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        this.getStream().finished();
        return ExitCode.EXIT_SUCCESS;
    }

    private ExitCode validate() {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        this._loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        this._isValid = true;
        return exitCode;
    }

    private String getExtCreateTableStatement() {
        Object object;
        String string;
        String string2;
        Object object22;
        String string3 = this.getGenTable().getTable().getTablename();
        String string4 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        String[] stringArray = this.formatTableColumns(this._loadMethod == 3 && this.isExistingTable());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string5 : stringArray) {
            arrayList.add(string5.replaceAll("NOT NULL", ""));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object22 : this.getGenTable().getColumns()) {
            string2 = (String)this._iProps.get(ImportKeys.CHARNUMCHARACTERS);
            string = this.addDoubleQuote(object22.getName()) + " CHAR(4000)";
            if (string2 != null && string2 != "" && string2.replaceAll("[0-9]*", "").equals("")) {
                string = this.addDoubleQuote(object22.getName()) + " CHAR(" + string2 + ")";
            }
            if (object22.getType().equalsIgnoreCase("DATE")) {
                if (object22.getFormat() == null) {
                    arrayList2.add(string + " date_format DATE");
                    continue;
                }
                arrayList2.add(string + " date_format DATE mask \"" + object22.getFormat() + "\"");
                continue;
            }
            if (object22.getType().equalsIgnoreCase("TIMESTAMP")) {
                if (object22.getFormat() == null) {
                    arrayList2.add(string + " date_format TIMESTAMP");
                    continue;
                }
                arrayList2.add(string + " date_format TIMESTAMP mask \"" + object22.getFormat() + "\"");
                continue;
            }
            arrayList2.add(string);
        }
        ST sT = this.getTemplateGroup().getInstanceOf("CreateExtTableStatement");
        sT.add("tableName", (Object)(this._loadMethod == 3 ? this.addUser(string4) : this.addUser(this.addDoubleQuote(string3))));
        sT.add("colList", (Object)arrayList.toArray());
        sT.add("nameList", (Object)arrayList2.toArray());
        String string6 = this._loadFile.getCanonicalName();
        string6 = string6.replaceFirst("^([a-zA-Z]:)([^\\\\])", "$1\\\\$2");
        String string7 = string6.substring(string6.lastIndexOf(File.separator) + 1);
        string6 = string6.substring(string6.lastIndexOf(File.separator) + 1, string6.lastIndexOf(46));
        sT.add("fileName", (Object)string6);
        sT.add("path", this._iProps.get(ImportKeys.DIRPATH));
        sT.add("dirName", (Object)((String)this._iProps.get(ImportKeys.ORADIRNAME)));
        object22 = "NOBADFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USEBADFILE).booleanValue()) {
            string2 = (String)this._iProps.get(ImportKeys.ORABADDIRNAME);
            if (string2 == null || string2.length() == 0) {
                string2 = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            object22 = "BADFILE " + string2 + ":'" + string6 + ".bad'";
        }
        sT.add("badClause", object22);
        string2 = "NOLOGFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USELOGFILE).booleanValue()) {
            string = (String)this._iProps.get(ImportKeys.ORALOGDIRNAME);
            if (string == null || string.length() == 0) {
                string = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            string2 = "LOGFILE " + string + ":'" + string6 + ".log'";
        }
        sT.add("logClause", (Object)string2);
        string = "NODISCARDFILE";
        if (this._iProps.getValueBoolean(ImportKeys.USEDISCARDFILE).booleanValue()) {
            object = (String)this._iProps.get(ImportKeys.ORADISCARDDIRNAME);
            if (object == null || ((String)object).length() == 0) {
                object = (String)this._iProps.get(ImportKeys.ORADIRNAME);
            }
            string = "DISCARDFILE " + (String)object + ":'" + string6 + ".discard'";
        }
        sT.add("discardClause", (Object)string);
        object = this.getDataFormat();
        String string8 = BaseDataFormat.singleQuote(BaseDataFormat.getDelimiterString(((BaseDataFormat)object).getDelimiter()));
        if (string8 == null || string8.equals("")) {
            string8 = "','";
        } else if (string8.equals("'WHITESPACE'")) {
            string8 = "WHITESPACE";
        }
        sT.add("fieldDelimiter", (Object)string8);
        Integer n = this.getDataFormat().isHeader() ? ((ImportDataFormat)object).getSkipRows() + 1 : ((ImportDataFormat)object).getSkipRows();
        sT.add("toSkip", (Object)n.toString());
        sT.add("allFile", (Object)string7);
        String string9 = (String)this._iProps.get(ImportKeys.CHARSETVAL);
        if (!string9.equals("")) {
            string9 = "CHARACTERSET " + string9;
        }
        sT.add("charset", (Object)string9);
        String string10 = BaseDataFormat.singleQuote(BaseDataFormat.getRecordTerminatorString(((BaseDataFormat)object).getRecordTerminator()));
        sT.add("newline", (Object)string10);
        String string11 = ((BaseDataFormat)object).getEnclosureLeftValue();
        String string12 = ((BaseDataFormat)object).getEnclosureRightValue();
        String string13 = "";
        if (string11.length() != 0) {
            string13 = "OPTIONALLY ENCLOSED BY '" + string11 + "' AND '" + string12 + "'";
        }
        sT.add("enclosures", (Object)string13);
        if (this._iProps.get(ImportKeys.PREVIEW_LIMIT) == null) {
            sT.add("limit", (Object)"");
        } else {
            sT.add("limit", (Object)("WHERE ROWNUM <= " + (String)this._iProps.get(ImportKeys.PREVIEW_LIMIT)));
        }
        return sT.render();
    }

    private String getInsertStatementFromStaging() {
        String string = (String)this._iProps.get(ImportKeys.TABLE_NAME);
        String string2 = (String)this._iProps.get(ImportKeys.STAGING_TABLE_NAME);
        ST sT = (ST)this._iProps.get(ImportKeys.SELECTED_COLUMNS);
        String[] stringArray = new String[((Column[])sT).length];
        int n = 0;
        for (Column column : sT) {
            stringArray[n++] = this.addDoubleQuote(column.getName());
        }
        ST sT2 = null;
        sT2 = (Boolean)this._iProps.get(ImportKeys.DROP_STAGING_TABLE) != false ? this.getTemplateGroup().getInstanceOf("InsertStatementFromStagingWithDrop") : this.getTemplateGroup().getInstanceOf("InsertStatementFromStaging");
        sT2.add("tableName", (Object)this.addUser(this.addDoubleQuote(string)));
        sT2.add("stagingTableName", (Object)this.addUser(this.addDoubleQuote(string2)));
        sT2.add("colList", (Object)stringArray);
        int n2 = (Integer)this._iProps.get(ImportKeys.LOAD_LIMIT);
        if (n2 > 0) {
            String string3 = "WHERE ROWNUM <= " + n2;
            sT2.add("loadLimitClause", (Object)string3);
        }
        return sT2.render();
    }
}

