/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.readers;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.readers.DataReader;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.datatools.DataToolsArb;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class DelimitedReader
extends DataReader {
    public static final String NAME = "Delimited";
    public static final String FORMAT = BaseDataFormat.DELIMITED;
    public static final String EXT = "dsv";
    public static final int BUFFER_SIZE = 1024;
    public static final int BUFFER_KSIZE = 1;
    public static final String KEY_HEADER = "IMPORT_DLM_HEADER";
    public static final String KEY_DELIMITER = "IMPORT_DLM_DELIMITER";
    public static final String KEY_REC_TERM = "IMPORT_DLM_REC_TERM";
    public static final String KEY_ENCL_LEFT = "IMPORT_DLM_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "IMPORT_DLM_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "IMPORT_DLM_ENCL_RIGHT_DOUBLE";
    private BufferedReader m_csvFileReader;
    private BufferedReader m_previewReader;
    private FileInputStream m_previewFileInputStream;
    private InputStreamReader m_previewStreamReader;
    private boolean m_previewFileEOF;
    private int m_previewToReadCount;
    private int m_previewFileSize;
    private int m_previewMaxLength;
    private char[] m_previewReadAheadBuffer;
    private int m_previewReadAheadNumRead = -1;
    private int m_bufferSize;
    private boolean m_terminatorFound;
    private String m_terminatorValue;
    private String m_encoding;
    private List<Object[]> m_previewRows = null;
    private List<byte[]> m_previewBuffers;
    private List<String> m_recTermList = new ArrayList<String>();
    private int m_currentPreviewBuffer;
    private boolean m_previewTruncate = false;
    private Integer[] m_columnWidths = null;
    private ArrayList<Integer> m_columnWidthsList = new ArrayList();
    private int m_columnCount = -1;
    private String m_currentRow = null;
    private String[] m_firstRow = null;
    private boolean m_isCheckTerminator = true;
    private boolean m_isStandardTerm;
    private DataFormatException m_dataFormatException = null;
    private String m_saveTerminator;
    private int m_dataFormatExceptionRow;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public String[] getColumnNames() {
        if (!this.dataFormat.isHeader()) {
            return this.getDefaultColumnNames();
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_firstRow == null) {
            this.getPreviewRows();
        }
        if (this.m_firstRow != null && this.m_firstRow.length > 0) {
            for (int i = 0; i < this.m_firstRow.length; ++i) {
                if (this.m_firstRow[i] != null) {
                    if (hashMap.containsKey(this.m_firstRow[i])) {
                        hashMap.put(this.m_firstRow[i], (Integer)hashMap.get(this.m_firstRow[i]) + 1);
                        arrayList.add(this.m_firstRow[i].toString() + hashMap.get(this.m_firstRow[i]));
                        continue;
                    }
                    hashMap.put(this.m_firstRow[i], 1);
                    arrayList.add(this.m_firstRow[i]);
                    continue;
                }
                arrayList.add(this.getDefColumn() + (i + 1));
            }
            this.m_headerRowColumnNames = arrayList.toArray(new String[arrayList.size()]);
        }
        return this.m_headerRowColumnNames;
    }

    private String[] splitRow(String string) throws DataFormatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.dataFormat.getDelimiterValue();
        int n = string2.length();
        int n2 = -1;
        if (n != 0) {
            int n3 = 0;
            int n4 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
                string2 = "\t";
                n = 1;
            }
            String string3 = this.dataFormat.getEnclosureLeftValue();
            String string4 = this.dataFormat.getEnclosureRightValue();
            boolean bl = this.dataFormat.getEnclosures();
            if (n4 == 2) {
                n4 = 0;
            }
            int n5 = 0;
            while (n5 < string.length()) {
                char c = string.charAt(n5);
                switch (n4) {
                    case 0: {
                        if (bl && string.startsWith(string3, n5)) {
                            n5 += string3.length();
                            n4 = 1;
                            break;
                        }
                        if (this.isThisDelimiter(string, n5, string2)) {
                            arrayList.add(stringBuilder.toString());
                            ++n3;
                            stringBuilder = new StringBuilder();
                            n5 += n;
                            if (!BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) break;
                            n4 = 2;
                            break;
                        }
                        stringBuilder.append(c);
                        ++n5;
                        break;
                    }
                    case 1: {
                        if (bl && string.startsWith(string4, n5)) {
                            n5 += string4.length();
                            n4 = this.dataFormat.isEnclosureRightDouble() ? 3 : 4;
                            break;
                        }
                        stringBuilder.append(c);
                        ++n5;
                        break;
                    }
                    case 2: {
                        if (!this.isThisDelimiter(string, n5, string2)) {
                            if (bl && string.startsWith(string3, n5)) {
                                n4 = 1;
                                stringBuilder = new StringBuilder();
                                n5 += string3.length();
                                break;
                            }
                            n4 = 0;
                            ++n5;
                            stringBuilder.append(c);
                            break;
                        }
                        n5 += n;
                        break;
                    }
                    case 3: {
                        if (this.isThisDelimiter(string, n5, string2)) {
                            arrayList.add(stringBuilder.toString());
                            ++n3;
                            stringBuilder = new StringBuilder();
                            n5 += n;
                            if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
                                n4 = 2;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        if (string.startsWith(string4, n5)) {
                            stringBuilder.append(c);
                            ++n5;
                            n4 = 1;
                            break;
                        }
                        if (n2 == -1) {
                            n2 = n5;
                        }
                        stringBuilder.append(string4 + c);
                        ++n5;
                        n4 = 5;
                        break;
                    }
                    case 4: {
                        if (this.isThisDelimiter(string, n5, string2)) {
                            arrayList.add(stringBuilder.toString());
                            ++n3;
                            stringBuilder = new StringBuilder();
                            n5 += n;
                            if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
                                n4 = 2;
                                break;
                            }
                            n4 = 0;
                            break;
                        }
                        if (string.startsWith(string4, n5)) {
                            stringBuilder.append(string4);
                            ++n5;
                            break;
                        }
                        stringBuilder.append(string4 + c);
                        ++n5;
                        n4 = 1;
                        break;
                    }
                    case 5: {
                        stringBuilder.append(c);
                        ++n5;
                    }
                }
            }
            if (n4 == 0) {
                arrayList.add(stringBuilder.toString());
                n3 = 0;
                stringBuilder = new StringBuilder();
            } else if (n4 == 1) {
                arrayList.add(string3 + stringBuilder.toString());
                if (n2 == -1) {
                    n2 = string.length() - 1;
                }
            } else if (n4 != 0) {
                arrayList.add(stringBuilder.toString());
            }
        } else {
            arrayList.add(string);
        }
        if (n2 != -1) {
            String string5 = DataImportArb.format("DATA_FORMAT_EXCEPTION", n2 + 1);
            throw new DataFormatException(string5, n2 + 1, string, arrayList.toArray(new String[arrayList.size()]));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isThisDelimiter(String string, int n, String string2) {
        if (BaseDataFormat.isDelimiterWhiteSpace(this.dataFormat.getDelimiterValue())) {
            return string.startsWith(string2, n) || string.startsWith(" ", n);
        }
        return string.startsWith(string2, n);
    }

    @Override
    public boolean hasMoreRows() {
        try {
            this.m_currentRow = this.readLine(this.m_csvFileReader);
            if (this.m_currentRow != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.m_currentRow = null;
        }
        return false;
    }

    @Override
    public void openFile(String string) throws DataReaderException {
        try {
            if (this.m_csvFileReader != null) {
                this.m_csvFileReader.close();
            }
            this.m_csvFileReader = this.openDataFile(string);
        }
        catch (Throwable throwable) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            throw new DataReaderException(throwable.getMessage());
        }
        this.m_currentRow = null;
    }

    @Override
    public void closeFile() {
        this.closeCsvFile();
        this.closePreviewFile();
    }

    public void closeCsvFile() {
        try {
            if (this.m_csvFileReader != null) {
                this.m_csvFileReader.close();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this.m_currentRow = null;
        this.m_csvFileReader = null;
    }

    @Override
    public void start() throws DataReaderException {
        try {
            if (this.m_csvFileReader != null) {
                this.m_csvFileReader.close();
            }
            this.m_csvFileReader = this.openDataFile(this.getFileName());
        }
        catch (Throwable throwable) {
            this.m_currentRow = null;
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            throw new DataReaderException(throwable.getMessage());
        }
        this.m_currentRow = null;
    }

    public BufferedReader openDataFile(String string) {
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        this.m_currentRow = null;
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.dataFormat.getEncoding());
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fireSimpleEvent(Messages.getString("CSVReader.11"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedReader;
    }

    public void setDelimiter(String string) {
    }

    private void setColumnWidths(String[] stringArray) {
        if (stringArray.length > this.m_columnCount) {
            this.m_columnCount = stringArray.length;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n = stringArray[i].length();
                if (i + 1 > this.m_columnWidthsList.size()) {
                    this.m_columnWidthsList.add(new Integer(n));
                    continue;
                }
                if (n <= this.m_columnWidthsList.get(i)) continue;
                this.m_columnWidthsList.set(i, new Integer(n));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void refreshPreview(boolean bl) {
        super.refreshPreview(bl);
        this.m_columnCount = -1;
        this.m_columnWidths = null;
        this.m_previewRows = null;
    }

    @Override
    public int getColumnCount() {
        if (this.m_columnCount < 0 || this.m_refreshPreview) {
            this.getPreviewRows();
            if (this.m_columnCount < 0) {
                return 0;
            }
        }
        return this.m_columnCount;
    }

    @Override
    public String getType(int n) {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        List<Object[]> list = this.getPreviewRows();
        for (Object[] objectArray : list) {
            arrayList.add(this.parse(objectArray[n].toString()));
        }
        return this.mostLikelyDatatype(arrayList);
    }

    private String mostLikelyDatatype(ArrayList<DataType> arrayList) {
        HashMap<DataType, Integer> hashMap = new HashMap<DataType, Integer>();
        DataType dataType = null;
        for (int i = 0; i < DataType.values().length; ++i) {
            hashMap.put(DataType.values()[i], 0);
        }
        for (DataType object : arrayList) {
            hashMap.put(object, (Integer)hashMap.get((Object)object) + 1);
        }
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            DataType dataType2 = (DataType)((Object)entry.getKey());
            if (dataType == null) {
                dataType = dataType2;
                n = (Integer)hashMap.get((Object)dataType2);
                continue;
            }
            if ((Integer)hashMap.get((Object)dataType2) <= n) continue;
            dataType = dataType2;
            n = (Integer)hashMap.get((Object)dataType2);
        }
        return dataType.toString();
    }

    public DataType parse(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Object object = null;
        try {
            object = new Integer(string);
            return DataType.NUMBER;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                object = new Double(string);
                return DataType.NUMBER;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    object = simpleDateFormat.parse(string);
                    return DataType.DATE;
                }
                catch (ParseException parseException) {
                    object = string;
                    return DataType.VARCHAR2;
                }
            }
        }
    }

    @Override
    public int getWidth(int n) {
        if (this.m_columnWidths == null) {
            this.getPreviewRows();
        }
        if (n > this.m_columnWidths.length - 1) {
            return 0;
        }
        return this.m_columnWidths[n];
    }

    @Override
    public int getNosPages() {
        return 1;
    }

    @Override
    public String[] getPageNames() {
        return null;
    }

    @Override
    public String getPageLabel() {
        return null;
    }

    @Override
    public void setPage(int n) {
    }

    @Override
    public Object[] readline() throws DataFormatException {
        return this.splitRow(this.m_currentRow);
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = this.dataFormat.getRecordTerminatorValue(this.dataFormat.getRecordTerminator());
        if (!(string.equalsIgnoreCase("\r\n") || string.equals("\n") || string.equals("\n"))) {
            StringBuffer stringBuffer;
            block3: {
                char[] cArray = new char[1];
                int n = bufferedReader.read(cArray);
                if (n == -1) {
                    return null;
                }
                int n2 = n;
                stringBuffer = new StringBuffer();
                String string2 = "";
                stringBuffer.append(cArray);
                do {
                    n = bufferedReader.read(cArray);
                    n2 += n;
                    if (n == -1) break block3;
                    stringBuffer.append(cArray);
                } while (stringBuffer.length() < string.length() || string.length() <= 0 || !(string2 = stringBuffer.substring(stringBuffer.length() - string.length(), stringBuffer.length())).equals(string));
                return stringBuffer.substring(0, stringBuffer.length() - string.length());
            }
            return stringBuffer.length() == 0 ? null : stringBuffer.toString();
        }
        return bufferedReader.readLine();
    }

    public BufferedReader openPreviewFile() {
        try {
            if (this.m_previewBuffers == null) {
                this.m_previewFileEOF = false;
                this.m_previewBuffers = new ArrayList<byte[]>();
                File file = new File(this.getFileName());
                this.m_previewFileSize = (int)file.length();
                this.m_previewFileInputStream = new FileInputStream(file);
                int n = this.dataFormat.getPreviewCharactersLimit();
                int n2 = this.m_previewMaxLength = n != 0 ? n : 1024;
                if (file.length() < (long)this.m_previewMaxLength || !this.dataFormat.getUseMaxLength()) {
                    this.m_previewMaxLength = this.m_previewFileSize;
                }
                this.m_previewToReadCount = this.m_previewMaxLength;
                int n3 = this.m_bufferSize = n > 0 && n < 1024 ? n : 1024;
                if (file.length() < (long)this.m_bufferSize) {
                    this.m_bufferSize = (int)file.length();
                }
                this.m_currentPreviewBuffer = -1;
                this.readPreviewFile(this.m_bufferSize);
            }
            if (!this.m_previewBuffers.isEmpty()) {
                return this.getPreviewReader(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fireSimpleEvent(Messages.getString("CSVReader.11"));
        }
        return null;
    }

    public void restartPreview() {
        if (this.m_previewBuffers == null) {
            this.m_previewReader = this.openPreviewFile();
        } else if (!this.m_previewBuffers.isEmpty()) {
            this.m_currentPreviewBuffer = 0;
            this.m_previewReader = this.getPreviewReader(0);
        }
    }

    private BufferedReader getNextPreviewBuffer() {
        if (this.m_previewBuffers.size() > this.m_currentPreviewBuffer + 1) {
            return this.getPreviewReader(++this.m_currentPreviewBuffer);
        }
        if (!this.m_previewFileEOF && this.m_previewToReadCount > 0) {
            int n = this.m_previewToReadCount > this.m_bufferSize ? this.m_bufferSize : this.m_previewToReadCount;
            this.readPreviewFile(n);
            return !this.m_previewFileEOF ? this.getPreviewReader(this.m_currentPreviewBuffer) : null;
        }
        this.m_previewFileEOF = true;
        return null;
    }

    private BufferedReader getPreviewReader(int n) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_previewBuffers.get(n));
            this.m_encoding = this.dataFormat.getEncoding();
            this.m_previewStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, this.m_encoding);
            return new BufferedReader(this.m_previewStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = DataImportArb.format("ENCODING_ERROR", this.m_encoding);
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
        }
        catch (Exception exception) {
            String string = DataImportArb.format("ENCODING_ERROR", this.m_encoding);
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
        }
        return null;
    }

    private boolean readPreviewFile(int n) {
        int n2 = 0;
        try {
            byte[] byArray = new byte[n];
            n2 = this.m_previewFileInputStream.read(byArray);
            if (n2 > 0) {
                this.m_previewToReadCount -= n2;
                this.m_previewBuffers.add(byArray);
                ++this.m_currentPreviewBuffer;
                return this.m_previewFileEOF;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        this.m_previewFileEOF = true;
        this.closePreviewFile();
        return this.m_previewFileEOF;
    }

    public void closePreviewFile() {
        try {
            if (this.m_previewFileInputStream != null) {
                this.m_previewFileInputStream.close();
                this.m_previewFileInputStream = null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        try {
            if (this.m_previewReader != null) {
                this.m_previewReader.close();
                this.m_previewReader = null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        try {
            if (this.m_previewStreamReader != null) {
                this.m_previewStreamReader.close();
                this.m_previewStreamReader = null;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    @Override
    public List<Object[]> getPreviewRows() {
        this.m_currentRow = null;
        this.m_previewReadAheadBuffer = new char[1];
        this.m_previewReadAheadNumRead = -1;
        this.m_terminatorFound = false;
        this.m_terminatorValue = this.dataFormat.getRecordTerminatorValue();
        this.m_isCheckTerminator = true;
        this.m_isStandardTerm = BaseDataFormat.isRecordTerminatorStandard(this.dataFormat.getRecordTerminator());
        this.m_previewTruncate = false;
        if (!this.m_refreshPreview && this.m_previewRows != null && this.dataFormat.getUsePreviewLimit()) {
            return this.m_previewRows;
        }
        String string = null;
        String[] stringArray = null;
        this.m_dataFormatException = null;
        this.m_dataFormatExceptionRow = -1;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (this.m_previewBuffers == null) {
            this.m_previewReader = this.openPreviewFile();
        } else {
            this.restartPreview();
        }
        try {
            int n;
            this.m_firstRow = null;
            this.m_columnWidthsList = new ArrayList();
            if (this.dataFormat.getSkipRows() != 0) {
                n = this.dataFormat.isHeader() ? this.dataFormat.getSkipRows() + 1 : this.dataFormat.getSkipRows();
                for (int i = 0; i < n && (string = this.readPreviewLine()) != null; ++i) {
                    block25: {
                        if (!this.dataFormat.isHeader() || (this.dataFormat.isHeaderAfter() || i != 0) && (!this.dataFormat.isHeaderAfter() || i != n - 1)) continue;
                        try {
                            stringArray = this.splitRow(string);
                        }
                        catch (DataFormatException dataFormatException) {
                            if (this.m_dataFormatException != null) break block25;
                            this.m_dataFormatException = dataFormatException;
                            this.m_dataFormatExceptionRow = 1;
                            stringArray = this.m_dataFormatException.getColumns();
                        }
                    }
                    arrayList.add(stringArray);
                }
            }
            for (n = 0; !((string = this.readPreviewLine()) == null || this.dataFormat.getUsePreviewLimit() && n >= this.dataFormat.getPreviewLimit()); ++n) {
                try {
                    stringArray = this.splitRow(string);
                }
                catch (DataFormatException dataFormatException) {
                    if (this.m_dataFormatException == null) {
                        this.m_dataFormatException = dataFormatException;
                        this.m_dataFormatExceptionRow = n + 1;
                    }
                    stringArray = dataFormatException.getColumns();
                }
                arrayList.add(stringArray);
                if (!this.m_refreshPreview || this.dataFormat.isHeader() && n == 0) continue;
                this.setColumnWidths(stringArray);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        if (!arrayList.isEmpty()) {
            this.m_firstRow = (String[])arrayList.get(0);
        }
        if (this.m_refreshPreview) {
            this.m_columnWidths = this.m_columnWidthsList.toArray(new Integer[this.m_columnWidthsList.size()]);
            this.m_refreshPreview = false;
        }
        if (this.dataFormat.getUsePreviewLimit()) {
            this.m_previewRows = arrayList;
        }
        if (this.m_dataFormatException != null) {
            SwingUtilities.invokeLater(new Runnable(){
                String msg;
                {
                    this.msg = DataImportArb.format("DATA_FORMAT_EXCEPTION_FILE", DelimitedReader.this.m_dataFormatExceptionRow) + DelimitedReader.this.m_dataFormatException.getMessage() + "\n" + DataImportArb.getString("DATA_FORMAT_EXCEPTION_LINE") + "\n" + DelimitedReader.this.m_dataFormatException.getLine() + "\n";
                }

                @Override
                public void run() {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)this.msg, (String)DataImportArb.getString("DATA_FORMAT_TITLE"), null);
                }
            });
        }
        if (this.m_isStandardTerm || !this.m_terminatorValue.equals(this.dataFormat.getRecordTerminatorValue())) {
            this.m_saveTerminator = this.dataFormat.getRecordTerminator();
            if (this.m_terminatorValue.equals("\n")) {
                this.dataFormat.setRecordTerminator(DataToolsArb.getString("LF"));
            } else if (this.m_terminatorValue.equals("\r\n")) {
                this.dataFormat.setRecordTerminator(DataToolsArb.getString("CRLF"));
            } else if (this.m_terminatorValue.equals("\r")) {
                this.dataFormat.setRecordTerminator(DataToolsArb.getString("CR"));
            }
            if (!this.m_isStandardTerm) {
                SwingUtilities.invokeLater(new Runnable(){
                    String msg;
                    {
                        this.msg = DataImportArb.format("RECORD_TERM_INFO", DelimitedReader.this.dataFormat.getRecordTerminator(), DelimitedReader.this.m_saveTerminator);
                    }

                    @Override
                    public void run() {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)this.msg, (String)DataImportArb.getString("RECORD_TERM_TITLE"), null);
                    }
                });
            }
        }
        if (!this.dataFormat.getUsePreviewLimit()) {
            return arrayList;
        }
        return this.m_previewRows;
    }

    private String readPreviewLine() throws IOException {
        StringBuilder stringBuilder;
        block12: {
            if (this.m_previewReader == null) {
                return null;
            }
            stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder(this.m_terminatorValue.length());
            char[] cArray = new char[1];
            int n = 0;
            int n2 = -1;
            while (stringBuilder2.length() < this.m_terminatorValue.length()) {
                if (this.m_previewReadAheadNumRead != -1) {
                    n2 = this.m_previewReadAheadNumRead;
                    cArray = this.m_previewReadAheadBuffer;
                    this.m_previewReadAheadNumRead = -1;
                } else {
                    n2 = this.readPreviewChars(cArray);
                }
                if (n2 == -1) {
                    return stringBuilder.length() == 0 ? null : stringBuilder.toString();
                }
                n += n2;
                stringBuilder.append(cArray);
                stringBuilder2.append(cArray);
                if (stringBuilder2.lastIndexOf(this.m_terminatorValue) == -1) continue;
                stringBuilder = new StringBuilder();
                stringBuilder2 = new StringBuilder(this.m_terminatorValue.length());
                n = 0;
            }
            do {
                if (this.m_previewReadAheadNumRead != -1) {
                    n2 = this.m_previewReadAheadNumRead;
                    cArray = this.m_previewReadAheadBuffer;
                    this.m_previewReadAheadNumRead = -1;
                } else {
                    n2 = this.readPreviewChars(cArray);
                }
                n += n2;
                if (n2 == -1) break block12;
                if (this.m_isCheckTerminator) {
                    if (cArray[0] == "\r".charAt(0)) {
                        this.m_previewReadAheadNumRead = this.readPreviewChars(this.m_previewReadAheadBuffer);
                        if (this.m_previewReadAheadNumRead != -1 && this.m_previewReadAheadBuffer[0] == "\n".charAt(0)) {
                            this.m_terminatorValue = "\r\n";
                            stringBuilder2 = new StringBuilder(2);
                            stringBuilder2.append(cArray);
                            stringBuilder2.append(this.m_previewReadAheadBuffer);
                            this.m_previewReadAheadNumRead = -1;
                            stringBuilder.append(cArray);
                            stringBuilder.append(this.m_previewReadAheadBuffer);
                            continue;
                        }
                        this.m_terminatorValue = "\r";
                        stringBuilder2 = new StringBuilder(1);
                        stringBuilder2.append(cArray);
                        stringBuilder.append(cArray);
                        continue;
                    }
                    if (cArray[0] == "\n".charAt(0)) {
                        this.m_terminatorValue = "\n";
                        stringBuilder2 = new StringBuilder(1);
                        stringBuilder2.append(cArray);
                        stringBuilder.append(cArray);
                        continue;
                    }
                    stringBuilder.append(cArray);
                    stringBuilder2.deleteCharAt(0);
                    stringBuilder2.append(cArray);
                    continue;
                }
                stringBuilder.append(cArray);
                stringBuilder2.deleteCharAt(0);
                stringBuilder2.append(cArray);
            } while (stringBuilder2.lastIndexOf(this.m_terminatorValue) == -1);
            this.m_isCheckTerminator = false;
            this.m_terminatorFound = true;
            return stringBuilder.substring(0, stringBuilder.length() - this.m_terminatorValue.length());
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private int readPreviewChars(char[] cArray) {
        try {
            int n = this.m_previewReader.read(cArray);
            if (n != -1) {
                return n;
            }
            if (!this.m_terminatorFound && !this.m_recTermList.contains(this.dataFormat.getRecordTerminator()) && this.m_currentPreviewBuffer == 49) {
                this.m_recTermList.add(this.dataFormat.getRecordTerminator());
                String string = this.dataFormat.getUseMaxLength() ? DataImportArb.format("MAX_SIZE_SET", Integer.valueOf(this.dataFormat.getMaxLength()).toString()) : DataImportArb.getString("MAX_SIZE_NOT_SET");
                String string2 = DataImportArb.format("PREVIEW_ERROR", this.dataFormat.getRecordTerminator(), 50, string, this.m_previewFileSize);
                if (!this.confirm(string2)) {
                    this.m_previewTruncate = true;
                    return n;
                }
            }
            if (!this.m_previewTruncate) {
                this.m_previewReader = this.getNextPreviewBuffer();
                if (this.m_previewReader != null) {
                    return this.m_previewReader.read(cArray);
                }
            }
            return n;
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return -1;
        }
    }

    private boolean confirm(String string) {
        return MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)DataImportArb.getString("TASK_SHORT_NAME"), null);
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return true;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }
}

