/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.icons.OracleIcons;

public class ImportSummary {
    public static DefaultTreeModel getSummaryTreeModel(ImportProperties importProperties, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(ImportSummary.getConnectionNode(importProperties));
        defaultMutableTreeNode.add(ImportSummary.getFileNode(importProperties));
        defaultMutableTreeNode.add(ImportSummary.getSelectedFields(importProperties));
        defaultMutableTreeNode.add(ImportSummary.getSelectableFields(importProperties));
        ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
        defaultMutableTreeNode.add(importDataFormat.getImportMethodSummaryNode(importProperties));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    public static DefaultMutableTreeNode getConnectionNode(ImportProperties importProperties) {
        String string = (String)importProperties.get(ImportKeys.CONNECTION_NAME);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DataImportArb.getString("CONN"));
        if (string != null) {
            JLabel jLabel = new JLabel();
            String string2 = Connections.getDisplayName(string);
            jLabel.setText(DataImportArb.getString("DEST_CONN") + ": " + string2);
            jLabel.setIcon(ExtractResources.getIcon("CONNECTION_ICON"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            JLabel jLabel2 = new JLabel();
            DBObject dBObject = (DBObject)importProperties.get(ImportKeys.DBOBJECT);
            jLabel2.setText(DataImportArb.getString("TABLE") + ": " + dBObject.getSchemaName() + "." + dBObject.getObjectName());
            jLabel2.setIcon(OracleIcons.getIcon((String)"table.png"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            GenericTable genericTable = (GenericTable)importProperties.get(ImportKeys.TABLE);
            for (Column column : genericTable.getColumns()) {
                JLabel jLabel3 = new JLabel();
                jLabel3.setText(DataImportArb.getString("COLUMN") + ": " + column.getName());
                jLabel3.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel3));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getFileNode(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DataImportArb.getString("FILE"));
        if (loadFile != null) {
            JLabel jLabel = new JLabel();
            jLabel.setText(DataImportArb.getString("SOURCE_FILE") + ": " + loadFile.getName());
            jLabel.setIcon(OracleIcons.getIcon((String)"filesave.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
            defaultMutableTreeNode.add(importDataFormat.getFileFormatSummaryNode());
            JLabel jLabel2 = new JLabel(DataImportArb.getString("FIELDS"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (LoadField loadField : loadFile.getFields()) {
                JLabel jLabel3 = new JLabel();
                jLabel3.setText(DataImportArb.getString("FIELD") + ": " + loadField.getName() + "  " + DataImportArb.getString("SIZE") + ": " + loadField.getLength());
                jLabel3.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel3));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getSelectedFields(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DataImportArb.getString("SEL_FIELDS"));
        if (loadFile != null) {
            Column[] columnArray;
            JLabel jLabel = new JLabel();
            jLabel.setText(DataImportArb.getString("SEL_FIELDS"));
            jLabel.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            for (Column column : columnArray = (Column[])importProperties.get(ImportKeys.SELECTED_COLUMNS)) {
                JLabel jLabel2 = new JLabel();
                jLabel2.setText(DataImportArb.getString("FIELD") + ": " + column.getSourceColumnName() + "  --> " + column.getName());
                jLabel2.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel2));
            }
        }
        return defaultMutableTreeNode;
    }

    public static DefaultMutableTreeNode getSelectableFields(ImportProperties importProperties) {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DataImportArb.getString("NOT_SEL_FIELDS"));
        if (loadFile != null) {
            Column[] columnArray;
            JLabel jLabel = new JLabel();
            jLabel.setText(DataImportArb.getString("NOT_SEL_FIELDS"));
            jLabel.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            for (Column column : columnArray = (Column[])importProperties.get(ImportKeys.SELECTABLE_COLUMNS)) {
                JLabel jLabel2 = new JLabel();
                jLabel2.setText(DataImportArb.getString("FIELD") + ": " + column.getSourceColumnName());
                jLabel2.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel2));
            }
        }
        return defaultMutableTreeNode;
    }

    public static void showConfig(PrintWriter printWriter, ImportProperties importProperties) {
        try {
            ImportSummary.writeConnection(printWriter, importProperties);
            ImportSummary.writeFile(printWriter, importProperties);
            ImportSummary.writeSelectedFields(printWriter, importProperties);
            ImportSummary.writeSelectableFields(printWriter, importProperties);
            ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
            importDataFormat.writeImportMethod(printWriter, importProperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
        printWriter.flush();
    }

    public static void writeConnection(PrintWriter printWriter, ImportProperties importProperties) throws IOException {
        String string = (String)importProperties.get(ImportKeys.CONNECTION_NAME);
        ImportSummary.out(printWriter, DataImportArb.getString("CONN"), 0);
        if (string != null) {
            String string2 = Connections.getDisplayName(string);
            ImportSummary.out(printWriter, DataImportArb.getString("DEST_CONN") + ": " + string2, 1);
            DBObject dBObject = (DBObject)importProperties.get(ImportKeys.DBOBJECT);
            ImportSummary.out(printWriter, DataImportArb.getString("TABLE") + ": " + dBObject.getSchemaName() + "." + dBObject.getObjectName(), 1);
            GenericTable genericTable = (GenericTable)importProperties.get(ImportKeys.TABLE);
            for (Column column : genericTable.getColumns()) {
                JLabel jLabel = new JLabel();
                ImportSummary.out(printWriter, DataImportArb.getString("COLUMN") + ": " + column.getName(), 2);
            }
        }
    }

    public static void writeFile(PrintWriter printWriter, ImportProperties importProperties) throws IOException {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        ImportSummary.out(printWriter, DataImportArb.getString("FILE"), 0);
        if (loadFile != null) {
            ImportSummary.out(printWriter, DataImportArb.getString("SOURCE_FILE") + ": " + loadFile.getName(), 1);
            ImportDataFormat importDataFormat = (ImportDataFormat)importProperties.get(ImportKeys.IMPORT_DATA_FORMAT);
            importDataFormat.writeFileFormat(printWriter, importProperties);
            ImportSummary.out(printWriter, DataImportArb.getString("FIELDS"), 1);
            for (LoadField loadField : loadFile.getFields()) {
                ImportSummary.out(printWriter, DataImportArb.getString("FIELD") + ": " + loadField.getName() + "  " + DataImportArb.getString("SIZE") + ": " + loadField.getLength(), 2);
            }
        }
    }

    public static void writeSelectedFields(PrintWriter printWriter, ImportProperties importProperties) throws IOException {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        ImportSummary.out(printWriter, DataImportArb.getString("SEL_FIELDS"), 0);
        if (loadFile != null) {
            Column[] columnArray;
            for (Column column : columnArray = (Column[])importProperties.get(ImportKeys.SELECTED_COLUMNS)) {
                ImportSummary.out(printWriter, DataImportArb.getString("FIELD") + ": " + column.getSourceColumnName() + "  --> " + column.getName(), 1);
            }
        }
    }

    public static void writeSelectableFields(PrintWriter printWriter, ImportProperties importProperties) throws IOException {
        LoadFile loadFile = (LoadFile)importProperties.get(ImportKeys.LOAD_FILE);
        ImportSummary.out(printWriter, DataImportArb.getString("NOT_SEL_FIELDS"), 0);
        if (loadFile != null) {
            Column[] columnArray;
            for (Column column : columnArray = (Column[])importProperties.get(ImportKeys.SELECTABLE_COLUMNS)) {
                ImportSummary.out(printWriter, DataImportArb.getString("FIELD") + ": " + column.getSourceColumnName(), 1);
            }
        }
    }

    public static void out(PrintWriter printWriter, String string, int n) throws IOException {
        if (n > 0) {
            printWriter.append(ImportSummary.getIndent(n));
        }
        printWriter.append(string + "\n");
    }

    private static String getIndent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "   ";
        }
        return string;
    }
}

