/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.Messages;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnPanel;
import oracle.dbtools.raptor.data.ui.ColumnShuttlePanel;
import oracle.dbtools.raptor.data.ui.DataPreviewPage;
import oracle.dbtools.raptor.data.ui.DataSummaryPage;
import oracle.dbtools.raptor.data.ui.ExternalOptions;
import oracle.dbtools.raptor.data.ui.ImportMethodPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.ui.wizard.BigWizardDialog;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;

public class DataWizard
extends AbstractMenuAction {
    private static DataWizard m_instance = null;
    public static final String DATA_WIZARD_NAME = "raptor.dataWizard";
    public static final int DATA_WIZARD_ACTION = Ide.findOrCreateCmdID((String)"raptor.dataWizard");
    public static final String HELP_DATA_PREVIEW = "f1_importdatadatapreview_html";
    public static final String HELP_LOAD_METHOD = "f1_importloadmethod_html";
    public static final String HELP_FILE = "f1_helpdatawizardfile_html";
    public static final String HELP_CHOOSE_COLUMNS = "f1_importdatachoosecolumns_html";
    public static final String HELP_DEFINE_COLUMNS = "f1_importdatadefinecolumns_html";
    public static final String HELP_SUMMARY = "f1_importdatasummary_html";
    private Namespace initialData;
    private WizardDialog wiz;
    private DBObject dbo;

    private FSM getFSM() {
        FSMBuilder fSMBuilder = new FSMBuilder();
        Step step = new Step(DataImportArb.getString("WIZARD_PREVIEW_DATA"), DataPreviewPage.class, HELP_DATA_PREVIEW);
        Step step2 = new Step(DataImportArb.getString("WIZARD_LOAD_METHOD"), ImportMethodPanel.class, HELP_LOAD_METHOD);
        Step step3 = new Step(DataImportArb.getString("WIZARD_CHOOSE_COLUMNS"), ColumnShuttlePanel.class, HELP_CHOOSE_COLUMNS);
        Step step4 = new Step(DataImportArb.getString("WIZARD_DEFINE_COLUMNS"), ColumnPanel.class, HELP_DEFINE_COLUMNS);
        Step step5 = new Step(Messages.getString("DataWizard.0"), ExternalOptions.class, "f1_importoptions_html");
        Step step6 = new Step(Messages.getString("DataWizard.1"), DataSummaryPage.class, HELP_SUMMARY);
        String string = step2.getTraversableClass().getSimpleName();
        String string2 = step3.getTraversableClass().getSimpleName();
        String string3 = step4.getTraversableClass().getSimpleName();
        String string4 = step5.getTraversableClass().getSimpleName();
        String string5 = step6.getTraversableClass().getSimpleName();
        fSMBuilder.newStartState(step, (Object)string2);
        fSMBuilder.setDefaultTrans((Object)string);
        fSMBuilder.addStateTrans((Object)true, (Object)string2);
        fSMBuilder.addStateTrans((Object)false, (Object)string);
        fSMBuilder.newState((Object)string, step2, (Object)string2);
        fSMBuilder.addStateTrans((Object)true, (Object)string3);
        fSMBuilder.addStateTrans((Object)false, (Object)string2);
        fSMBuilder.newState((Object)string2, step3, (Object)string3);
        fSMBuilder.newState((Object)string3, step4, (Object)string5);
        fSMBuilder.addStateTrans((Object)true, (Object)string5);
        fSMBuilder.addStateTrans((Object)false, (Object)string4);
        fSMBuilder.newState((Object)string4, step5, (Object)string5);
        fSMBuilder.addStateTrans((Object)false, (Object)string5);
        fSMBuilder.newFinalState((Object)string5, step6);
        try {
            return fSMBuilder.getFSM();
        }
        catch (FSMInvalidException fSMInvalidException) {
            return null;
        }
    }

    public static DataWizard getInstance() {
        if (m_instance == null) {
            m_instance = new DataWizard();
        }
        return m_instance;
    }

    public static void main(String[] stringArray) {
        DataWizard dataWizard = new DataWizard();
        dataWizard.launch();
    }

    public WizardDialog getWizard() {
        FSM fSM = this.getFSM();
        this.initialData = new Namespace();
        ImportProperties importProperties = new ImportProperties();
        this.initialData.put("IMPORT_PROPERTIES", (Object)importProperties);
        importProperties.put(ImportKeys.DBOBJECT, this.dbo);
        importProperties.put(ImportKeys.CONNECTION_NAME, this.dbo.getConnectionName());
        importProperties.put(ImportKeys.OBJECTACTION, (Object)this.getObjectAction());
        this.setBlockOACRefresh(true);
        FSMWizard fSMWizard = new FSMWizard(fSM, this.initialData);
        BigWizardDialog bigWizardDialog = new BigWizardDialog((BaseWizard)fSMWizard, (Frame)Ide.getMainWindow());
        fSMWizard.setDialog((WizardDialog)bigWizardDialog);
        bigWizardDialog.setPreferredSize(new Dimension(900, 600));
        fSMWizard.setWizardTitle(DataImportArb.getString("WIZARD_DATA_IMPORT_TITLE"));
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(DataImportArb.getImage("WIZARD_IMAGE"));
        fSMWizard.setRoadmapVisible(true);
        return fSMWizard.getDialog((Frame)Ide.getMainWindow());
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DATA_WIZARD_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    @Override
    public void setArgs(String string) {
    }

    @Override
    public void launch() {
        ColumnMapMediator.getInstance().clearMap();
        this.dbo = this.getDBObject();
        this.wiz = this.getWizard();
        WizardLauncher.runDialog((JDialog)this.wiz);
    }

    public static class DataController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                DataWizard.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DATA_WIZARD_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

