/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.UUID;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.metadata.AbstractObjectAction;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;

public class ObjectAction
extends AbstractObjectAction<ObjectActionPrompt> {
    public static final String ACTION_KEY = "ObjectAction.KEY";
    public static final String ACTION_TARGET_KEY = "ObjectAction.TARGET.KEY";
    public static final String ACTION_CONN_NAME = "ObjectAction.CONN_NAME";
    public static final String ACTION_EVENT = "ObjectAction.EVENT";
    public static final String ACTION_DBOBJECT = "ObjectAction.DBOBJECT";
    public static final String ACTION_CLASS = "ObjectAction.CLASS";
    public static final String ACTION_CONN_TYPE = "ObjectAction.ConnType";
    public static final String ACTION_WEIGHT = "ObjectAction.ConnType";
    public static final String ACTION_UNDECORATED_NAME = "ObjectAction.UndecoratedName";
    public static final String RENAME_ACTION_NAME = "Rename...";
    private Icon _icon;
    private IdeAction _action;
    private JMenuItem _menuItem;
    private MetaClass<Controller> _controllerClass;
    protected MetaClass<AbstractMenuAction> m_metaClass = null;
    public static final float SECTION_OBJECT_ACTIONS_CTXT_MENU = MenuConstants.decrement((float)MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);

    public ObjectAction() {
        this.setWeight(1.0f);
        this.setSection(SECTION_OBJECT_ACTIONS_CTXT_MENU);
    }

    private void initAction() {
        if (this._action == null) {
            String string;
            Object object;
            if (this.getCommandName() == null || this.getCommandName().equals("")) {
                object = UUID.randomUUID().toString();
                string = MessageFormat.format("raptor.objectaction.{0}.{1}.{2}.{3}", this.getConnType() != null ? this.getConnType() : "Oracle", this.getType(), this.getTitle(), object);
                this.setId(Ide.findOrCreateCmdID((String)string));
            } else {
                this.setId(Ide.findOrCreateCmdID((String)this.getCommandName()));
            }
            object = StringUtils.getMnemonicKeyCode((String)("raptor.objectaction." + this.getType() + "." + this.getTitle()));
            this._action = IdeAction.findOrCreate((int)this.getId(), null, (String)this.getTitle(), null, (Integer)object, (Icon)this.getIcon(), null, (boolean)true);
            if (this.getCommandName() != null && !this.getCommandName().equals("") && this.getIconRef() != null) {
                this._action.putValue("SmallIcon", (Object)this.getIcon());
            }
            this._action.putValue(ACTION_KEY, (Object)this);
            this._action.putValue("menu-section-id", (Object)Float.valueOf(this.getSection()));
            this._action.setMenuWeight(this.getWeight());
            this._action.addController(ObjectActionController.getInstance());
            if (this._controllerClass != null) {
                try {
                    string = (Controller)this._controllerClass.newInstance();
                    if (string != null) {
                        this._action.addController((Controller)string);
                    }
                }
                catch (Exception exception) {
                    Logger.severe(((Object)((Object)this)).getClass(), (String)"initAction", (Throwable)exception);
                }
            }
        }
    }

    public Object getProperty(String string) {
        if (this._action == null) {
            this.initAction();
        }
        return this._action.getValue(string);
    }

    public void putProperty(String string, Object object) {
        if (this._action == null) {
            this.initAction();
        }
        this._action.putValue(string, object);
    }

    public JMenuItem getMenuItem(ContextMenu contextMenu) {
        if (this._action == null) {
            this.initAction();
        }
        JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._action);
        jMenuItem.putClientProperty(ACTION_KEY, (Object)this);
        jMenuItem.putClientProperty("menu-weight", Float.valueOf(this.getWeight()));
        jMenuItem.putClientProperty("menu-section-id", Float.valueOf(this.getSection()));
        jMenuItem.setIcon(this.getIcon());
        return jMenuItem;
    }

    public JMenuItem getMenuItem() {
        if (this._action == null) {
            this.initAction();
        }
        if (this._menuItem == null) {
            this._menuItem = new JMenuItem((Action)this._action);
            this._menuItem.putClientProperty(ACTION_KEY, (Object)this);
            this._menuItem.putClientProperty("menu-section-id", Float.valueOf(this.getSection()));
        }
        this._menuItem.setIcon(this.getIcon());
        return this._menuItem;
    }

    public boolean isValidForVersion(DBObject dBObject) {
        return this.isValidForVersion(dBObject, null);
    }

    public boolean isValidForVersion(DBObject dBObject, IdeAction ideAction) {
        if (this.getMinVersion() == null && this.getMaxVersion() == null && this.getReqFeatures() == null) {
            this.decorateActionWithValidation(ideAction, null);
            return true;
        }
        if (!Connections.getInstance().isConnectionOpen(dBObject.getConnectionName())) {
            String string = "!" + DatabaseNavigatorResources.get("CONNECTION_FILTER_CONNECTED_MSG");
            this.decorateActionWithValidation(ideAction, string);
            return false;
        }
        Connection connection = dBObject.getConnection(false);
        ConnectionIdentifier connectionIdentifier = DefaultConnectionIdentifier.createIdentifier((Connection)connection);
        if (!QueryUtils.hasRequiredFeatures((ConnectionIdentifier)connectionIdentifier, (String[])this.getReqFeatures())) {
            this.decorateActionWithValidation(ideAction, Arrays.toString(this.getReqFeatures()));
            return false;
        }
        if (!VersionTracker.checkVersion((ConnectionIdentifier)connectionIdentifier, (Version)this.getMaxVersion(), (Version)this.getMinVersion())) {
            String string = (this.getMinVersion() != null ? this.getMinVersion().toString() : "-") + (this.getMaxVersion() != null ? (this.getMinVersion() != null ? " - " : "") + this.getMaxVersion().toString() : "+");
            this.decorateActionWithValidation(ideAction, string);
            return false;
        }
        this.decorateActionWithValidation(ideAction, null);
        return true;
    }

    private void decorateActionWithValidation(IdeAction ideAction, String string) {
        if (ideAction != null) {
            String string2 = (String)ideAction.getValue(ACTION_UNDECORATED_NAME);
            if (null == string2) {
                string2 = (String)ideAction.getValue("Name");
                ideAction.putValueDirectly(ACTION_UNDECORATED_NAME, (Object)string2);
            }
            if (null == string || string.isEmpty()) {
                ideAction.putValueDirectly("Name", (Object)string2);
            } else {
                if (string.startsWith("[")) {
                    string = string.substring(1, string.length() - 1);
                }
                String string3 = String.format("%s [ %s ]", string2, string);
                ideAction.putValueDirectly("Name", (Object)string3);
            }
        }
    }

    public IdeAction getAction() {
        this.initAction();
        return this._action;
    }

    public AbstractMenuAction getActionInstance() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (AbstractMenuAction)this.getMetaClass().newInstance();
    }

    public String getControllerClassName() {
        return this._controllerClass.getClassName();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toXML(stringBuffer);
        return stringBuffer.toString();
    }

    public void toXML(StringBuffer stringBuffer) {
        stringBuffer.append("<item ");
        stringBuffer.append(" reload=\"" + this.getReload() + "\" ");
        stringBuffer.append(" reloadparent=\"" + this.getReloadParent() + "\"");
        stringBuffer.append(" removeFromParent=\"" + this.isRemoveFromParent() + "\"");
        if (this.isSqlDevOnly()) {
            stringBuffer.append(" sqldevonly=\"" + this.isSqlDevOnly() + "\"");
        }
        if (this.getType() != null) {
            stringBuffer.append(" type=\"" + this.getType() + "\"");
        }
        if (this.getMetaClass() != null) {
            stringBuffer.append(" className=\"" + this.getMetaClass().getClassName() + "\"");
        }
        if (this.getClassArgs() != null) {
            stringBuffer.append(" classArgs=\"" + this.getClassArgs() + "\"");
        }
        if (this._controllerClass != null) {
            stringBuffer.append(" controllerClassName=\"" + this._controllerClass + "\"");
        }
        if (this.getMaxVersion() != null) {
            stringBuffer.append(" maxversion=\"" + this.getMaxVersion() + "\"");
        }
        if (this.getMinVersion() != null) {
            stringBuffer.append(" minversion=\"" + this.getMinVersion() + "\"");
        }
        stringBuffer.append(" toolbar=\"" + this.isToolbar() + "\" ");
        stringBuffer.append(">");
        stringBuffer.append("<title>" + this.getTitle() + "</title>");
        if (this.getPrompts() != null) {
            for (ObjectActionPrompt objectActionPrompt : this.getPrompts()) {
                objectActionPrompt.toXML(stringBuffer);
            }
        }
        if (this.getSql() != null) {
            stringBuffer.append("<sql><![CDATA[" + this.getSql() + "]]></sql>");
        }
        if (this.getScript() != null) {
            stringBuffer.append("<script language=\"" + this.getScriptLanguage() + "\"><![CDATA[" + this.getScript() + "]]></script>");
        }
        if (this.getHelp() != null) {
            stringBuffer.append("<help>" + this.getHelp() + "</help>");
        }
        if (this.getConfirmTitle() != null) {
            stringBuffer.append("<confirmation>");
            stringBuffer.append("  <title>" + this.getConfirmTitle() + "</title>");
            stringBuffer.append("  <prompt><![CDATA[" + this.getConfirm() + "]]></prompt>");
            stringBuffer.append("  <sql><![CDATA[" + this.getSql() + "]]></sql>");
            stringBuffer.append("</confirmation>");
        }
        stringBuffer.append("</item>");
    }

    public void setControllerClass(MetaClass<Controller> metaClass) {
        this._controllerClass = metaClass;
    }

    private Icon getIcon() {
        if (this.getIconRef() != null && this._icon == null) {
            this._icon = RaptorImage.getIcon((String)this.getIconRef().getResourcePath(), (ClassLoader)this.getIconRef().getClassLoader());
        }
        return this._icon;
    }

    public void setClassName(String string, ClassLoader classLoader) {
        this.m_metaClass = ModelUtil.hasLength((String)string) ? new MetaClass(classLoader, string) : null;
    }

    public void setMetaClass(MetaClass<AbstractMenuAction> metaClass) {
        this.m_metaClass = metaClass;
    }

    public MetaClass<AbstractMenuAction> getMetaClass() {
        return this.m_metaClass;
    }
}

