/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.html;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.IErrorHandler;
import oracle.dbtools.raptor.controls.display.html.HtmlGenerationContext;
import oracle.dbtools.raptor.controls.display.html.IHtmlGenerator;
import oracle.dbtools.raptor.controls.display.html.ResourceGenerationContext;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.NameComparator;
import oracle.dbtools.raptor.navigator.plsql.PlsqlStructureParser;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.utils.Connections;

public class DocHtmlGenerator
implements IHtmlGenerator {
    private final String tabPad = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

    @Override
    public void generateStaticResources(ResourceGenerationContext resourceGenerationContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateHtml(HtmlGenerationContext htmlGenerationContext) {
        block12: {
            Object object;
            Writer writer = htmlGenerationContext.writer();
            DisplayModel displayModel = htmlGenerationContext.model();
            Connection connection = htmlGenerationContext.connection();
            Map<String, Object> map = htmlGenerationContext.binds();
            String string = null;
            Query query = displayModel.getQuery();
            if (query != null && (object = query.getSql()) != null) {
                string = QueryUtils.expandQuery((String)object, map);
            }
            if (string != null) {
                object = null;
                Connections.getInstance().lock(connection);
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    try {
                        object = dBUtil.executeQuery(string, map);
                        SQLException sQLException = dBUtil.getLastException();
                        if (sQLException != null) {
                            htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.SQL, sQLException);
                            break block12;
                        }
                        if (object == null) break block12;
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            while (object.next()) {
                                stringBuilder.append(object.getString(1));
                            }
                            this.generateDoc(stringBuilder, writer);
                        }
                        finally {
                            DBUtil.closeResultSet((ResultSet)object);
                        }
                    }
                    catch (Exception exception) {
                        htmlGenerationContext.errorHandler().handleError(IErrorHandler.Category.SQL, exception);
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    private void generateDoc(StringBuilder stringBuilder, Writer writer) throws IOException {
        LexerToken lexerToken2;
        String string = stringBuilder.toString();
        List list = LexerToken.parse((String)string, (boolean)true);
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        for (LexerToken lexerToken2 : list) {
            if (lexerToken2.type == Token.WS || lexerToken2.type == Token.COMMENT || lexerToken2.type == Token.LINE_COMMENT) continue;
            linkedList.add(lexerToken2);
        }
        PlsqlStructureParser plsqlStructureParser = new PlsqlStructureParser();
        plsqlStructureParser.parse(linkedList, new NameComparator());
        this.links(writer);
        writer.write("<HR><P>");
        lexerToken2 = this.projectHeader(writer, list);
        if (lexerToken2 != null) {
            Iterator<Member> iterator = lexerToken2.content.substring(2);
            if (lexerToken2.type == Token.COMMENT) {
                iterator = ((String)((Object)iterator)).substring(0, ((String)((Object)iterator)).length() - 2);
            }
            writer.write(((String)((Object)iterator)).replace("\n", "<BR>").replace('*', ' '));
        }
        writer.write("</P><HR>");
        if (this.hasTypes(plsqlStructureParser)) {
            this.summaryHeader(writer, "Type Summary");
            for (Member member : plsqlStructureParser.children) {
                this.generateTypeSummary(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
            writer.write("</TABLE>");
        }
        if (this.hasMethods(plsqlStructureParser)) {
            this.summaryHeader(writer, "Method Summary");
            for (Member member : plsqlStructureParser.children) {
                this.generateMethodSummary(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
            writer.write("</TABLE>\n");
        }
        if (this.hasTypes(plsqlStructureParser)) {
            this.detailHeader(writer, "Type Detail");
            for (Member member : plsqlStructureParser.children) {
                this.generateTypeDetail(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
        }
        if (this.hasMethods(plsqlStructureParser)) {
            this.detailHeader(writer, "Method Detail");
            for (Member member : plsqlStructureParser.children) {
                this.generateMethodDetail(writer, member, this.priorComment(list, member, plsqlStructureParser.children, lexerToken2));
            }
        }
        this.links(writer);
    }

    private void detailHeader(Writer writer, String string) throws IOException {
        this.summaryHeader(writer, string);
        writer.write("</TABLE>");
    }

    private void links(Writer writer) throws IOException {
        writer.write("<TABLE CELLSPACING=\"0\" CELLPADDING=\"1\" WIDTH=\"100%\" BORDER=\"0\">\n<TR><TD CLASS=\"NavBarRow3\" VALIGN=\"top\"><FONT SIZE=\"-2\">      SUMMARY:  <A HREF=\"#field_summary\">FIELD</A> | <A HREF=\"#type_summary\">TYPE</A> | <A HREF=\"#method_summary\">METHOD</A></FONT></TD><TD CLASS=\"NavBarRow3\" VALIGN=\"top\"><FONT SIZE=\"-2\"></TR></TABLE>");
    }

    private void summaryHeader(Writer writer, String string) throws IOException {
        writer.write("<P></P><A NAME=\"" + string.toLowerCase().replace(' ', '_') + "\"></A><TABLE WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"3\" BORDER=\"1\"><TR CLASS=\"TableHeadingColor\"><TD COLSPAN=\"2\"><FONT SIZE=\"+2\"><B>" + string + "</B></FONT></TD>");
    }

    private boolean hasTypes(PlsqlStructureParser plsqlStructureParser) {
        for (Member member : plsqlStructureParser.children) {
            if (!"TYPE".equals(member.type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMethods(PlsqlStructureParser plsqlStructureParser) {
        for (Member member : plsqlStructureParser.children) {
            if (!"PROCEDURE".equals(member.type) && !"FUNCTION".equals(member.type)) continue;
            return true;
        }
        return false;
    }

    private LexerToken projectHeader(Writer writer, List<LexerToken> list) throws IOException {
        LexerToken lexerToken = null;
        LexerToken lexerToken2 = null;
        for (LexerToken lexerToken3 : list) {
            if (lexerToken3.type == Token.COMMENT || lexerToken3.type == Token.LINE_COMMENT) {
                lexerToken2 = lexerToken3;
            } else if (lexerToken3.type == Token.WS) continue;
            if (lexerToken != null) {
                if ("procedure".equalsIgnoreCase(lexerToken.content) || "function".equalsIgnoreCase(lexerToken.content) || "trigger".equalsIgnoreCase(lexerToken.content)) {
                    return null;
                }
                if ("as".equalsIgnoreCase(lexerToken.content) || "is".equalsIgnoreCase(lexerToken.content)) break;
            }
            lexerToken = lexerToken3;
        }
        return lexerToken2;
    }

    private LexerToken priorComment(List<LexerToken> list, Member member, Set<Member> set, LexerToken lexerToken) {
        LexerToken lexerToken2 = null;
        for (LexerToken lexerToken3 : list) {
            if (lexerToken3.type == Token.COMMENT || lexerToken3.type == Token.LINE_COMMENT) {
                lexerToken2 = lexerToken3;
                continue;
            }
            if (member.codeOffset == lexerToken3.begin) {
                for (Member member2 : set) {
                    if (member2 == member || member2.codeOffset >= member.codeOffset || lexerToken2 == null || lexerToken2.begin >= member2.codeOffset) continue;
                    return null;
                }
                if (lexerToken2 == null) continue;
                if (lexerToken2 == lexerToken) {
                    return null;
                }
                return lexerToken2;
            }
            if (member.codeOffset >= lexerToken3.begin || !";".equals(lexerToken3.content) && !"is".equalsIgnoreCase(lexerToken3.content) && !"as".equalsIgnoreCase(lexerToken3.content)) continue;
            return lexerToken2;
        }
        return null;
    }

    private void generateMethodSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"FUNCTION".equals(member.type) && !"PROCEDURE".equals(member.type)) {
            return;
        }
        this.generateSummary(writer, member, lexerToken);
    }

    private void generateTypeSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"TYPE".equals(member.type)) {
            return;
        }
        this.generateSummary(writer, member, lexerToken);
    }

    private void generateSummary(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        String string = this.extractComment(lexerToken);
        String string2 = this.extractParams(member);
        writer.write("<TR CLASS=\"TableRowColor\"><TD WIDTH=\"1%\" VALIGN=\"top\" ALIGN=\"right\"><FONT SIZE=\"-1\"><CODE>&nbsp;</CODE></FONT></TD><TD><CODE><B><A HREF=\"#" + member.name + "\">" + member.name + "</A></B>" + string2 + "</CODE><BR>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string + "</TD></TR>\n");
    }

    private void generateTypeDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"TYPE".equals(member.type)) {
            return;
        }
        this.generateDetail(writer, member, lexerToken);
    }

    private void generateMethodDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        if (!"FUNCTION".equals(member.type) && !"PROCEDURE".equals(member.type)) {
            return;
        }
        this.generateDetail(writer, member, lexerToken);
    }

    private void generateDetail(Writer writer, Member member, LexerToken lexerToken) throws IOException {
        String string = this.extractComment(lexerToken);
        String string2 = this.extractParams(member);
        List<String> list = this.extractParams(lexerToken);
        List<String> list2 = this.extractExc(lexerToken);
        List<String> list3 = this.extractRet(lexerToken);
        writer.write("<A NAME=\"" + member.name + "\"></A>\n<H3>" + member.name + "</H3><PRE>          <B>" + member.name + "</B>" + string2 + "</PRE><DL>" + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + string + "<DD><DL>");
        if (0 < list.size()) {
            writer.write("<DT><B>Parameters:</B>");
            for (String string3 : list) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        if (0 < list3.size()) {
            writer.write("<DT><B>Returns:</B>");
            for (String string3 : list3) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        if (0 < list2.size()) {
            writer.write("<DT><B>Throws:</B>");
            for (String string3 : list2) {
                writer.write(string3);
            }
            writer.write("</DT>");
        }
        writer.write("</DL></DD></DL><HR>");
    }

    private List<String> extractParams(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@param", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@param", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@throws", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@return", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@param".length(), n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                int n4 = ((LexerToken)list.get((int)0)).end + 1;
                if (n4 < string.length()) {
                    linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - " + string.substring(n4) + "</DD>");
                } else {
                    linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - </DD>");
                }
                n = n3;
            }
        }
        return linkedList;
    }

    private List<String> extractRet(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@return", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@return", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@throws", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@return".length() + 1, n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD>" + string + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private List<String> extractExc(LexerToken lexerToken) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (lexerToken != null) {
            int n = 0;
            while ((n = lexerToken.content.indexOf("@throws", n)) >= 0) {
                String string;
                int n2;
                int n3 = lexerToken.content.indexOf("@throws", n + 1);
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf("@return", n);
                }
                if (n3 < 0) {
                    n3 = lexerToken.content.indexOf(10, n);
                }
                if ((n2 = (string = lexerToken.content.substring(n + "@throws".length(), n3)).lastIndexOf(10)) > 0) {
                    string = string.substring(0, n2);
                }
                List list = LexerToken.parse((String)string);
                linkedList.add("<DD><CODE>" + ((LexerToken)list.get((int)0)).content + "</CODE> - " + string.substring(((LexerToken)list.get((int)0)).end + 1) + "</DD>");
                n = n3;
            }
        }
        return linkedList;
    }

    private String extractComment(LexerToken lexerToken) {
        String string = "";
        if (lexerToken != null) {
            int n = lexerToken.content.indexOf("@param");
            if (n < 0) {
                n = lexerToken.content.indexOf("@return");
            }
            if (n < 0 && lexerToken.type == Token.LINE_COMMENT) {
                n = lexerToken.content.length();
            }
            if (n < 0 && lexerToken.type == Token.COMMENT) {
                n = lexerToken.content.length() - 2;
            }
            string = lexerToken.content.substring(2, n);
            string = string.replace('*', ' ');
        }
        return string.replace("\n", "<BR>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private String extractParams(Member member) {
        String string = "";
        int n = member.getPayload().indexOf("(");
        if (0 < n) {
            string = member.getPayload().substring(n);
        }
        return string;
    }
}

