/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Alignment;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanListArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;
import oracle.dbtools.raptor.controls.display.chart.ChartFontArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.ColorListArchiver;
import oracle.dbtools.raptor.controls.display.chart.DoubleArchiver;
import oracle.dbtools.raptor.controls.display.chart.DoubleListArchiver;
import oracle.dbtools.raptor.controls.display.chart.EnumArchiver;
import oracle.dbtools.raptor.controls.display.chart.EnumListArchiver;
import oracle.dbtools.raptor.controls.display.chart.IntegerArchiver;
import oracle.dbtools.raptor.controls.display.chart.LineWidth;
import oracle.dbtools.raptor.controls.display.chart.LogarithmicBase;
import oracle.dbtools.raptor.controls.display.chart.NumberFormats;
import oracle.dbtools.raptor.controls.display.chart.NumberFormatsArchiver;
import oracle.dbtools.raptor.controls.display.chart.Property;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.Rotation;
import oracle.dbtools.raptor.controls.display.chart.StringArchiver;
import oracle.dbtools.raptor.controls.display.chart.StringListArchiver;
import oracle.dbtools.raptor.controls.display.chart.TransparentColor;
import oracle.dbtools.raptor.controls.display.chart.TransparentColorArchiver;
import oracle.dss.graph.Graph;
import oracle.dss.graph.ReferenceObject;

class Y2AxisProperties
extends PropertyGroup {
    Y2AxisProperties() {
    }

    @Override
    void register(Map<PropertyType, PropertyDef> map) {
        BitSet bitSet = ChartType.all();
        map.put(PropertyType.Y2AXIS_TITLE, new PropertyDef<Boolean>(bitSet){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY2Title().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY2Title().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_TITLE_TEXT, new PropertyDef<String>(bitSet){
            private StringArchiver archiver;
            {
                this.archiver = new StringArchiver();
            }

            @Override
            String getGraphValue(Graph graph) {
                return graph.getY2Title().getText();
            }

            @Override
            void setGraphValue(Graph graph, String string) {
                graph.getY2Title().setText(string);
            }

            @Override
            Archiver<String> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_TITLE_ALIGNMENT, new PropertyDef<Alignment>(bitSet){
            private EnumArchiver<Alignment> archiver;
            {
                this.archiver = new EnumArchiver(Alignment.class, (Enum[])Alignment.values());
            }

            @Override
            Alignment getGraphValue(Graph graph) {
                return Alignment.get(graph.getY2Title().getHorizontalAlignment());
            }

            @Override
            void setGraphValue(Graph graph, Alignment alignment) {
                graph.getY2Title().setHorizontalAlignment(alignment.swingConstant());
            }

            @Override
            Archiver<Alignment> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_TITLE_FONT, new PropertyDef<ChartFont>(bitSet){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getY2Title().getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, graph.getY2Title().getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet2 = ChartType.all();
        bitSet2.andNot(ChartType.pies());
        bitSet2.andNot(ChartType.threeDs());
        map.put(PropertyType.Y2AXIS_LINE_COLOR, new PropertyDef<TransparentColor>(bitSet2){
            private TransparentColorArchiver archiver;
            {
                this.archiver = new TransparentColorArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FOREGROUND_COLOR;
            }

            @Override
            TransparentColor getGraphValue(Graph graph) {
                return new TransparentColor(false, graph.getY2Axis().getLineColor());
            }

            @Override
            void setGraphValue(Graph graph, TransparentColor transparentColor) {
                graph.getY2Axis().setLineColor(transparentColor.color());
            }

            @Override
            Archiver<TransparentColor> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_LINE_WIDTH, new PropertyDef<LineWidth>(bitSet2){
            private EnumArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumArchiver(LineWidth.class, (Enum[])LineWidth.values());
            }

            @Override
            LineWidth getGraphValue(Graph graph) {
                return LineWidth.get(graph.getY2Axis().getLineWidth());
            }

            @Override
            void setGraphValue(Graph graph, LineWidth lineWidth) {
                graph.getY2Axis().setLineWidth(lineWidth.pixels());
            }

            @Override
            Archiver<LineWidth> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet3 = ChartType.all();
        map.put(PropertyType.Y2AXIS_TICK_LABEL_ROTATE, new PropertyDef<Rotation>(bitSet3){
            private EnumArchiver<Rotation> archiver;
            {
                this.archiver = new EnumArchiver(Rotation.class, (Enum[])Rotation.values());
            }

            @Override
            Rotation getGraphValue(Graph graph) {
                return Rotation.get(graph.getY2TickLabel().getTextRotation());
            }

            @Override
            void setGraphValue(Graph graph, Rotation rotation) {
                graph.getY2TickLabel().setTextRotation(rotation.graphConstant());
            }

            @Override
            Archiver<Rotation> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_TICK_LABEL_FONT, new PropertyDef<ChartFont>(bitSet3){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getY2TickLabel().getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, graph.getY2TickLabel().getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet4 = ChartType.vBars();
        bitSet4.or(ChartType.hBars());
        bitSet4.or(ChartType.lines());
        bitSet4.or(ChartType.areas());
        map.put(PropertyType.Y2AXIS_BASE_LINE_VALUE, new PropertyDef<Double>(bitSet4){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getY2BaseLine().getValue();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getY2BaseLine().setValue(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet5 = ChartType.all();
        map.put(PropertyType.Y2AXIS_SCALE_INCREMENT_AUTOMATIC, new PropertyDef<Boolean>(bitSet5){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY2Axis().isMajorTickStepAutomatic();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY2Axis().setMajorTickStepAutomatic(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_SCALE_INCREMENT, new PropertyDef<Double>(bitSet5){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getY2Axis().getMajorTickStep();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getY2Axis().setMajorTickStep(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet6 = ChartType.all();
        bitSet6.andNot(ChartType.pies());
        bitSet6.andNot(ChartType.paretos());
        map.put(PropertyType.Y2AXIS_SCALE_MINIMUM_AUTOMATIC, new PropertyDef<Boolean>(bitSet6){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY2Axis().isAxisMinAutoScaled();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY2Axis().setAxisMinAutoScaled(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_SCALE_MINIMUM, new PropertyDef<Double>(bitSet6){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getY2Axis().getAxisMinValue();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getY2Axis().setAxisMinValue(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_SCALE_MAXIMUM_AUTOMATIC, new PropertyDef<Boolean>(bitSet6){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY2Axis().isAxisMaxAutoScaled();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY2Axis().setAxisMaxAutoScaled(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_SCALE_MAXIMUM, new PropertyDef<Double>(bitSet6){
            private DoubleArchiver archiver;
            {
                this.archiver = new DoubleArchiver();
            }

            @Override
            Double getGraphValue(Graph graph) {
                return graph.getY2Axis().getAxisMaxValue();
            }

            @Override
            void setGraphValue(Graph graph, Double d) {
                graph.getY2Axis().setAxisMaxValue(d.doubleValue());
            }

            @Override
            Archiver<Double> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet7 = ChartType.all();
        bitSet7.andNot(ChartType.pies());
        bitSet7.andNot(ChartType.paretos());
        map.put(PropertyType.Y2AXIS_LOGARITHMIC_SCALE, new PropertyDef<Boolean>(bitSet7){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getY2Axis().isScaledLogarithmic();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getY2Axis().setScaledLogarithmic(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_LOGARITHMIC_BASE, new PropertyDef<LogarithmicBase>(bitSet7){
            private EnumArchiver<LogarithmicBase> archiver;
            {
                this.archiver = new EnumArchiver(LogarithmicBase.class, (Enum[])LogarithmicBase.values());
            }

            @Override
            LogarithmicBase getGraphValue(Graph graph) {
                return LogarithmicBase.get(graph.getY2Axis().getLogarithmicBase());
            }

            @Override
            void setGraphValue(Graph graph, LogarithmicBase logarithmicBase) {
                graph.getY2Axis().setLogarithmicBase(logarithmicBase.base());
            }

            @Override
            Archiver<LogarithmicBase> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet8 = ChartType.all();
        map.put(PropertyType.Y2AXIS_NUMBER_FORMATS, new PropertyDef<NumberFormats>(bitSet8){
            private NumberFormatsArchiver archiver;
            {
                this.archiver = new NumberFormatsArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.NUMBER_FORMATS;
            }

            @Override
            NumberFormats getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(graph.getY2Axis().getViewFormat());
            }

            @Override
            void setGraphValue(Graph graph, NumberFormats numberFormats) {
                this.archiver.applyValue(numberFormats, graph.getY2Axis().getViewFormat());
            }

            @Override
            Archiver<NumberFormats> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet9 = ChartType.all();
        bitSet9.andNot(ChartType.pies());
        bitSet9.andNot(ChartType.stocks());
        bitSet9.andNot(ChartType.threeDs());
        map.put(PropertyType.Y2AXIS_REFOBJ_COUNT, new PropertyDef<Integer>(bitSet9){
            private IntegerArchiver archiver;
            {
                this.archiver = new IntegerArchiver();
            }

            @Override
            Integer getGraphValue(Graph graph) {
                return graph.getReferenceObjects(51).size();
            }

            @Override
            void setGraphValue(Graph graph, Integer n) {
                graph.destroyReferenceObjects(51);
                for (int i = 0; i < n; ++i) {
                    ReferenceObject referenceObject = graph.createReferenceObject();
                    referenceObject.setAssociation(51);
                }
            }

            @Override
            Archiver<Integer> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_REFOBJ_VISIBLE, new PropertyDef<List<Boolean>>(bitSet9){
            private BooleanListArchiver archiver;
            {
                this.archiver = new BooleanListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Boolean> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.Y2AXIS_REFOBJ_VISIBLE);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<Boolean> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(false);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.Y2AXIS_REFOBJ_COUNT};
            }

            @Override
            List<Boolean> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(51);
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((ReferenceObject)list.get(i)).isDisplayedInLegend());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Boolean> list) {
                List list2 = graph.getReferenceObjects(51);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setDisplayedInLegend(list.get(i).booleanValue());
                }
            }

            @Override
            Archiver<List<Boolean>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_REFOBJ_TEXT, new PropertyDef<List<String>>(bitSet9){
            private StringListArchiver archiver;
            {
                this.archiver = new StringListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<String> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.Y2AXIS_REFOBJ_TEXT);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<String> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<String> arrayList = new ArrayList<String>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add("");
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.Y2AXIS_REFOBJ_COUNT};
            }

            @Override
            List<String> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(51);
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((ReferenceObject)list.get(i)).getText());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<String> list) {
                List list2 = graph.getReferenceObjects(51);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setText(list.get(i));
                }
            }

            @Override
            Archiver<List<String>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_REFOBJ_LINE_VALUE, new PropertyDef<List<Double>>(bitSet9){
            private DoubleListArchiver archiver;
            {
                this.archiver = new DoubleListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Double> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.Y2AXIS_REFOBJ_LINE_VALUE);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<Double> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<Double> arrayList = new ArrayList<Double>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(0.0);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.Y2AXIS_REFOBJ_COUNT};
            }

            @Override
            List<Double> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(51);
                ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((Number)((ReferenceObject)list.get(i)).getLineValue()).doubleValue());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Double> list) {
                List list2 = graph.getReferenceObjects(51);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setLineValue((Object)list.get(i));
                }
            }

            @Override
            Archiver<List<Double>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_REFOBJ_COLOR, new PropertyDef<List<Color>>(bitSet9){
            private ColorListArchiver archiver;
            {
                this.archiver = new ColorListArchiver(){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<Color> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.Y2AXIS_REFOBJ_COLOR);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<Color> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<Color> arrayList = new ArrayList<Color>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(Color.BLACK);
                        }
                        return arrayList;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.Y2AXIS_REFOBJ_COUNT};
            }

            @Override
            List<Color> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(51);
                ArrayList<Color> arrayList = new ArrayList<Color>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(((ReferenceObject)list.get(i)).getColor());
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<Color> list) {
                List list2 = graph.getReferenceObjects(51);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setColor(list.get(i));
                }
            }

            @Override
            Archiver<List<Color>> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.Y2AXIS_REFOBJ_WIDTH, new PropertyDef<List<LineWidth>>(bitSet9){
            private EnumListArchiver<LineWidth> archiver;
            {
                this.archiver = new EnumListArchiver<LineWidth>(LineWidth.class){

                    @Override
                    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, List<LineWidth> list) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        if (list.size() != n) {
                            if (n == 0) {
                                Property<?> property = chartPropertyManagerImpl.property(PropertyType.Y2AXIS_REFOBJ_WIDTH);
                                property.set(new ArrayList());
                            } else {
                                throw new IllegalArgumentException();
                            }
                        }
                    }

                    @Override
                    List<LineWidth> createDefaultList(ChartPropertyManagerImpl chartPropertyManagerImpl) {
                        int n = chartPropertyManagerImpl.get(PropertyType.Y2AXIS_REFOBJ_COUNT, Integer.class);
                        ArrayList<LineWidth> arrayList = new ArrayList<LineWidth>(n);
                        for (int i = 0; i < n; ++i) {
                            arrayList.add(LineWidth.THINNEST);
                        }
                        return arrayList;
                    }

                    @Override
                    Object getDefaultItem() {
                        return LineWidth.THINNEST;
                    }
                };
            }

            @Override
            PropertyType[] dependencies() {
                return new PropertyType[]{PropertyType.Y2AXIS_REFOBJ_COUNT};
            }

            @Override
            List<LineWidth> getGraphValue(Graph graph) {
                List list = graph.getReferenceObjects(51);
                ArrayList<LineWidth> arrayList = new ArrayList<LineWidth>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    arrayList.add(LineWidth.get(((ReferenceObject)list.get(i)).getLineWidth()));
                }
                return arrayList;
            }

            @Override
            void setGraphValue(Graph graph, List<LineWidth> list) {
                List list2 = graph.getReferenceObjects(51);
                for (int i = 0; i < list2.size(); ++i) {
                    ((ReferenceObject)list2.get(i)).setLineWidth(list.get(i).pixels());
                }
            }

            @Override
            Archiver<List<LineWidth>> archiver() {
                return this.archiver;
            }
        });
    }
}

