/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.BitSet;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Alignment;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.BooleanArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartFont;
import oracle.dbtools.raptor.controls.display.chart.ChartFontArchiver;
import oracle.dbtools.raptor.controls.display.chart.ChartType;
import oracle.dbtools.raptor.controls.display.chart.EnumArchiver;
import oracle.dbtools.raptor.controls.display.chart.PropertyDef;
import oracle.dbtools.raptor.controls.display.chart.PropertyGroup;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.display.chart.StringArchiver;
import oracle.dss.graph.BaseGraphTitle;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTitle;

class TitlesProperties
extends PropertyGroup {
    TitlesProperties() {
    }

    @Override
    void register(Map<PropertyType, PropertyDef> map) {
        BitSet bitSet = ChartType.all();
        map.put(PropertyType.TITLE, new PropertyDef<Boolean>(bitSet){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getTitle().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getTitle().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.TITLE_TEXT, new PropertyDef<String>(bitSet){
            private StringArchiver archiver;
            {
                this.archiver = new StringArchiver();
            }

            @Override
            String getGraphValue(Graph graph) {
                return graph.getTitle().getText();
            }

            @Override
            void setGraphValue(Graph graph, String string) {
                graph.getTitle().setText(string);
            }

            @Override
            Archiver<String> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.TITLE_ALIGNMENT, new PropertyDef<Alignment>(bitSet){
            private EnumArchiver<Alignment> archiver;
            {
                this.archiver = new EnumArchiver(Alignment.class, (Enum[])Alignment.values());
            }

            @Override
            Alignment getGraphValue(Graph graph) {
                return Alignment.get(graph.getTitle().getHorizontalAlignment());
            }

            @Override
            void setGraphValue(Graph graph, Alignment alignment) {
                graph.getTitle().setHorizontalAlignment(alignment.swingConstant());
            }

            @Override
            Archiver<Alignment> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.TITLE_FONT, new PropertyDef<ChartFont>(bitSet){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(((GraphTitle)graph.getTitle()).getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, ((GraphTitle)graph.getTitle()).getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet2 = ChartType.all();
        map.put(PropertyType.SUBTITLE, new PropertyDef<Boolean>(bitSet2){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getSubtitle().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getSubtitle().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.SUBTITLE_TEXT, new PropertyDef<String>(bitSet2){
            private StringArchiver archiver;
            {
                this.archiver = new StringArchiver();
            }

            @Override
            String getGraphValue(Graph graph) {
                return graph.getSubtitle().getText();
            }

            @Override
            void setGraphValue(Graph graph, String string) {
                graph.getSubtitle().setText(string);
            }

            @Override
            Archiver<String> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.SUBTITLE_ALIGNMENT, new PropertyDef<Alignment>(bitSet2){
            private EnumArchiver<Alignment> archiver;
            {
                this.archiver = new EnumArchiver(Alignment.class, (Enum[])Alignment.values());
            }

            @Override
            Alignment getGraphValue(Graph graph) {
                return Alignment.get(graph.getSubtitle().getHorizontalAlignment());
            }

            @Override
            void setGraphValue(Graph graph, Alignment alignment) {
                graph.getSubtitle().setHorizontalAlignment(alignment.swingConstant());
            }

            @Override
            Archiver<Alignment> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.SUBTITLE_FONT, new PropertyDef<ChartFont>(bitSet2){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(((BaseGraphTitle)graph.getSubtitle()).getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, ((BaseGraphTitle)graph.getSubtitle()).getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
        BitSet bitSet3 = ChartType.all();
        map.put(PropertyType.FOOTNOTE, new PropertyDef<Boolean>(bitSet3){
            private BooleanArchiver archiver;
            {
                this.archiver = new BooleanArchiver();
            }

            @Override
            Boolean getGraphValue(Graph graph) {
                return graph.getFootnote().isVisible();
            }

            @Override
            void setGraphValue(Graph graph, Boolean bl) {
                graph.getFootnote().setVisible(bl.booleanValue());
            }

            @Override
            Archiver<Boolean> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.FOOTNOTE_TEXT, new PropertyDef<String>(bitSet3){
            private StringArchiver archiver;
            {
                this.archiver = new StringArchiver();
            }

            @Override
            String getGraphValue(Graph graph) {
                return graph.getFootnote().getText();
            }

            @Override
            void setGraphValue(Graph graph, String string) {
                graph.getFootnote().setText(string);
            }

            @Override
            Archiver<String> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.FOOTNOTE_ALIGNMENT, new PropertyDef<Alignment>(bitSet3){
            private EnumArchiver<Alignment> archiver;
            {
                this.archiver = new EnumArchiver(Alignment.class, (Enum[])Alignment.values());
            }

            @Override
            Alignment getGraphValue(Graph graph) {
                return Alignment.get(graph.getFootnote().getHorizontalAlignment());
            }

            @Override
            void setGraphValue(Graph graph, Alignment alignment) {
                graph.getFootnote().setHorizontalAlignment(alignment.swingConstant());
            }

            @Override
            Archiver<Alignment> archiver() {
                return this.archiver;
            }
        });
        map.put(PropertyType.FOOTNOTE_FONT, new PropertyDef<ChartFont>(bitSet3){
            private ChartFontArchiver archiver;
            {
                this.archiver = new ChartFontArchiver();
            }

            @Override
            PropertyType groupPropertyType() {
                return PropertyType.FONT;
            }

            @Override
            ChartFont getGraphValue(Graph graph) {
                return this.archiver.retrieveValue(((BaseGraphTitle)graph.getFootnote()).getGraphFont());
            }

            @Override
            void setGraphValue(Graph graph, ChartFont chartFont) {
                this.archiver.applyValue(chartFont, ((BaseGraphTitle)graph.getFootnote()).getGraphFont());
            }

            @Override
            Archiver<ChartFont> archiver() {
                return this.archiver;
            }
        });
    }
}

