/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.WorksheetDndOptionPanel;
import oracle.dbtools.raptor.controls.DefaultRaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.OracleColumnDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandlerException;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDProviderRegistry;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Displayable;
import org.stringtemplate.v4.ST;

public class OracleTableDnDHandler
implements RaptorCodeEditorDnDHandler {
    private WorksheetDndOptionPanel m_panel;
    private int m_option = 0;
    private String _worksheetConnectionName;
    private AliasGenerator m_aliasGen;
    private static final int CANCELED = -911;

    @Override
    public String handleDrop(List<Displayable> list) throws RaptorCodeEditorDnDHandlerException {
        return this.getSql(list);
    }

    @Override
    public void setWorksheetConnectionName(String string) {
        this._worksheetConnectionName = string;
    }

    protected boolean isOptionPromptRequired() {
        int n = DBConfig.getInstance().getInt("DRAG_N_DROP_PROMPT");
        return n == 0;
    }

    protected String getSql(List<Displayable> list) throws RaptorCodeEditorDnDHandlerException {
        String string;
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (list != null && list.size() > 0) {
                if (list.get(0) instanceof ObjectNode) {
                    string2 = (String)((ObjectNode)list.get(0)).getProperty("TYPE");
                } else if (list.get(0) instanceof ChildObjectElement) {
                    string2 = (String)((ChildObjectElement)list.get(0)).getProperty("TYPE");
                }
                this.m_option = this.isOptionPromptRequired() ? this.getOption(list, string2) : DBConfig.getInstance().getInt("DRAG_N_DROP_CHOICES");
                if (this.m_option == -911) {
                    return null;
                }
                if (this.m_option == 2 && list.size() > 1) {
                    stringBuilder.append(this.getJoinStatement(list));
                } else {
                    Object object;
                    Object object2;
                    String[] stringArray;
                    String string3;
                    Object object3;
                    Object object4;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                    for (Displayable object5 : list) {
                        String n;
                        if (object5 instanceof ObjectNode) {
                            bl2 = true;
                            object4 = (ObjectNode)object5;
                            object4.ensureOpen();
                            object3 = null;
                            n = ((ObjectNode)object4).getSchemaName();
                            string3 = ((ObjectNode)object4).getObjectName();
                            stringArray = null;
                            object2 = (String)((ObjectNode)object4).getProperty("TYPE");
                            object3 = ((String)object2).equals("VIEW") ? ((ObjectNode)object4).getNodeInstance().listChildren("VIEW_COLUMN") : (((String)object2).equals("MATERIALIZED VIEW") ? ((ObjectNode)object4).getNodeInstance().listChildren("MV_COLUMN") : ((ObjectNode)object4).getNodeInstance().listChildren("COLUMN"));
                            if (object3 != null && object3.size() > 0) {
                                int n2 = 0;
                                stringArray = new String[object3.size()];
                                for (DBChildInstance dBChildInstance : object3) {
                                    stringArray[n2++] = DBUtil.addDoubleQuote((String)((String)dBChildInstance.getProperty("NAME")));
                                }
                            }
                            Object object6 = object = this.m_option == 6 ? "," : DefaultRaptorCodeEditorDnDHandler.NL + " ";
                            if (bl) {
                                stringBuilder.append((String)object);
                            }
                            bl = true;
                            stringBuilder.append(this.getSql(n, string3, stringArray));
                            continue;
                        }
                        if (!(object5 instanceof ChildObjectElement)) continue;
                        if (!bl2) {
                            bl3 = true;
                        }
                        object4 = (ChildObjectElement)object5;
                        object3 = (String[])((ChildObjectElement)((Object)object4)).getProperty("COLUMN_NAME");
                        n = (String)((ChildObjectElement)((Object)object4)).getProperty("OBJECT_NAME");
                        string3 = (String)((ChildObjectElement)((Object)object4)).getProperty("PARENT_TYPE");
                        stringArray = (String)((ChildObjectElement)((Object)object4)).getProperty("SCHEMA");
                        object2 = (String)stringArray + "." + string3 + "." + n;
                        object = (ArrayList)hashMap.get(object2);
                        if (object == null) {
                            object = new ArrayList();
                            ((ArrayList)object).add(object4);
                            hashMap.put(object2, object);
                            continue;
                        }
                        ((ArrayList)object).add(object4);
                    }
                    if (bl3) {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            object4 = (ArrayList)hashMap.get(entry.getKey());
                            object3 = new String[((ArrayList)object4).size()];
                            int n = 0;
                            string3 = "";
                            stringArray = "";
                            object2 = ((ArrayList)object4).iterator();
                            while (object2.hasNext()) {
                                object = (ChildObjectElement)((Object)object2.next());
                                String string4 = DBUtil.addDoubleQuote((String)((String)((ChildObjectElement)((Object)object)).getProperty("COLUMN_NAME")));
                                string3 = DBUtil.addDoubleQuote((String)((String)((ChildObjectElement)((Object)object)).getProperty("OBJECT_NAME")));
                                stringArray = (String)((ChildObjectElement)((Object)object)).getProperty("SCHEMA");
                                object3[n] = string4;
                                ++n;
                            }
                            if (bl) {
                                object2 = this.m_option == 6 ? "," : DefaultRaptorCodeEditorDnDHandler.NL + " ";
                                stringBuilder.append((String)object2);
                            }
                            bl = true;
                            stringBuilder.append(this.getSql((String)stringArray, string3, (String[])object3));
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RaptorCodeEditorDnDHandlerException(exception);
        }
        if ((string = stringBuilder.toString()) == null) {
            string = "";
        }
        return string;
    }

    protected int getOption(List<Displayable> list, String string) {
        DBConfig dBConfig = DBConfig.getInstance();
        this.m_panel = new WorksheetDndOptionPanel();
        this.m_panel.setPrompt(dBConfig.getInt("DRAG_N_DROP_PROMPT"));
        this.m_panel.setDragType(dBConfig.getInt("DRAG_N_DROP_CHOICES"));
        int n = this.m_panel.getDragType();
        if (list != null && list.size() > 1) {
            this.m_panel.enableJoin();
        } else {
            this.m_panel.disableJoin();
            if (n == 2 || n == 1) {
                this.m_panel.setDragType(1);
            }
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JEWTDialog)actionEvent.getSource()).isCancelled()) {
                    OracleTableDnDHandler.this.m_panel.setCancel(true);
                    return;
                }
                if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                    DBConfig dBConfig = DBConfig.getInstance();
                    OracleTableDnDHandler.this.m_panel.setCancel(false);
                    OracleTableDnDHandler.this.m_option = OracleTableDnDHandler.this.m_panel.getDragType();
                    int n = OracleTableDnDHandler.this.m_panel.getPrompt();
                    dBConfig.putInt("DRAG_N_DROP_PROMPT", n);
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        };
        UIUtils.showPanelAsDialog((JPanel)this.m_panel, (String)PreferencesArb.getString("DND_LABEL"), (ActionListener)actionListener, (boolean)true);
        return this.m_panel.isCanceled() ? -911 : this.m_panel.getDragType();
    }

    protected String getSql(String string, String string2, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.isQualifyObjectName(this._worksheetConnectionName, string, this.m_option);
        if (this.m_option == 0) {
            this.m_option = this.getOption(null, null);
        }
        switch (this.m_option) {
            case 1: {
                return this.buildSelectStatement(string, string2, stringArray, bl);
            }
            case 3: {
                return this.buildInsertStatement(string, string2, stringArray, bl);
            }
            case 5: {
                return this.buildDeleteStatement(string, string2, stringArray, bl);
            }
            case 4: {
                return this.buildUpdateStatement(string, string2, stringArray, bl);
            }
            case 6: {
                if (this instanceof OracleColumnDnDHandler) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (String string3 : stringArray) {
                        stringBuilder2.append(bl ? string + "." + string3 : string3);
                        stringBuilder2.append(", ");
                    }
                    return stringBuilder2.length() > 0 ? stringBuilder2.substring(0, stringBuilder2.length() - 2) : "";
                }
                return bl ? string + "." + string2 : string2;
            }
        }
        return stringBuilder.toString();
    }

    protected boolean isQualifyObjectName(String string, String string2, int n) {
        return RaptorCodeEditorDnDProviderRegistry.isQualifyObjectName(this._worksheetConnectionName, string2);
    }

    private String buildSelectStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        ST sT = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "SelectStatement");
        if (sT != null) {
            if (bl) {
                sT.add("objectNames", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                sT.add("objectNames", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            sT.add("colList", (Object)stringArray);
            string3 = sT.render();
        }
        return string3;
    }

    private String buildInsertStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        ST sT = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "InsertStatement");
        if (sT != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                arrayList.add(":v" + i);
            }
            if (bl) {
                sT.add("tableName", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                sT.add("tableName", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            sT.add("valList", arrayList);
            sT.add("colList", (Object)stringArray);
            string3 = sT.render();
        }
        return string3;
    }

    private String buildDeleteStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        ST sT = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "DeleteStatement");
        if (sT != null) {
            int n = 0;
            ArrayList<String> arrayList = null;
            if (stringArray != null) {
                arrayList = new ArrayList<String>();
                for (String string4 : stringArray) {
                    arrayList.add(string4 + " = :v" + n++);
                }
            }
            if (bl) {
                sT.add("tableName", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                sT.add("tableName", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            sT.add("colList", arrayList);
            string3 = sT.render();
        }
        return string3;
    }

    private String buildUpdateStatement(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = null;
        ST sT = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "UpdateStatement");
        if (sT != null) {
            int n = 0;
            ArrayList<String> arrayList = null;
            if (stringArray != null) {
                arrayList = new ArrayList<String>();
                for (String string4 : stringArray) {
                    arrayList.add(string4 + " = :v" + n++);
                }
            }
            if (bl) {
                sT.add("tableName", (Object)(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)string2)));
            } else {
                sT.add("tableName", (Object)DBUtil.addDoubleQuote((String)string2));
            }
            sT.add("colList", arrayList);
            string3 = sT.render();
        }
        return string3;
    }

    private boolean objInDragList(String string, List<ObjectNode> list) {
        if (string != null && list != null) {
            for (ObjectNode objectNode : list) {
                if (!objectNode.getObjectName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private String getAlias(String string, String string2, List<RefPair> list, List<RefPair> list2) {
        if (!(list != null && list.size() != 0 || list2 != null && list2.size() != 0)) {
            return this.getAliasGenerator().getNextAlias();
        }
        String string3 = null;
        ListIterator<RefPair> listIterator = null;
        if (list != null) {
            listIterator = list.listIterator();
        }
        ListIterator<RefPair> listIterator2 = null;
        if (list2 != null) {
            listIterator2 = list2.listIterator();
        }
        RefPair refPair = null;
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        while (string3 == null && listIterator2 != null && listIterator2.hasNext()) {
            refPair = listIterator2.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        if (string3 == null) {
            string3 = this.getAliasGenerator().getNextAlias();
        }
        return string3;
    }

    private AliasGenerator getAliasGenerator() {
        if (this.m_aliasGen == null) {
            this.m_aliasGen = new AliasGenerator();
        }
        return this.m_aliasGen;
    }

    /*
     * Exception decompiling
     */
    private RefPair getRefPairsFromConsName(String var1_1, String var2_2, String var3_3, String var4_4, String var5_5, String var6_6, List<ObjectNode> var7_7, List<RefPair> var8_8, List<RefPair> var9_9) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RefPair> getRefPairsForObjectName(String string, String string2, String string3, List<ObjectNode> list, List<RefPair> list2) throws SQLException {
        String string4 = "select constraint_name, r_constraint_name, r_owner   from all_constraints c where constraint_type = 'R'  and table_name = ?  and owner = ? and r_constraint_name not in (select constraint_name  from all_constraints where table_name = ?  and   owner = ?)";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(string2);
        ArrayList<RefPair> arrayList2 = null;
        RefPair refPair = null;
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        ResultSet resultSet = dBUtil.executeQuery(string4, arrayList);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    String string5;
                    String string6 = resultSet.getString(1);
                    String string7 = resultSet.getString(2);
                    refPair = this.getRefPairsFromConsName(string, string2, string3, string7, string6, string5 = resultSet.getString(3), list, list2, arrayList2);
                    if (refPair == null) continue;
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<RefPair>();
                    }
                    arrayList2.add(refPair);
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        return arrayList2;
    }

    private boolean isObjectPartOfRefPair(String string, List<RefPair> list) {
        RefPair refPair = null;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                refPair = list.get(i);
                if (!refPair.getQuotedPrimTable().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTableColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "select column_name from all_tab_columns where table_name=? AND owner = ?";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        DBUtil dBUtil = DBUtil.getInstance((String)string);
        DatabaseMetaData databaseMetaData = null;
        String string5 = null;
        try {
            databaseMetaData = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
            string5 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        String string6 = null;
        string6 = string2 != null && !string2.equals(string5) ? DBUtil.addDoubleQuote((String)string2) + "." + DBUtil.addDoubleQuote((String)string3) + "." : DBUtil.addDoubleQuote((String)string3) + ".";
        ResultSet resultSet = dBUtil.executeQuery(string4, arrayList);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    arrayList2.add(string6 + DBUtil.addDoubleQuote((String)resultSet.getString(1)));
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        return arrayList2;
    }

    private boolean isObjUnique(String string, String string2, List<String> list) {
        if (list == null) {
            return false;
        }
        Iterator<String> iterator = list.iterator();
        String string3 = null;
        String string4 = null;
        while (iterator != null && iterator.hasNext()) {
            string4 = iterator.next();
            int n = string4.indexOf(".");
            if (n >= 0) {
                string3 = string4.substring(0, n);
                string4 = string4.substring(string4.indexOf(".") + 1, string4.indexOf(" "));
            } else {
                string3 = null;
                string4 = string4.substring(0, string4.indexOf(" "));
            }
            if (string3 != null && !string3.equals(string) || !string4.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private List<String> getRefTables(List<RefPair> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<RefPair> iterator = list.iterator();
        RefPair refPair = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator != null && iterator.hasNext()) {
            refPair = iterator.next();
            stringBuilder.delete(0, stringBuilder.length());
            if (this.isObjUnique(refPair.getQuotedRefTableOwner(), refPair.getQuotedRefTable(), arrayList)) {
                if (string != null && !Connections.getDisplayName(string).equalsIgnoreCase(refPair.getRefTableOwner())) {
                    stringBuilder.append(refPair.getQuotedRefTableOwner());
                    stringBuilder.append(".");
                }
                stringBuilder.append(refPair.getQuotedRefTable());
                stringBuilder.append(" ");
                stringBuilder.append(refPair.getRefAlias());
                arrayList.add(stringBuilder.toString());
            }
            stringBuilder.delete(0, stringBuilder.length());
            if (!this.isObjUnique(refPair.getQuotedPrimTableOwner(), refPair.getQuotedPrimTable(), arrayList)) continue;
            if (string != null && !Connections.getDisplayName(string).equalsIgnoreCase(refPair.getPrimTableOwner())) {
                stringBuilder.append(refPair.getQuotedPrimTableOwner());
                stringBuilder.append(".");
            }
            stringBuilder.append(refPair.getQuotedPrimTable());
            stringBuilder.append(" ");
            stringBuilder.append(refPair.getPrimAlias());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private List<CondObj> getConditionList(List<RefPair> list) {
        Iterator<RefPair> iterator = list.iterator();
        ArrayList<String> arrayList = null;
        ArrayList<CondObj> arrayList2 = null;
        CondObj condObj = null;
        RefPair refPair = null;
        while (iterator != null && iterator.hasNext()) {
            refPair = iterator.next();
            ArrayList<String> arrayList3 = refPair.getPrimCols();
            arrayList = refPair.getRefCols();
            if (arrayList3.size() != arrayList.size()) {
                throw new IllegalStateException(MessageFormat.format(Messages.getString("DnDDropGenerator.19"), arrayList3.size(), arrayList.size(), refPair.getRefTableOwner() + "." + refPair.getRefTable()));
            }
            Iterator iterator2 = arrayList3.iterator();
            Iterator iterator3 = arrayList.iterator();
            while (iterator2 != null && iterator3 != null && iterator2.hasNext() && iterator3.hasNext()) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<CondObj>();
                }
                condObj = new CondObj();
                condObj.setCol1(refPair.getPrimAlias() + "." + DBUtil.addDoubleQuote((String)((String)iterator2.next())));
                condObj.setCol2(refPair.getRefAlias() + "." + DBUtil.addDoubleQuote((String)((String)iterator3.next())));
                arrayList2.add(condObj);
            }
        }
        return arrayList2;
    }

    private String constructJoinSQL(List<String> list, List<String> list2, List<CondObj> list3) {
        String string = null;
        ST sT = null;
        sT = RaptorCodeEditorDnDProviderRegistry.getTemplate("Oracle", "SelectStatement");
        sT.add("colList", list);
        sT.add("objectNames", list2);
        sT.add("cond", (Object)(list3 != null && list3.size() > 0 ? 1 : 0));
        sT.add("condList", list3);
        string = sT.render().trim();
        if (string.endsWith(" AND ;")) {
            string = string.substring(0, string.lastIndexOf(" AND ;")) + ";";
        }
        return string;
    }

    private void ensureAliasPrefixForColumns(List<String> list, List<RefPair> list2) {
        if (list == null || list2 == null) {
            return;
        }
        ListIterator<String> listIterator = list.listIterator();
        Iterator<RefPair> iterator = null;
        RefPair refPair = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        block0: while (listIterator != null && listIterator.hasNext()) {
            string3 = listIterator.next();
            n = string3.indexOf(".");
            if (n != (n2 = string3.lastIndexOf("."))) {
                string = string3.substring(0, n);
                string2 = string3.substring(n + 1, n2);
            } else {
                string = null;
                string2 = string3.substring(0, n);
            }
            string3 = string3.substring(n2 + 1);
            iterator = list2.iterator();
            while (iterator != null && iterator.hasNext()) {
                refPair = iterator.next();
                if ((string == null || string.equals(refPair.getQuotedPrimTableOwner())) && string2.equals(refPair.getQuotedPrimTable())) {
                    listIterator.set(refPair.getPrimAlias() + "." + string3);
                    continue block0;
                }
                if (string != null && !string.equals(refPair.getQuotedRefTableOwner()) || !string2.equals(refPair.getQuotedRefTable())) continue;
                listIterator.set(refPair.getRefAlias() + "." + string3);
                continue block0;
            }
        }
    }

    private String getJoinSql(List<ObjectNode> list, HashMap<String, ArrayList<ChildObjectElement>> hashMap) throws SQLException {
        ArrayList<ChildObjectElement> arrayList;
        Object object;
        Object object2;
        ArrayList<RefPair> arrayList2 = new ArrayList<RefPair>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl = !hashMap.isEmpty();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        List<CondObj> list2 = null;
        List<RefPair> list3 = null;
        Connections connections = Connections.getInstance();
        String string = "";
        for (int i = 0; i < list.size(); ++i) {
            object2 = list.get(i);
            string = ((ObjectNode)object2).getSchemaName();
            list3 = this.getRefPairsForObjectName(((ObjectNode)object2).getConnectionName(), string, ((ObjectNode)object2).getObjectName(), list, arrayList2);
            if (list3 != null) {
                arrayList2.addAll(list3);
            } else if (!this.isObjectPartOfRefPair(((ObjectNode)object2).getObjectName(), arrayList2)) {
                object = null;
                arrayList = null;
                try {
                    object = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
                    arrayList = object.getUserName();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                if (!((String)((Object)arrayList)).equals(string)) {
                    arrayList3.add(DBUtil.addDoubleQuote((String)string) + "." + DBUtil.addDoubleQuote((String)((ObjectNode)object2).getObjectName()));
                } else {
                    arrayList3.add(DBUtil.addDoubleQuote((String)((ObjectNode)object2).getObjectName()));
                }
            }
            if (bl) {
                object = ((ObjectNode)object2).getSchemaName() + "." + ((ObjectNode)object2).getObjectType() + "." + ((ObjectNode)object2).getObjectName();
                arrayList = hashMap.get(object);
                for (ChildObjectElement childObjectElement : arrayList) {
                    arrayList5.add(((ObjectNode)object2).getObjectName() + "." + (String)childObjectElement.getProperty("COLUMN_NAME"));
                }
                continue;
            }
            arrayList5.addAll(this.getTableColumns(((ObjectNode)object2).getConnectionName(), string, ((ObjectNode)object2).getObjectName()));
        }
        DatabaseMetaData databaseMetaData = null;
        object2 = null;
        try {
            databaseMetaData = Connections.getInstance().getConnection(this._worksheetConnectionName).getMetaData();
            object2 = databaseMetaData.getUserName();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        object = this.getRefTables(arrayList2, (String)object2);
        arrayList4.addAll((Collection<String>)object);
        arrayList = null;
        arrayList = arrayList3.listIterator();
        while (arrayList != null && arrayList.hasNext()) {
            if (this.isUnique(arrayList2, (String)arrayList.next())) continue;
            arrayList.remove();
        }
        arrayList4.addAll(arrayList3);
        this.ensureAliasPrefixForColumns(arrayList5, arrayList2);
        list2 = this.getConditionList(arrayList2);
        return this.constructJoinSQL(arrayList5, arrayList4, list2);
    }

    private boolean isUnique(List<RefPair> list, String string) {
        RefPair refPair = null;
        String string2 = null;
        String string3 = null;
        if (string == null || list == null) {
            return true;
        }
        int n = 0;
        n = string.indexOf(".");
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string3 = string;
        }
        ListIterator<RefPair> listIterator = list.listIterator();
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if ((string2 != null && !string2.equals(refPair.getQuotedPrimTableOwner()) || !string3.equals(refPair.getQuotedPrimTable())) && (string2 != null && !string2.equals(refPair.getQuotedRefTableOwner()) || !string3.equals(refPair.getQuotedRefTable()))) continue;
            return false;
        }
        return true;
    }

    private String getJoinStatement(List<Displayable> list) throws IOException, UnsupportedFlavorException, SQLException {
        String string = null;
        ArrayList<ObjectNode> arrayList = new ArrayList<ObjectNode>();
        HashMap<String, ArrayList<ChildObjectElement>> hashMap = new HashMap<String, ArrayList<ChildObjectElement>>();
        for (int i = 0; i < list.size(); ++i) {
            Displayable displayable = list.get(i);
            if (displayable instanceof ObjectNode) {
                arrayList.add((ObjectNode)displayable);
                continue;
            }
            if (!(displayable instanceof ChildObjectElement)) continue;
            ChildObjectElement childObjectElement = (ChildObjectElement)displayable;
            URL uRL = childObjectElement.getURL();
            String string2 = DBURLFormatHelper.getConnectionName(uRL);
            String string3 = (String)childObjectElement.getProperty("COLUMN_NAME");
            String string4 = (String)childObjectElement.getProperty("OBJECT_NAME");
            String string5 = (String)childObjectElement.getProperty("PARENT_TYPE");
            String string6 = (String)childObjectElement.getProperty("SCHEMA");
            String string7 = string6 + "." + string5 + "." + string4;
            ArrayList<ChildObjectElement> arrayList2 = hashMap.get(string7);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
                arrayList2.add(childObjectElement);
                hashMap.put(string7, arrayList2);
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string2, null, string6, string5);
                ObjectNode objectNode = (ObjectNode)DatabaseNavigatorElementFactory.getObjectNode(DBURLFormatHelper.getURL(uRL2, string4));
                arrayList.add(objectNode);
                continue;
            }
            arrayList2.add(childObjectElement);
        }
        string = this.getJoinSql(arrayList, hashMap);
        return string;
    }

    private class AliasGenerator {
        private int cloneCount = 0;
        private int pos = 0;
        private String aliasString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private StringBuilder sb = new StringBuilder();

        private AliasGenerator() {
        }

        String getNextAlias() {
            String string = null;
            this.sb.delete(0, this.sb.length());
            if (this.pos < this.aliasString.length() - 1) {
                this.sb.append(this.aliasString.substring(this.pos, this.pos + 1));
            } else {
                this.sb.append(this.aliasString.substring(this.pos));
            }
            ++this.pos;
            string = this.sb.toString();
            for (int i = 0; i < this.cloneCount; ++i) {
                this.sb.append(string);
            }
            if (this.pos > this.aliasString.length() - 1) {
                this.pos %= this.aliasString.length();
                ++this.cloneCount;
            }
            return this.sb.toString();
        }
    }

    private static class CondObj {
        private String col1;
        private String col2;

        private CondObj() {
        }

        public String getCol1() {
            return this.col1;
        }

        public String getCol2() {
            return this.col2;
        }

        void setCol1(String string) {
            this.col1 = string;
        }

        void setCol2(String string) {
            this.col2 = string;
        }
    }

    private static class RefPair {
        private String ref_Tab_Owner;
        private String ref_TableName;
        private String ref_Constraint_Name;
        private ArrayList<String> ref_Tab_Col;
        private String ref_Tab_Alias;
        private String prim_Tab_Owner;
        private String prim_TableName;
        private String prim_Constraint_Name;
        private ArrayList<String> prim_Tab_Col;
        private String prim_Tab_Alias;

        private RefPair() {
        }

        String getRefTableOwner() {
            return this.ref_Tab_Owner;
        }

        String getQuotedRefTableOwner() {
            return DBUtil.addDoubleQuote((String)this.ref_Tab_Owner);
        }

        String getRefTable() {
            return this.ref_TableName;
        }

        String getQuotedRefTable() {
            return DBUtil.addDoubleQuote((String)this.ref_TableName);
        }

        String getRefConstName() {
            return this.ref_Constraint_Name;
        }

        ArrayList<String> getRefCols() {
            return this.ref_Tab_Col;
        }

        String getRefAlias() {
            return this.ref_Tab_Alias;
        }

        String getPrimTableOwner() {
            return this.prim_Tab_Owner;
        }

        String getQuotedPrimTableOwner() {
            return DBUtil.addDoubleQuote((String)this.prim_Tab_Owner);
        }

        String getPrimTable() {
            return this.prim_TableName;
        }

        String getQuotedPrimTable() {
            return DBUtil.addDoubleQuote((String)this.prim_TableName);
        }

        ArrayList<String> getPrimCols() {
            return this.prim_Tab_Col;
        }

        String getPrimAlias() {
            return this.prim_Tab_Alias;
        }

        String getPrimConstName() {
            return this.prim_Constraint_Name;
        }

        void setRefTableOwner(String string) {
            this.ref_Tab_Owner = string;
        }

        void setRefTable(String string) {
            this.ref_TableName = string;
        }

        void setRefConstName(String string) {
            this.ref_Constraint_Name = string;
        }

        void setRefCols(ArrayList<String> arrayList) {
            this.ref_Tab_Col = arrayList;
        }

        void addRefCol(String string) {
            this.ref_Tab_Col.add(string);
        }

        void setRefAlias(String string) {
            this.ref_Tab_Alias = string;
        }

        void setPrimTableOwner(String string) {
            this.prim_Tab_Owner = string;
        }

        void setPrimTable(String string) {
            this.prim_TableName = string;
        }

        void addPrimCol(String string) {
            this.prim_Tab_Col.add(string);
        }

        void setPrimCols(ArrayList<String> arrayList) {
            this.prim_Tab_Col = arrayList;
        }

        void setPrimAlias(String string) {
            this.prim_Tab_Alias = string;
        }

        void setPrimConstName(String string) {
            this.prim_Constraint_Name = string;
        }

        String getQualifiedPrimTableCol(String string) {
            return this.prim_Tab_Alias + "." + this.prim_TableName + "." + string;
        }

        String getQualifiedRefTableCol(String string) {
            return this.ref_Tab_Alias + "." + this.ref_TableName + "." + this.ref_Tab_Col;
        }
    }
}

